/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.cs;

import com.teamscale.index.dependencies.DependencyExtractorBase;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.cs.CsTypeVisitorBase;
import com.teamscale.index.dependencies.type.AttributeDefinition;
import com.teamscale.index.dependencies.type.Type;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.IShallowEntityVisitor;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

public class CsDependencyExtractor
extends DependencyExtractorBase {
    private static final EnumSet<ETokenType> PRIMITIVE_TYPE_KEYWORDS = EnumSet.of(ETokenType.BYTE, new ETokenType[]{ETokenType.SBYTE, ETokenType.INT, ETokenType.UINT, ETokenType.SHORT, ETokenType.USHORT, ETokenType.LONG, ETokenType.ULONG, ETokenType.FLOAT, ETokenType.DOUBLE, ETokenType.CHAR, ETokenType.BOOL, ETokenType.OBJECT, ETokenType.STRING, ETokenType.DECIMAL});
    private static final EnumSet<ETokenType> TYPE_DECLARATION_KEYWORDS = EnumSet.of(ETokenType.CLASS, ETokenType.VOID, ETokenType.INTERFACE, ETokenType.ENUM, ETokenType.RECORD);
    private final PairList<String, ElementLocation> importedElements = new PairList();
    private final Map<String, String> usingAliases = new HashMap<String, String>();
    private final List<TypeDependencies> typeDependencies = new ArrayList<TypeDependencies>();

    @Override
    public List<TypeDependencies> extractDependencies(TokenElementInfo tokenElementInfo) {
        this.reset();
        ShallowEntity.traverse(tokenElementInfo.getRawShallowEntities(), (IShallowEntityVisitor)new DependencyExtractingTypeVisitor());
        return this.typeDependencies;
    }

    private void reset() {
        this.typeDependencies.clear();
        this.usingAliases.clear();
        this.importedElements.clear();
    }

    private class DependencyExtractingTypeVisitor
    extends CsTypeVisitorBase {
        private boolean inClassConstructorCall;
        private boolean inTypeOfExpression;
        private Set<String> attributes;

        protected DependencyExtractingTypeVisitor() {
            super(false);
            this.inClassConstructorCall = false;
            this.inTypeOfExpression = false;
            this.attributes = CollectionUtils.emptySet();
        }

        @Override
        public boolean visit(ShallowEntity entity) {
            super.visit(entity);
            if (this.isUsingStatement(entity)) {
                this.visitUsingStatement(entity);
            } else if (this.isAnnotation(entity)) {
                this.collectIdentifiers(entity);
            }
            return true;
        }

        private void visitUsingStatement(ShallowEntity entity) {
            ArrayList<String> parts = new ArrayList<String>();
            UnmodifiableList tokens = entity.includedTokens();
            String alias = null;
            boolean staticUsing = false;
            for (int i = 1; i < tokens.size() - 1; ++i) {
                IToken token = (IToken)tokens.get(i);
                if (token.getType() == ETokenType.EQ) {
                    alias = StringUtils.concat(parts, (String)"");
                    parts.clear();
                    continue;
                }
                if (token.getType() == ETokenType.STATIC) {
                    staticUsing = true;
                    continue;
                }
                parts.add(token.getText());
            }
            String importedElement = StringUtils.concat(parts, (String)"");
            if (alias != null && !alias.equals(importedElement)) {
                CsDependencyExtractor.this.usingAliases.put(alias, importedElement);
            } else if (staticUsing) {
                this.collectIdentifiers(entity);
            } else {
                CsDependencyExtractor.this.importedElements.add((Object)this.resolveImportedNamespace(this.getCurrentNamespace(), importedElement), (Object)DependencyExtractorBase.createLocation(CsDependencyExtractor.this.uniformPath, (List<IToken>)tokens));
            }
        }

        private String resolveImportedNamespace(String currentNamespace, String importedNamespace) {
            if (CsDependencyExtractor.this.typeLookupEnvironment.hasTypeWithPrefix(importedNamespace + ".") || StringUtils.isEmpty((String)currentNamespace)) {
                return importedNamespace;
            }
            String qualifiedNamespace = DependencyExtractingTypeVisitor.toQualifiedName(currentNamespace, importedNamespace);
            if (CsDependencyExtractor.this.typeLookupEnvironment.hasTypeWithPrefix(qualifiedNamespace + ".")) {
                return qualifiedNamespace;
            }
            if (currentNamespace.indexOf(46) != -1) {
                return this.resolveImportedNamespace(StringUtils.removeLastPart((String)currentNamespace, (char)'.'), importedNamespace);
            }
            return importedNamespace;
        }

        private boolean isUsingStatement(ShallowEntity entity) {
            return entity.getType() == EShallowEntityType.META && entity.getSubtype().equals(ETokenType.USING.name().toLowerCase());
        }

        private boolean isAnnotation(ShallowEntity entity) {
            return entity.getType() == EShallowEntityType.META && entity.getSubtype().equals("attribute annotation");
        }

        @Override
        protected void visitType(ShallowEntity entity) {
            String namespace = this.getCurrentNamespace();
            String currentType = DependencyExtractingTypeVisitor.toQualifiedName(namespace, entity.getName());
            this.attributes = this.getAllAttributeNames(namespace, currentType, new HashSet<String>());
            this.collectIdentifiers(entity);
            ListMap dependencies = new ListMap();
            this.collectDependenciesFromIdentifiers(namespace, currentType, (ListMap<String, ElementLocation>)dependencies);
            if (((CsDependencyExtractor)CsDependencyExtractor.this).settings.includeThirdPartyDependencies) {
                this.collectThirdPartyDependencies((ListMap<String, ElementLocation>)dependencies);
            }
            CsDependencyExtractor.this.typeDependencies.add(new TypeDependencies(currentType, (ListMap<String, ElementLocation>)dependencies));
            CsDependencyExtractor.this.inIdentifier = false;
            CsDependencyExtractor.this.currentIdentifierTokens.clear();
            CsDependencyExtractor.this.identifiers.clear();
        }

        private Set<String> getAllAttributeNames(String namespace, String typeName, Set<String> seenTypes) {
            if (seenTypes.contains(typeName)) {
                return CollectionUtils.emptySet();
            }
            seenTypes.add(typeName);
            HashSet<String> attributeNames = new HashSet<String>();
            Type type = CsDependencyExtractor.this.typeLookupEnvironment.lookupType(typeName);
            if (type != null) {
                attributeNames.addAll(this.getOwnAttributes(type).stream().map(attribute -> attribute.name).collect(Collectors.toSet()));
                attributeNames.addAll(this.getAllAttributeNamesFromSuperTypes(namespace, type, seenTypes));
            }
            return attributeNames;
        }

        private List<AttributeDefinition> getOwnAttributes(Type type) {
            List<AttributeDefinition> attributes = type.getAttributes();
            if (attributes == null) {
                return CollectionUtils.emptyList();
            }
            return attributes;
        }

        private Set<String> getAllAttributeNamesFromSuperTypes(String namespace, Type type, Set<String> seenTypes) {
            List<String> superTypes = type.getSuperTypes();
            if (superTypes == null) {
                return CollectionUtils.emptySet();
            }
            HashSet<String> result = new HashSet<String>();
            for (String superType : superTypes) {
                Optional<String> resolvedSuperType = this.resolveType(superType, namespace, type.getName());
                if (!resolvedSuperType.isPresent()) continue;
                String superTypeNamespace = StringUtils.removeLastPart((String)resolvedSuperType.get(), (char)'.');
                result.addAll(this.getAllAttributeNames(superTypeNamespace, resolvedSuperType.get(), seenTypes));
            }
            return result;
        }

        private void collectThirdPartyDependencies(ListMap<String, ElementLocation> dependencies) {
            for (int i = 0; i < CsDependencyExtractor.this.importedElements.size(); ++i) {
                String importedNamespace = (String)CsDependencyExtractor.this.importedElements.getFirst(i);
                if (CsDependencyExtractor.this.typeLookupEnvironment.hasTypeWithPrefix(importedNamespace + ".")) continue;
                dependencies.add((Object)importedNamespace, (Object)((ElementLocation)CsDependencyExtractor.this.importedElements.getSecond(i)));
            }
        }

        private void collectDependenciesFromIdentifiers(String namespace, String currentType, ListMap<String, ElementLocation> dependencies) {
            for (int i = 0; i < CsDependencyExtractor.this.identifiers.size(); ++i) {
                String identifier = (String)CsDependencyExtractor.this.identifiers.getFirst(i);
                Optional<String> resolvedType = this.resolveType(identifier, namespace, currentType);
                if (!resolvedType.isPresent() || resolvedType.get().equals(currentType)) continue;
                dependencies.add((Object)resolvedType.get(), (Object)((ElementLocation)CsDependencyExtractor.this.identifiers.getSecond(i)));
            }
        }

        private void collectIdentifiers(ShallowEntity entity) {
            for (IToken token : entity.ownStartTokens()) {
                this.visitToken(token);
            }
            for (ShallowEntity childEntity : entity.getChildren()) {
                if (this.isType(childEntity)) continue;
                Object includedTokens = childEntity.includedTokens();
                if (this.isEnumLiteral(childEntity) && !includedTokens.isEmpty()) {
                    includedTokens = includedTokens.subList(1, includedTokens.size());
                }
                for (IToken token : includedTokens) {
                    this.visitToken(token);
                }
            }
            if (entity.hasChildren()) {
                for (IToken token : entity.ownEndTokens()) {
                    this.visitToken(token);
                }
            }
        }

        private boolean isEnumLiteral(ShallowEntity entity) {
            return entity.getType() == EShallowEntityType.ATTRIBUTE && entity.getSubtype().equals("enum literal");
        }

        private boolean isType(ShallowEntity entity) {
            return entity.getType() == EShallowEntityType.TYPE && TYPE_SUBTYPES.contains(entity.getSubtype());
        }

        private void visitToken(IToken token) {
            switch (token.getType()) {
                case IDENTIFIER: {
                    this.handleIdentifier(token);
                    break;
                }
                case DOT: {
                    CsDependencyExtractor.this.addNamespaceSeparatorIfInIdentifier(token);
                    break;
                }
                case LBRACK: {
                    this.inClassConstructorCall = false;
                    break;
                }
                default: {
                    this.handleToken(token);
                }
            }
            CsDependencyExtractor.this.previousTokenType = token.getType();
        }

        private void handleIdentifier(IToken identifierToken) {
            if (CsDependencyExtractor.this.previousTokenType == ETokenType.IDENTIFIER && !CsDependencyExtractor.this.currentIdentifierTokens.isEmpty()) {
                CsDependencyExtractor.this.addCurrentIdentifier(CsDependencyExtractor.this.uniformPath);
                CsDependencyExtractor.this.currentIdentifierTokens.clear();
            } else if (PRIMITIVE_TYPE_KEYWORDS.contains(CsDependencyExtractor.this.previousTokenType) || TYPE_DECLARATION_KEYWORDS.contains(CsDependencyExtractor.this.previousTokenType)) {
                CsDependencyExtractor.this.currentIdentifierTokens.clear();
            } else if (CsDependencyExtractor.this.previousTokenType == ETokenType.DOT) {
                String previousIdentifier = StringUtils.stripSuffix((String)CsDependencyExtractor.this.getCurrentIdentifierText(), (String)".");
                if (this.attributes.contains(previousIdentifier)) {
                    CsDependencyExtractor.this.currentIdentifierTokens.clear();
                } else if (!CsDependencyExtractor.this.currentIdentifierTokens.isEmpty()) {
                    CsDependencyExtractor.this.currentIdentifierTokens.add(identifierToken);
                }
            } else {
                CsDependencyExtractor.this.currentIdentifierTokens.clear();
                CsDependencyExtractor.this.currentIdentifierTokens.add(identifierToken);
            }
            CsDependencyExtractor.this.inIdentifier = true;
        }

        private void handleToken(IToken token) {
            if (token.getType() == ETokenType.NEW) {
                this.inClassConstructorCall = true;
            }
            if (token.getType() == ETokenType.TYPEOF) {
                this.inTypeOfExpression = true;
            }
            if (CsDependencyExtractor.this.inIdentifier && !CsDependencyExtractor.this.currentIdentifierTokens.isEmpty()) {
                this.handleTokenInIdentifier(token);
            }
            CsDependencyExtractor.this.inIdentifier = false;
        }

        private void handleTokenInIdentifier(IToken token) {
            boolean isMethodCall;
            boolean bl = isMethodCall = token.getType() == ETokenType.LPAREN && !this.inClassConstructorCall;
            if (isMethodCall || token.getType() == ETokenType.EQ) {
                if (TokenStreamUtils.lastTokenMatching((List)CsDependencyExtractor.this.currentIdentifierTokens, (ITokenMatcher)ETokenType.DOT) != -1) {
                    CsDependencyExtractor.this.removeLastPartOfCurrentIdentifier(ETokenType.DOT);
                    if (!CsDependencyExtractor.this.currentIdentifierTokens.isEmpty()) {
                        CsDependencyExtractor.this.addCurrentIdentifier(CsDependencyExtractor.this.uniformPath);
                    }
                }
            } else if (this.inTypeOfExpression || !this.attributes.contains(CsDependencyExtractor.this.getCurrentIdentifierText())) {
                CsDependencyExtractor.this.addCurrentIdentifier(CsDependencyExtractor.this.uniformPath);
            }
            this.inClassConstructorCall = false;
            this.inTypeOfExpression = false;
            CsDependencyExtractor.this.currentIdentifierTokens.clear();
        }

        private Optional<String> resolveType(String identifier, String ownNamespace, String ownType) {
            if (CsDependencyExtractor.this.typeLookupEnvironment.isKnownType(identifier)) {
                return Optional.of(identifier);
            }
            if (CsDependencyExtractor.this.usingAliases.containsKey(identifier)) {
                return this.resolveType(CsDependencyExtractor.this.usingAliases.get(identifier), ownNamespace, ownType);
            }
            Optional<String> type = this.resolveUnqualifiedType(identifier, ownNamespace, ownType);
            if (type.isPresent()) {
                return type;
            }
            type = this.resolveTypeViaNamespaceAlias(identifier, ownNamespace, ownType);
            if (type.isPresent()) {
                return type;
            }
            if (identifier.indexOf(46) != -1 && !this.hasSelfExpandingAlias(identifier) && (type = this.resolveType(StringUtils.removeLastPart((String)identifier, (char)'.'), ownNamespace, ownType)).isPresent()) {
                return type;
            }
            String namespace = ownNamespace;
            while (namespace.indexOf(46) != -1) {
                namespace = StringUtils.removeLastPart((String)namespace, (char)'.');
                String qualifiedName = namespace + "." + identifier;
                if (!CsDependencyExtractor.this.typeLookupEnvironment.isKnownType(qualifiedName)) continue;
                return Optional.of(qualifiedName);
            }
            return Optional.empty();
        }

        private boolean hasSelfExpandingAlias(String identifier) {
            for (String alias : CsDependencyExtractor.this.usingAliases.keySet()) {
                if (!identifier.startsWith(alias) || !CsDependencyExtractor.this.usingAliases.get(alias).startsWith(alias)) continue;
                return true;
            }
            return false;
        }

        private Optional<String> resolveTypeViaNamespaceAlias(String identifier, String ownNamespace, String ownType) {
            for (String alias : CsDependencyExtractor.this.usingAliases.keySet()) {
                if (!identifier.startsWith(alias + ".")) continue;
                String namespace = CsDependencyExtractor.this.usingAliases.get(alias);
                String typeName = namespace + StringUtils.stripPrefix((String)identifier, (String)alias);
                if (namespace.startsWith(alias) && identifier.startsWith(alias)) {
                    return Optional.empty();
                }
                return this.resolveType(typeName, ownNamespace, ownType);
            }
            return Optional.empty();
        }

        private Optional<String> resolveUnqualifiedType(String identifier, String ownNamespace, String ownType) {
            String innerType = DependencyExtractingTypeVisitor.toQualifiedName(ownType, identifier);
            if (CsDependencyExtractor.this.typeLookupEnvironment.isKnownType(innerType)) {
                return Optional.of(innerType);
            }
            String type = DependencyExtractingTypeVisitor.toQualifiedName(ownNamespace, identifier);
            if (CsDependencyExtractor.this.typeLookupEnvironment.isKnownType(type)) {
                return Optional.of(type);
            }
            for (String importedNamespace : CsDependencyExtractor.this.importedElements.extractFirstList()) {
                type = DependencyExtractingTypeVisitor.toQualifiedName(importedNamespace, identifier);
                if (!CsDependencyExtractor.this.typeLookupEnvironment.isKnownType(type)) continue;
                return Optional.of(type);
            }
            if (ownNamespace.indexOf(46) != -1) {
                return this.resolveUnqualifiedType(identifier, StringUtils.removeLastPart((String)ownNamespace, (char)'.'), ownType);
            }
            return Optional.empty();
        }
    }
}

