/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.update;

import com.teamscale.core.committree.CommitTreeNode;
import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.index.repository.TimestampAdjustmentIndex;
import com.teamscale.index.repository.committree.ICommitTreeNodeAdjuster;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;

public abstract class NodeSkippingAdjusterBase
implements ICommitTreeNodeAdjuster {
    protected final Map<String, Long> branchToFirstCodeCommit;
    protected final TimestampAdjustmentIndex timestampAdjustmentIndex;
    private final Consumer<CommitTreeNode> skipListener;

    protected NodeSkippingAdjusterBase(Map<String, Long> branchToFirstCodeCommit, TimestampAdjustmentIndex timestampAdjustmentIndex, Consumer<CommitTreeNode> skipListener) {
        this.branchToFirstCodeCommit = branchToFirstCodeCommit;
        this.timestampAdjustmentIndex = timestampAdjustmentIndex;
        this.skipListener = skipListener;
    }

    protected void adjustTimestampAndSkipIfBeforeFirstCodeCommit(CommitTreeNode node) throws StorageException {
        CCSMAssert.isFalse((boolean)node.hasUnprocessedParents(), () -> "Can't adjust or skip node with unprocessed parents: " + String.valueOf(node));
        this.timestampAdjustmentIndex.adjustTimestamp(node.getOriginalTimestamp(), node);
        String branchName = node.getBranchName();
        if (!this.branchToFirstCodeCommit.containsKey(branchName) || node.getOriginalTimestamp() < this.branchToFirstCodeCommit.get(branchName)) {
            node.setSkipped();
            this.skipListener.accept(node);
        }
    }

    protected final List<CommitTreeNode> getNodesToAdjustBottomToTop(List<CommitTreeNode> nodes) {
        List<CommitTreeNode> includedNodes = this.getIncludedUnprocessedNodes(nodes);
        Set<CommitTreeNode> reachableNodes = NodeSkippingAdjusterBase.computeReachableUnprocessedParents(includedNodes);
        return ICommitTreeNodeAdjuster.sortNodesInAdjustmentOrder(reachableNodes);
    }

    private List<CommitTreeNode> getIncludedUnprocessedNodes(List<CommitTreeNode> nodes) {
        ArrayList<CommitTreeNode> includedNodes = new ArrayList<CommitTreeNode>();
        for (CommitTreeNode node : nodes) {
            if (node.getState() != ECommitTreeNodeState.UNPROCESSED || !this.branchToFirstCodeCommit.containsKey(node.getBranchName())) continue;
            includedNodes.add(node);
        }
        return includedNodes;
    }

    private static Set<CommitTreeNode> computeReachableUnprocessedParents(List<CommitTreeNode> includedNodes) {
        HashSet<CommitTreeNode> seenNodes = new HashSet<CommitTreeNode>();
        ArrayDeque<CommitTreeNode> nodesToProcess = new ArrayDeque<CommitTreeNode>(includedNodes);
        while (!nodesToProcess.isEmpty()) {
            CommitTreeNode currentNode = (CommitTreeNode)nodesToProcess.poll();
            if (currentNode.getState() != ECommitTreeNodeState.UNPROCESSED || !seenNodes.add(currentNode)) continue;
            for (CommitTreeNode parent : currentNode.getParents()) {
                if (seenNodes.contains(parent)) continue;
                nodesToProcess.add(parent);
            }
        }
        return seenNodes;
    }
}

