/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.calculation;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.tracking.ExtendedTrackedFinding;
import jakarta.ws.rs.core.MediaType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.html.EHTMLAttribute;
import org.conqat.lib.commons.html.EHTMLElement;
import org.conqat.lib.commons.html.HTMLWriter;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

@ExportToTypeScript
public enum EFindingsExportFormat {
    CSV(MoreMediaTypes.TEXT_CSV_TYPE, "csv"){

        @Override
        public String createPayload(List<ExtendedTrackedFinding> findings, TeamscaleCommitLinkProvider linkProvider, CommitDescriptor exportCommit) {
            StringBuilder builder = new StringBuilder();
            List<Object> columns = 1.buildCommonColumns();
            List<String> allFindingProperties = EFindingsExportFormat.getAllFindingProperties(findings);
            columns.addAll(allFindingProperties);
            1.writeCsvRow(builder, columns);
            for (ExtendedTrackedFinding finding : findings) {
                FindingBlacklistInfo blacklistInfo = finding.getBlacklistInfo().orElse(null);
                ArrayList<Object> row = new ArrayList<Object>(Arrays.asList(finding.getId(), finding.getCategoryName(), finding.getGroupName(), finding.getTypeId(), finding.getMessage(), finding.getLocationString(), finding.getAssessment(), finding.getBirthCommit(), EFindingsExportFormat.stringify(blacklistInfo, f -> f.getType().getReadableName()), EFindingsExportFormat.stringify(blacklistInfo, f -> DateTimeUtils.getUiFormattedDateString((long)f.getTimestamp())), EFindingsExportFormat.stringify(blacklistInfo, FindingBlacklistInfo::getUser), EFindingsExportFormat.stringify(blacklistInfo, FindingBlacklistInfo::getRationale), !finding.isAlive(), exportCommit));
                Map<String, Object> properties = finding.getPropertiesWithoutBlacklistProperties();
                row.addAll(CollectionUtils.map(allFindingProperties, key -> properties.getOrDefault(key, "")));
                1.writeCsvRow(builder, row);
            }
            return builder.toString();
        }

        private static @NonNull List<Object> buildCommonColumns() {
            String flaggedByHeader = "Flagged By";
            String flagRationaleHeader = "Flag Rationale";
            if (EFeatureToggle.BMW_BUILD_SCRIPT_COMPATIBILITY_MODE.isEnabled()) {
                flaggedByHeader = "False Positive Reporter";
                flagRationaleHeader = "False Positive Rationale";
            }
            return new ArrayList<Object>(Arrays.asList("Finding ID", "Category", "Group", "Type", "Message", "Location", "Assessment", "Since", "Flag Type", "Flag Timestamp", flaggedByHeader, flagRationaleHeader, "Resolved", "Export Commit"));
        }

        private static void writeCsvRow(StringBuilder builder, List<Object> entries) {
            for (Object entry : entries) {
                String escapedValue = String.valueOf(entry).replace("\"", "\"\"");
                builder.append('\"').append(escapedValue).append('\"').append(';');
            }
            builder.append("\n");
        }
    }
    ,
    MATLAB(MediaType.TEXT_HTML_TYPE, "matlab.html"){

        @Override
        public String createPayload(List<ExtendedTrackedFinding> findings, TeamscaleCommitLinkProvider linkProvider, CommitDescriptor exportCommit) {
            StringWriter stringWriter = new StringWriter();
            HTMLWriter writer = new HTMLWriter(new PrintWriter(stringWriter));
            writer.addStdHeader();
            writer.openElement((Enum)EHTMLElement.HTML);
            writer.openElement((Enum)EHTMLElement.BODY);
            writer.openElement((Enum)EHTMLElement.TABLE, new Object[]{EHTMLAttribute.BORDER, 1});
            writer.openElement((Enum)EHTMLElement.TR);
            writer.addClosedTextElement((Enum)EHTMLElement.TH, "Message", new Object[0]);
            writer.addClosedTextElement((Enum)EHTMLElement.TH, "Location", new Object[0]);
            writer.closeElement((Enum)EHTMLElement.TR);
            for (TrackedFinding trackedFinding : findings) {
                if (!SimulinkUtils.isSimulinkModelPath((String)trackedFinding.getLocation().getUniformPath())) continue;
                writer.openElement((Enum)EHTMLElement.TR);
                String findingUrl = linkProvider.createFindingsDetailLink(trackedFinding.getId());
                2.writeLinkCell(trackedFinding.getMessage(), findingUrl, writer);
                2.writeLinkCell(trackedFinding.getLocationString(), 2.getMatlabLocationUrl(trackedFinding.getLocation()), writer);
                writer.closeElement((Enum)EHTMLElement.TR);
            }
            writer.closeElement((Enum)EHTMLElement.TABLE);
            writer.closeElement((Enum)EHTMLElement.BODY);
            writer.closeElement((Enum)EHTMLElement.HTML);
            writer.close();
            return stringWriter.toString();
        }

        private static String getMatlabLocationUrl(ElementLocation location) {
            StringBuilder builder = new StringBuilder();
            builder.append("matlab:");
            if (location instanceof QualifiedNameLocation) {
                String qualifiedName = ((QualifiedNameLocation)location).getQualifiedName();
                String modelName = StringUtils.removeLastPart((String)qualifiedName, (char)'/');
                builder.append("open_system('").append(modelName).append("'); hilite_system('").append(qualifiedName).append("', 'find')");
            } else {
                String modelName = StringUtils.removeLastPart((String)UniformPathUtils.getElementName((String)location.getUniformPath()), (char)'.');
                builder.append("open_system('").append(modelName).append("')");
            }
            return builder.toString();
        }

        private static void writeLinkCell(String text, String url, HTMLWriter writer) {
            writer.openElement((Enum)EHTMLElement.TD);
            writer.addClosedTextElement((Enum)EHTMLElement.A, text, new Object[]{EHTMLAttribute.HREF, url});
            writer.closeElement((Enum)EHTMLElement.TD);
        }
    }
    ,
    JSON(MediaType.APPLICATION_JSON_TYPE, "json"){

        @Override
        public List<Map<String, Object>> createPayload(List<ExtendedTrackedFinding> findings, TeamscaleCommitLinkProvider linkProvider, CommitDescriptor exportCommit) {
            ArrayList<Map<String, Object>> findingsExport = new ArrayList<Map<String, Object>>();
            List<String> allFindingProperties = EFindingsExportFormat.getAllFindingProperties(findings);
            for (ExtendedTrackedFinding finding : findings) {
                HashMap<String, Object> exportedFinding = new HashMap<String, Object>();
                findingsExport.add(exportedFinding);
                Optional<FindingBlacklistInfo> blacklistInfo = finding.getBlacklistInfo();
                exportedFinding.put("Finding ID", finding.getId());
                exportedFinding.put("Category", finding.getCategoryName());
                exportedFinding.put("Group", finding.getGroupName());
                exportedFinding.put("Type", finding.getTypeId());
                exportedFinding.put("Message", finding.getMessage());
                exportedFinding.put("Location", finding.getLocationString());
                exportedFinding.put("Assessment", finding.getAssessment());
                exportedFinding.put("Since", finding.getBirthCommit());
                if (blacklistInfo.isPresent()) {
                    exportedFinding.put("Flag Type", blacklistInfo.get().getType().getReadableName());
                    exportedFinding.put("Flag Timestamp", DateTimeUtils.getUiFormattedDateString((long)blacklistInfo.get().getTimestamp()));
                    exportedFinding.put("Flagged By", blacklistInfo.get().getUser());
                    exportedFinding.put("Flag Rationale", blacklistInfo.get().getRationale());
                }
                Map<String, Object> properties = finding.getPropertiesWithoutBlacklistProperties();
                for (String findingProperty : allFindingProperties) {
                    exportedFinding.put(findingProperty, properties.getOrDefault(findingProperty, ""));
                }
            }
            return findingsExport;
        }
    };

    private final MediaType mediaType;
    private final String downloadExtension;

    private EFindingsExportFormat(MediaType mediaType, String downloadExtension) {
        this.mediaType = mediaType;
        this.downloadExtension = downloadExtension;
    }

    public abstract Object createPayload(List<ExtendedTrackedFinding> var1, TeamscaleCommitLinkProvider var2, CommitDescriptor var3);

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getDownloadExtension() {
        return this.downloadExtension;
    }

    private static String stringify(FindingBlacklistInfo findingBlacklistInfo, Function<FindingBlacklistInfo, Object> propertyExtractor) {
        if (findingBlacklistInfo == null) {
            return "";
        }
        return String.valueOf(propertyExtractor.apply(findingBlacklistInfo));
    }

    private static List<String> getAllFindingProperties(List<ExtendedTrackedFinding> findings) {
        return findings.stream().flatMap(finding -> finding.getPropertiesWithoutBlacklistProperties().keySet().stream()).distinct().sorted().collect(Collectors.toList());
    }
}

