/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.semgrep;

import com.teamscale.core.utils.YamlUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class SemgrepRulesFileReader {
    public static @Nullable SemgrepRules readFileContent(Path uniformPath, String fileContent) {
        return (SemgrepRules)YamlUtils.readFileContent((String)uniformPath.normalize().toString(), (String)fileContent, SemgrepRules.class);
    }

    public static SemgrepRule getFirstRuleFromFileContent(Path uniformPath) throws IOException {
        String fileContent = FileSystemUtils.readFile((Path)uniformPath, (Charset)StandardCharsets.UTF_8);
        SemgrepRules rules = SemgrepRulesFileReader.readFileContent(uniformPath, fileContent);
        return Objects.requireNonNull(rules).getRules().getFirst();
    }

    public static class SemgrepRules {
        private List<SemgrepRule> rules;

        public List<SemgrepRule> getRules() {
            return this.rules;
        }

        public void setRules(List<SemgrepRule> rules) {
            this.rules = rules;
        }
    }

    public static class SemgrepRule {
        private String id;
        private String message;
        private List<String> languages;
        private SemgrepRuleMetadata metadata;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<String> getLanguages() {
            return this.languages;
        }

        public void setLanguages(List<String> languages) {
            this.languages = languages;
        }

        public SemgrepRuleMetadata getMetadata() {
            return this.metadata;
        }

        public void setMetadata(SemgrepRuleMetadata metadata) {
            this.metadata = metadata;
        }
    }

    public static class SemgrepRuleMetadata {
        private String shortDescription;
        private List<String> owasp;
        private String cwe;

        public String getShortDescription() {
            return this.shortDescription;
        }

        public void setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
        }

        public List<String> getOwasp() {
            return this.owasp;
        }

        public void setOwasp(List<String> owasp) {
            this.owasp = owasp;
        }

        public String getCwe() {
            return this.cwe;
        }

        public void setCwe(String cwe) {
            this.cwe = cwe;
        }
    }
}

