/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.sonarlint.independent_analysis;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.trigger.MaintenanceTriggerBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.findings.OutsourcedAnalysisUtils;
import com.teamscale.index.findings.sonarlint.SonarLintEnginePool;
import com.teamscale.index.findings.sonarlint.SonarLintFinding;
import com.teamscale.index.findings.sonarlint.SonarLintProcess;
import com.teamscale.index.findings.sonarlint.independent_analysis.ESonarLintIndependentAnalysisStatus;
import com.teamscale.index.findings.sonarlint.independent_analysis.ISonarLintIndependentAnalysisCallingServerApi;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintFileInfo;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintFindingWithUniformPath;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisContext;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisContextIndex;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisFindingsCache;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisLocalContentReader;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisStatusIndex;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisUtils;
import com.teamscale.index.resource.TokenElementInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.TemporaryDirectory;
import org.conqat.lib.commons.string.StringUtils;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneSonarLintEngine;
import org.sonarsource.sonarlint.core.commons.RuleKey;

public class SonarLintIndependentAnalysisRunner
extends MaintenanceTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();

    public ETriggerConcurrency getConcurrency() {
        return ETriggerConcurrency.MAINTENANCE_PARALLEL;
    }

    public void execute() throws StorageException, IOException, ProjectConfigurationException, ServiceCallException {
        String sessionKey = this.jobDescriptor.getParameter();
        SonarLintIndependentAnalysisStatusIndex statusIndex = (SonarLintIndependentAnalysisStatusIndex)this.indexLayer.openGlobalIndex(SonarLintIndependentAnalysisStatusIndex.class);
        SonarLintIndependentAnalysisContext context = ((SonarLintIndependentAnalysisContextIndex)this.indexLayer.openGlobalIndex(SonarLintIndependentAnalysisContextIndex.class)).getContext(sessionKey).orElseThrow(() -> new IllegalStateException("No analysis context found for session '" + sessionKey + "'. This is likely a programming error."));
        try {
            statusIndex.setStatus(sessionKey, ESonarLintIndependentAnalysisStatus.RUNNING);
            Map<String, TokenElementInfo> elementsByPath = this.getElementsToAnalyzeByPath(context.fileInfos(), context.returnAddress(), context.projectId(), context.commit());
            ListMap<String, SonarLintFinding> findingsByPath = SonarLintIndependentAnalysisRunner.executeAnalysis(elementsByPath, context.selectedChecks(), context.selectedOptions(), context.checkOptionValues(), context.javaSourceLevel());
            this.writeFindingsToCache(elementsByPath, findingsByPath);
            statusIndex.setStatus(sessionKey, ESonarLintIndependentAnalysisStatus.DONE);
        }
        catch (Throwable t) {
            statusIndex.setStatus(sessionKey, ESonarLintIndependentAnalysisStatus.ERROR);
            throw t;
        }
        finally {
            this.sendAnalysisCompletionConfirmation(context.returnAddress(), sessionKey, context.projectId(), context.commit());
        }
    }

    private void sendAnalysisCompletionConfirmation(String returnAddress, String sessionKey, @Nullable IProjectId projectId, UnresolvedCommitDescriptor commit) throws ServiceCallException, StorageException {
        if (projectId == null) {
            LOGGER.debug("Skipped sending analysis completion confirmation because project id was null.");
            return;
        }
        ExternalCredentials teamscaleServerCredentials = OutsourcedAnalysisUtils.findFirstCredentialsForTeamscaleServerAt(returnAddress, ((ExternalCredentialsIndex)this.indexLayer.openGlobalIndex(ExternalCredentialsIndex.class)).getAllExternalCredentials());
        ISonarLintIndependentAnalysisCallingServerApi callingServer = (ISonarLintIndependentAnalysisCallingServerApi)Retrofit.builder((String)returnAddress).withBasicNTLMAuthentication(teamscaleServerCredentials.username, teamscaleServerCredentials.password).withInteractionLogger(LOGGER).create(ISonarLintIndependentAnalysisCallingServerApi.class);
        callingServer.notifyAnalysisCompletion(sessionKey, projectId, commit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static ListMap<String, SonarLintFinding> executeAnalysis(Map<String, TokenElementInfo> elementsByPath, List<String> selectedChecks, List<String> selectedOptions, List<String> checkOptionValues, @Nullable String javaSourceLevel) {
        ListMap<String, SonarLintFinding> listMap;
        TemporaryDirectory tempDirectory;
        StandaloneSonarLintEngine engine;
        block10: {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = elementsByPath::size;
            LOGGER.info("Analyzing {} file(s) with SonarLint.", supplierArray);
            engine = null;
            tempDirectory = FileSystemUtils.getTemporaryDirectory((String)"sonarlint");
            engine = SonarLintEnginePool.createEngine();
            listMap = new SonarLintProcess(selectedOptions, checkOptionValues, javaSourceLevel).execute(engine, tempDirectory.getPath().toFile(), selectedChecks.stream().map(RuleKey::parse).toList(), elementsByPath);
            if (tempDirectory == null) break block10;
            tempDirectory.close();
        }
        SonarLintEnginePool.returnEngine(engine);
        return listMap;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (tempDirectory != null) {
                            try {
                                tempDirectory.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ProjectConfigurationException | IOException | ConQATException e) {
                        LOGGER.error("Error running SonarLint: {}", (Object)e, (Object)e);
                        ListMap listMap2 = ListMap.emptyMap();
                        SonarLintEnginePool.returnEngine(engine);
                        return listMap2;
                    }
                }
                catch (Throwable throwable3) {
                    SonarLintEnginePool.returnEngine(engine);
                    throw throwable3;
                }
            }
        }
    }

    private Map<String, TokenElementInfo> getElementsToAnalyzeByPath(List<SonarLintFileInfo> requestedFiles, @Nullable String returnAddress, @Nullable IProjectId projectId, @Nullable UnresolvedCommitDescriptor commit) throws StorageException {
        List<SonarLintFileInfo> fileInfosWithoutCachedFindings = this.getFileInfosWithoutCachedFindings(requestedFiles);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> requestedFiles.size() - fileInfosWithoutCachedFindings.size();
        supplierArray[1] = requestedFiles::size;
        LOGGER.debug("Using cached findings for {} of {} file(s).", supplierArray);
        return SonarLintIndependentAnalysisRunner.fetchElementsByPath(fileInfosWithoutCachedFindings, SonarLintIndependentAnalysisLocalContentReader.readLocalContentByHash(this.indexLayer, projectId, commit, fileInfosWithoutCachedFindings), returnAddress);
    }

    private List<SonarLintFileInfo> getFileInfosWithoutCachedFindings(List<SonarLintFileInfo> requestedFiles) throws StorageException {
        Set<String> keysWithCachedFindings = ((SonarLintIndependentAnalysisFindingsCache)this.indexLayer.openGlobalIndex(SonarLintIndependentAnalysisFindingsCache.class)).getContainedKeys(CollectionUtils.map(requestedFiles, SonarLintFileInfo::hash));
        return requestedFiles.stream().filter(fileInfo -> !keysWithCachedFindings.contains(fileInfo.hash())).toList();
    }

    private static Map<String, TokenElementInfo> fetchElementsByPath(List<SonarLintFileInfo> filesToAnalyze, Map<String, TokenElementInfo> localFilesByHash, @Nullable String returnAddress) {
        HashMap<String, TokenElementInfo> elementsByPath = new HashMap<String, TokenElementInfo>(filesToAnalyze.size());
        ArrayList<SonarLintFileInfo> missingFiles = new ArrayList<SonarLintFileInfo>();
        for (SonarLintFileInfo fileInfo : filesToAnalyze) {
            if (localFilesByHash.containsKey(fileInfo.hash())) {
                TokenElementInfo localElement = localFilesByHash.get(fileInfo.hash());
                elementsByPath.put(localElement.getUniformPath(), localElement);
                continue;
            }
            missingFiles.add(fileInfo);
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = elementsByPath::size;
        LOGGER.debug("Found {} element(s) in local storage.", supplierArray);
        SonarLintIndependentAnalysisRunner.addMissingElementsFromCallingServer(elementsByPath, missingFiles, returnAddress);
        return elementsByPath;
    }

    private static void addMissingElementsFromCallingServer(Map<String, TokenElementInfo> elementsByPath, List<SonarLintFileInfo> missingFiles, @Nullable String callerAddress) {
        if (missingFiles.isEmpty()) {
            return;
        }
        if (callerAddress == null) {
            LOGGER.error("Calling server did not pass a return address. These missing files will be ignored: {}", (Object)missingFiles.stream().map(SonarLintFileInfo::uniformPath).map(StringUtils::surroundWithSingleQuotes).collect(Collectors.joining(", ")));
        }
        Map<String, TokenElementInfo> fetchedElementsByPath = SonarLintIndependentAnalysisRunner.fetchElementsByPath(callerAddress, missingFiles);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = fetchedElementsByPath::size;
        supplierArray[1] = () -> callerAddress;
        LOGGER.debug("Fetched {} element(s) from calling server '{}'.", supplierArray);
        int numberOfMissingElements = missingFiles.size() - fetchedElementsByPath.size();
        if (numberOfMissingElements > 0) {
            LOGGER.error("Missing content for {} element(s). Analysis will ignore these files: {}", (Object)numberOfMissingElements, (Object)missingFiles.stream().map(SonarLintFileInfo::uniformPath).filter(Predicate.not(fetchedElementsByPath::containsKey)).map(StringUtils::surroundWithSingleQuotes).collect(Collectors.joining(", ")));
        }
        elementsByPath.putAll(fetchedElementsByPath);
    }

    private static Map<String, TokenElementInfo> fetchElementsByPath(String serverAddress, List<SonarLintFileInfo> filesToFetchElementsFor) {
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = filesToFetchElementsFor::size;
        supplierArray[1] = () -> serverAddress;
        LOGGER.debug("Fetching {} element(s) from '{}'", supplierArray);
        LOGGER.error("Fetching from calling server is not yet supported.");
        return Collections.emptyMap();
    }

    private void writeFindingsToCache(Map<String, TokenElementInfo> elementsByPath, ListMap<String, SonarLintFinding> findingsByPath) throws StorageException {
        PairList findingsByHash = new PairList(findingsByPath.size());
        for (String uniformPath : findingsByPath.getKeys()) {
            TokenElementInfo tokenElement = elementsByPath.get(uniformPath);
            if (tokenElement == null) {
                LOGGER.error("Missing token elements for path '{}'. Findings in this file will be discarded.", (Object)uniformPath);
                continue;
            }
            findingsByHash.add((Object)SonarLintIndependentAnalysisUtils.generateSonarLintFileHash(tokenElement), new ArrayList<SonarLintFindingWithUniformPath>(((List)findingsByPath.getCollectionOrEmpty((Object)uniformPath)).stream().map(finding -> new SonarLintFindingWithUniformPath(uniformPath, (SonarLintFinding)finding)).toList()));
        }
        if (!findingsByHash.isEmpty()) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((PairList)findingsByHash).size();
            LOGGER.debug("Writing findings for {} files to cache.", supplierArray);
            ((SonarLintIndependentAnalysisFindingsCache)this.indexLayer.openGlobalIndex(SonarLintIndependentAnalysisFindingsCache.class)).writeCache((PairList<String, ArrayList<SonarLintFindingWithUniformPath>>)findingsByHash);
        }
    }
}

