/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.comments.cluster;

import com.google.common.collect.ArrayListMultimap;
import com.teamscale.index.merge_request.comments.FindingUtils;
import com.teamscale.index.merge_request.comments.cluster.EFindingClusterType;
import com.teamscale.index.merge_request.comments.cluster.FindingCluster;
import com.teamscale.index.merge_request.comments.cluster.IFindingClusterStrategy;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.MethodInfoIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.region.SimpleRegion;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class MethodStructureFindingsClusterStrategy
implements IFindingClusterStrategy {
    private final MethodInfoIndex methodInfoIndex;

    public MethodStructureFindingsClusterStrategy(MethodInfoIndex methodInfoIndex) {
        this.methodInfoIndex = methodInfoIndex;
    }

    @Override
    public List<FindingCluster> getFindingClusters(UniformPath uniformPath, List<TrackedFinding> findings) throws StorageException {
        List<TrackedFinding> structureFindings = findings.stream().filter(FindingUtils::isStructureFinding).toList();
        if (structureFindings.isEmpty()) {
            return Collections.emptyList();
        }
        List<AssociatedMethodInfo> associatedMethodInfos = this.methodInfoIndex.getAssociatedMethodInfosForExactPathsWithoutCrossAnnotationInfo(Collections.singletonList(uniformPath));
        ArrayListMultimap findingsPerMethod = ArrayListMultimap.create();
        block0: for (TrackedFinding finding : structureFindings) {
            OffsetBasedRegion findingRegion = FindingUtils.getFindingRegion(finding);
            for (AssociatedMethodInfo methodInfo : associatedMethodInfos) {
                if (!methodInfo.getAssociatedRegion().overlaps((SimpleRegion)findingRegion)) continue;
                findingsPerMethod.put((Object)methodInfo, (Object)finding);
                continue block0;
            }
        }
        ArrayList<FindingCluster> clusters = new ArrayList<FindingCluster>();
        for (Collection findingsInMethod : findingsPerMethod.asMap().values()) {
            clusters.add(new FindingCluster(EFindingClusterType.METHOD_STRUCTURE_FINDINGS, findingsInMethod));
        }
        return clusters;
    }
}

