/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.index.migration.finding.ConfigurationOptionMigrationBase;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class AnalysisProfileVersion184MagicNumberUsageOptions
extends ConfigurationOptionMigrationBase {
    private static final Pattern LITERAL_START = Pattern.compile("^[0-9`'|]");

    public AnalysisProfileVersion184MagicNumberUsageOptions() {
        super("Ignored operands", "Bad Practice");
    }

    @Override
    protected void doMigrateJson(ObjectNode analysisProfile) {
        String previousValue = this.options.get(this.oldOptionName).asText();
        Map<Boolean, List<String>> partitions = CollectionUtils.parseMultiValueStringToList((String)previousValue, (boolean)true).stream().collect(Collectors.partitioningBy(AnalysisProfileVersion184MagicNumberUsageOptions::isLiteral));
        this.removeOption(this.oldOptionName);
        JsonNodeFactory factory = JsonNodeFactory.instance;
        this.options.set("Allowed literals", (JsonNode)factory.textNode(StringUtils.concatWithEscapeCharacter(partitions.get(Boolean.TRUE), (Character)CollectionUtils.MULTI_VALUE_DELIMITER)));
        this.options.set("Allowed variables", (JsonNode)factory.textNode(StringUtils.concatWithEscapeCharacter(partitions.get(Boolean.FALSE), (Character)CollectionUtils.MULTI_VALUE_DELIMITER)));
    }

    private static boolean isLiteral(String value) {
        return LITERAL_START.matcher(value).find();
    }
}

