/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.migration.ProjectConfigurationHolder;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class ProjectVersion44CodeScopeMigration {
    public static String migrate(String json) throws JsonSerializationException {
        ProjectConfigurationHolder projectConfiguration = (ProjectConfigurationHolder)JsonUtils.deserializeFromJson((String)json, ProjectConfigurationHolder.class);
        String analysisProfileName = ProjectVersion44CodeScopeMigration.removeAnalysisProfile(projectConfiguration);
        if (analysisProfileName == null) {
            return json;
        }
        ArrayNode codeScopes = JsonUtils.getObjectMapper().createArrayNode();
        codeScopes.add((JsonNode)ProjectVersion44CodeScopeMigration.getCatchAllCodeScope(analysisProfileName));
        projectConfiguration.setAdditionalProperty("codeScopes", codeScopes);
        return JsonUtils.serializeToJSON((Object)projectConfiguration);
    }

    private static @Nullable String removeAnalysisProfile(ProjectConfigurationHolder projectConfiguration) {
        String profilePropertyName = "profile";
        Object profileProperty = projectConfiguration.getAdditionalProperties().get(profilePropertyName);
        if (profileProperty == null) {
            return null;
        }
        String analysisProfileName = (String)CCSMAssert.checkedCast((Object)projectConfiguration.getAdditionalProperties().get(profilePropertyName), String.class);
        projectConfiguration.getAdditionalProperties().remove(profilePropertyName);
        return analysisProfileName;
    }

    private static ObjectNode getCatchAllCodeScope(String analysisProfileName) {
        ObjectMapper mapper = JsonUtils.getObjectMapper();
        ObjectNode catchAllCodeScope = mapper.createObjectNode();
        catchAllCodeScope.set("name", mapper.valueToTree((Object)CodeScopeAware.DEFAULT_CODE_SCOPE.name()));
        catchAllCodeScope.set("profile", mapper.valueToTree((Object)analysisProfileName));
        catchAllCodeScope.set("contentIncludes", (JsonNode)mapper.createArrayNode());
        catchAllCodeScope.set("contentExcludes", (JsonNode)mapper.createArrayNode());
        catchAllCodeScope.set("pathIncludes", (JsonNode)mapper.createArrayNode());
        catchAllCodeScope.set("pathExcludes", (JsonNode)mapper.createArrayNode());
        return catchAllCodeScope;
    }
}

