/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.code_scopes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectBranchingConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.ExternalStorageProjectMappingId;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class ProjectConfiguration71To98 {
    private static final String NAME_PROPERTY = "name";
    public static final String INTERNAL_ID_PROPERTY = "internalId";
    private static final String PUBLIC_IDS_PROPERTY = "publicIds";
    private static final String PARENT_PROJECT_ID_PROPERTY = "parentProjectId";
    private static final String EXTERNAL_STORAGE_PROJECT_MAPPING_ID_PROPERTY = "externalStorageProjectMappingId";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String PROFILE_PROPERTY = "profile";
    public static final String EMBEDDED_PROFILE_PROPERTY = "embeddedProfile";
    private static final String METRIC_THRESHOLD_CONFIGURATION_PROPERTY = "metricThresholdConfiguration";
    private static final String BRANCHING_CONFIGURATION_PROPERTY = "branchingConfiguration";
    public static final String CONNECTORS_PROPERTY = "connectors";
    private static final String EXTERNAL_STORAGE_BACKEND_PROPERTY = "externalStorageBackend";
    private static final String PRESELECTED_UI_BRANCH = "preselectedUIBranch";
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="internalId")
    private InternalProjectId internalId;
    @JsonProperty(value="externalStorageProjectMappingId")
    private final @Nullable ExternalStorageProjectMappingId externalStorageProjectMappingId;
    @JsonProperty(value="publicIds")
    private List<PublicProjectId> publicIds;
    @JsonProperty(value="parentProjectId")
    private @Nullable IProjectId parentProjectId;
    @JsonProperty(value="description")
    private @Nullable String description;
    @JsonProperty(value="profile")
    private @Nullable String profile;
    @JsonProperty(value="embeddedProfile")
    private @Nullable AnalysisProfile embeddedProfile;
    @JsonProperty(value="metricThresholdConfiguration")
    private @Nullable MetricThresholdConfiguration metricThresholdConfiguration;
    @JsonProperty(value="branchingConfiguration")
    private @Nullable ProjectBranchingConfiguration branchingConfiguration;
    @JsonProperty(value="externalStorageBackend")
    private @Nullable String externalStorageBackend;
    @JsonProperty(value="connectors")
    private final List<ConnectorConfiguration> connectors = new ArrayList<ConnectorConfiguration>();
    @JsonProperty(value="preselectedUIBranch")
    private @Nullable String preselectedUIBranch;

    public @Nullable String getPreselectedUIBranch() {
        return this.preselectedUIBranch;
    }

    public void setPreselectedUIBranch(@Nullable String preselectedUIBranch) {
        this.preselectedUIBranch = preselectedUIBranch;
    }

    @JsonCreator
    public ProjectConfiguration71To98(@JsonProperty(value="name") String name, @JsonProperty(value="internalId") @Nullable InternalProjectId internalId, @JsonProperty(value="externalStorageProjectMappingId") @Nullable ExternalStorageProjectMappingId externalStorageProjectMappingId, @JsonProperty(value="publicIds") List<PublicProjectId> publicIds, @JsonProperty(value="profile") @Nullable String profile, @JsonProperty(value="externalStorageBackend") @Nullable String externalStorageBackend) {
        this.name = name;
        this.internalId = Objects.requireNonNullElseGet(internalId, InternalProjectId::create);
        this.externalStorageProjectMappingId = Objects.requireNonNullElseGet(externalStorageProjectMappingId, ExternalStorageProjectMappingId::create);
        this.setPublicIds(publicIds);
        this.profile = profile;
        this.externalStorageBackend = externalStorageBackend;
    }

    @VisibleForTesting
    public ProjectConfiguration71To98(String name, PublicProjectId publicId, @Nullable String profile) {
        this.name = name;
        this.internalId = InternalProjectId.create();
        this.externalStorageProjectMappingId = ExternalStorageProjectMappingId.create();
        this.externalStorageBackend = null;
        this.profile = profile;
        this.setPublicIds(List.of(publicId));
    }

    public void setPublicIds(List<PublicProjectId> publicIds) {
        Preconditions.checkState((!CollectionUtils.isNullOrEmpty(publicIds) ? 1 : 0) != 0, (Object)"At least one public ID needs to be provided.");
        this.publicIds = publicIds;
    }

    public void setBranchingConfiguration(@Nullable ProjectBranchingConfiguration branchingConfiguration) {
        this.branchingConfiguration = branchingConfiguration;
    }

    public void setDefaultBranchingConfiguration() {
        this.setBranchingConfiguration(ProjectConfiguration71To98.createDefaultBranchingConfiguration());
    }

    private static @NonNull ProjectBranchingConfiguration createDefaultBranchingConfiguration() {
        ProjectBranchingConfiguration branchingConfiguration = new ProjectBranchingConfiguration();
        branchingConfiguration.addBranchConfiguration(new ProjectBranchingConfiguration.BranchConfiguration("main|master|trunk|release.*", "1 year"));
        branchingConfiguration.addBranchConfiguration(new ProjectBranchingConfiguration.BranchConfiguration(".*", "3 months"));
        return branchingConfiguration;
    }

    public void setEmbeddedProfile(@Nullable AnalysisProfile embeddedProfile) {
        this.embeddedProfile = embeddedProfile;
    }

    public @Nullable AnalysisProfile getEmbeddedProfile() {
        return this.embeddedProfile;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setProfile(@Nullable String profile) {
        this.profile = profile;
    }
}

