/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.monitoring.prometheus;

import com.teamscale.index.system_info.SystemLoadFragment;
import io.prometheus.metrics.core.datapoints.GaugeDataPoint;
import io.prometheus.metrics.core.metrics.Gauge;
import io.prometheus.metrics.model.snapshots.Unit;
import org.conqat.lib.commons.filesystem.ByteUnit;

public class SystemLoadMetricsCollector {
    private static final String PROCESS_LABEL = "process";
    private static final Gauge CPU_CORE_COUNT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("cpu_core")).help("Number of CPU cores.")).labelNames(new String[]{"process"})).register();
    private static final Gauge CPU_LOAD = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("cpu_load_ratio")).help("CPU load in %")).labelNames(new String[]{"process"})).unit(Unit.RATIO)).register();
    private static final Gauge RAM = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("ram")).help("Metrics about the system RAM in bytes")).labelNames(new String[]{"process", "type"})).unit(Unit.BYTES)).register();
    private static final Gauge DIRECTORY = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("directory_space_bytes")).help("Metrics about various directories in bytes.")).labelNames(new String[]{"process", "directory"})).unit(Unit.BYTES)).register();

    private SystemLoadMetricsCollector() {
    }

    public static void collect(SystemLoadFragment systemLoadFragment) {
        ((GaugeDataPoint)CPU_CORE_COUNT.labelValues(new String[]{systemLoadFragment.getProcessId()})).set(systemLoadFragment.getCpuCoreCount());
        ((GaugeDataPoint)CPU_LOAD.labelValues(new String[]{systemLoadFragment.getProcessId()})).set(systemLoadFragment.getCpuLoad());
        ((GaugeDataPoint)RAM.labelValues(new String[]{systemLoadFragment.getProcessId(), "total"})).set((double)ByteUnit.MEBIBYTES.toBytes(systemLoadFragment.getRamInstalledMB()));
        ((GaugeDataPoint)RAM.labelValues(new String[]{systemLoadFragment.getProcessId(), "used"})).set((double)ByteUnit.MEBIBYTES.toBytes(systemLoadFragment.getRamUsedMB()));
        ((GaugeDataPoint)DIRECTORY.labelValues(new String[]{systemLoadFragment.getProcessId(), "working_directory"})).set((double)ByteUnit.MEBIBYTES.toBytes(systemLoadFragment.getWorkingDirectory().freeMB()));
        SystemLoadFragment.PathWithSpaceInfo storageDirectory = systemLoadFragment.getStorageDirectory();
        if (storageDirectory != null) {
            ((GaugeDataPoint)DIRECTORY.labelValues(new String[]{systemLoadFragment.getProcessId(), "storage_directory"})).set((double)ByteUnit.MEBIBYTES.toBytes(storageDirectory.freeMB()));
        }
        ((GaugeDataPoint)DIRECTORY.labelValues(new String[]{systemLoadFragment.getProcessId(), "repositories_directory"})).set((double)ByteUnit.MEBIBYTES.toBytes(systemLoadFragment.getRepositoriesDirectory().freeMB()));
        ((GaugeDataPoint)DIRECTORY.labelValues(new String[]{systemLoadFragment.getProcessId(), "temp_directory"})).set((double)ByteUnit.MEBIBYTES.toBytes(systemLoadFragment.getTempDirectory().freeMB()));
    }
}

