/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.notifications;

import com.teamscale.core.analysis.configuration.index.model.EAssessmentSpecification;
import com.teamscale.core.analysis.configuration.index.model.EMetricSchemaSource;
import com.teamscale.core.analysis.configuration.index.model.EThresholdEvaluationOption;
import com.teamscale.core.analysis.configuration.index.model.EvaluatedMetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.IMetricValue;
import com.teamscale.core.metrics.values.MetricValueBase;
import com.teamscale.core.user.User;
import com.teamscale.index.metrics.assessment.computation.IMetricComputation;
import com.teamscale.index.metrics.assessment.computation.MetricComputationBase;
import com.teamscale.index.metrics.assessment.context.IMetricEvaluationContext;
import com.teamscale.index.metrics.assessment.context.MetricDataRetrieverFactory;
import com.teamscale.index.metrics.assessment.context.MetricEvaluationContext;
import com.teamscale.index.metrics.threshold.MetricThresholdEvaluator;
import com.teamscale.index.notifications.ENotificationThresholdType;
import com.teamscale.index.notifications.ENotificationThresholdViolationResult;
import com.teamscale.index.notifications.EThresholdViolationResult;
import com.teamscale.index.notifications.NotificationContext;
import com.teamscale.index.notifications.NotificationThresholdViolationInfo;
import com.teamscale.index.notifications.ThresholdViolationInfo;
import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.util.CommonUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.ETrafficLightColor;

public class NotificationThresholdViolationChecker {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String metricName;
    private final @NonNull String subPath;
    private final EMetricSchemaSource metricSchemaSource;
    private final NotificationContext notificationContext;
    private final IMetricEvaluationContext metricEvaluationContext;
    private EAssessmentSpecification assessmentSpecification = EAssessmentSpecification.DEFAULT;
    protected HistoryAccessOption currentHistoryAccessOption;
    protected HistoryAccessOption previousValueHistoryAccessOption;
    private final Set<EThresholdEvaluationOption> evaluationOptions;

    public NotificationThresholdViolationChecker(String metricName, @NonNull String subPath, NotificationContext notificationContext, Set<EThresholdEvaluationOption> evaluationOptions, User currentUser) throws StorageException {
        this.metricName = metricName;
        this.subPath = subPath;
        this.notificationContext = notificationContext;
        this.evaluationOptions = evaluationOptions;
        this.metricEvaluationContext = this.createMetricEvaluationContext(notificationContext, currentUser);
        this.prepareHistoryAccessOptions();
        this.metricEvaluationContext.setCurrentHistoryAccessOption(this.currentHistoryAccessOption);
        this.metricEvaluationContext.setBaselineHistoryAccessOption(this.previousValueHistoryAccessOption);
        this.metricSchemaSource = EMetricSchemaSource.determineFromSubPath((String)subPath);
    }

    protected void prepareHistoryAccessOptions() throws StorageException {
        CommitDescriptor scheduledCommit = this.notificationContext.getCommit();
        this.currentHistoryAccessOption = NotificationThresholdViolationChecker.retrieveHistoryAccessOption(scheduledCommit);
        CommitDescriptorIndex commitDescriptorIndex = (CommitDescriptorIndex)this.notificationContext.getProjectStorageSystem().openProjectIndex(CommitDescriptorIndex.class, null);
        ParentedCommitDescriptor parentedCommit = commitDescriptorIndex.getCommit(scheduledCommit);
        if (parentedCommit == null || parentedCommit.getFirstParentCommit() == null) {
            this.previousValueHistoryAccessOption = NotificationThresholdViolationChecker.retrieveHistoryAccessOption(scheduledCommit);
        } else {
            CommitDescriptor parentCommit = parentedCommit.getFirstParentCommit();
            this.previousValueHistoryAccessOption = NotificationThresholdViolationChecker.retrieveHistoryAccessOption(parentCommit);
        }
    }

    private static HistoryAccessOption retrieveHistoryAccessOption(CommitDescriptor commit) {
        return HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp());
    }

    public EAssessmentSpecification getAssessmentSpecification() {
        return this.assessmentSpecification;
    }

    public void setAssessmentSpecification(EAssessmentSpecification assessmentSpecification) {
        this.assessmentSpecification = assessmentSpecification;
    }

    protected IMetricEvaluationContext createMetricEvaluationContext(NotificationContext notificationContext, User currentUser) {
        return new MetricEvaluationContext("", new MetricDataRetrieverFactory((ProjectStorageSystem)notificationContext.getProjectStorageSystem(), notificationContext.getGlobalStorageSystem(), currentUser, notificationContext.getSchemaRetrieverFactory()));
    }

    public NotificationThresholdViolationInfo doesViolateConstantThreshold(Double thresholdValue, ENotificationThresholdType thresholdType) throws StorageException {
        ThresholdViolationInfo previousInfo = this.doesMetricViolateThreshold(this.previousValueHistoryAccessOption, thresholdValue, thresholdType);
        ThresholdViolationInfo currentInfo = this.doesMetricViolateThreshold(this.currentHistoryAccessOption, thresholdValue, thresholdType);
        return NotificationThresholdViolationChecker.createNotificationThresholdViolationInfo(previousInfo, currentInfo);
    }

    public NotificationThresholdViolationInfo doesViolateTimeDependentThreshold(MetricThresholdConfiguration configuration, String thresholdDisplayName, String thresholdGroupName, ENotificationThresholdType thresholdType) throws MetricThresholdConfigurationException, StorageException {
        ThresholdViolationInfo previousInfo = this.doesViolateThreshold(configuration, this.previousValueHistoryAccessOption, thresholdDisplayName, thresholdGroupName, thresholdType);
        ThresholdViolationInfo currentInfo = this.doesViolateThreshold(configuration, this.currentHistoryAccessOption, thresholdDisplayName, thresholdGroupName, thresholdType);
        return NotificationThresholdViolationChecker.createNotificationThresholdViolationInfo(previousInfo, currentInfo);
    }

    private static NotificationThresholdViolationInfo createNotificationThresholdViolationInfo(ThresholdViolationInfo previousInfo, ThresholdViolationInfo currentInfo) {
        ENotificationThresholdViolationResult result = ENotificationThresholdViolationResult.determineResult(previousInfo.getResult(), currentInfo.getResult());
        return new NotificationThresholdViolationInfo(result, previousInfo.getValue(), previousInfo.getThreshold(), currentInfo.getValue(), currentInfo.getThreshold());
    }

    private ThresholdViolationInfo doesViolateThreshold(MetricThresholdConfiguration configuration, HistoryAccessOption historyAccessOption, String thresholdDisplayName, String thresholdGroupName, ENotificationThresholdType thresholdType) throws MetricThresholdConfigurationException, StorageException {
        Double evaluatedThreshold = this.getEvaluatedThresholdValue(configuration, thresholdDisplayName, thresholdGroupName, thresholdType);
        return this.doesMetricViolateThreshold(historyAccessOption, evaluatedThreshold, thresholdType);
    }

    private ThresholdViolationInfo doesMetricViolateThreshold(HistoryAccessOption historyAccessOption, Double thresholdValue, ENotificationThresholdType thresholdType) throws StorageException {
        Optional<Object> metricValue = this.metricEvaluationContext.getMetricValue(this.metricName, this.metricEvaluationContext.getThresholdPath(this.subPath), this.metricSchemaSource, historyAccessOption);
        if (metricValue.isEmpty()) {
            this.logMissingMetricValueAtTime(historyAccessOption);
            return ThresholdViolationInfo.createNoViolationInfo();
        }
        if (thresholdValue == null) {
            this.logMissingThresholdValueAtTime(historyAccessOption);
            return ThresholdViolationInfo.createNoViolationInfo();
        }
        return this.createThresholdViolationInfo(metricValue.get(), thresholdValue, thresholdType);
    }

    protected void logMissingThresholdValueAtTime(HistoryAccessOption historyAccessOption) {
        this.logMissingValueAtTime(historyAccessOption, "threshold value");
    }

    protected void logMissingMetricValueAtTime(HistoryAccessOption historyAccessOption) {
        this.logMissingValueAtTime(historyAccessOption, "metric value");
    }

    private void logMissingValueAtTime(HistoryAccessOption historyAccessOption, String valueText) {
        LOGGER.warn("Could not find " + valueText + " for metric '" + this.metricName + "' at timestamp '" + historyAccessOption.getTimestamp() + "' on branch '" + historyAccessOption.getBranchName() + "'.");
    }

    private ThresholdViolationInfo createThresholdViolationInfo(Object rawValue, Double thresholdValue, ENotificationThresholdType thresholdType) throws StorageException {
        MetricDirectorySchemaEntry metricDirectorySchemaEntry = this.metricEvaluationContext.getMetricDirectorySchemaEntry(this.metricName, this.metricSchemaSource).orElseThrow(() -> new StorageException("Metric directory schema entry not available"));
        ETrafficLightColor color = thresholdType.getColor();
        MetricValueBase metricValue = MetricValueBase.createWithRawValue((MetricDirectorySchemaEntry)metricDirectorySchemaEntry, (Object)rawValue);
        Optional value = metricValue.getValueAsDoubleForRating(color);
        MetricThreshold threshold = new MetricThreshold(this.metricName);
        threshold.setAssessmentSpecification(this.assessmentSpecification);
        threshold.setEvaluationOptions(this.evaluationOptions);
        threshold.setMetricSchemaSource(this.metricSchemaSource);
        EvaluatedMetricThreshold evaluatedMetricThreshold = new EvaluatedMetricThreshold(threshold, null, thresholdValue);
        IMetricComputation<?> metricComputation = MetricComputationBase.createInstance((IMetricValue<? extends Serializable>)metricValue);
        ETrafficLightColor metricRating = metricComputation.computeMetricRating(evaluatedMetricThreshold, metricValue.getRawValue());
        ThresholdViolationInfo info = new ThresholdViolationInfo(EThresholdViolationResult.NO_VIOLATION, value.orElse(null), thresholdValue);
        info.setViolated(CommonUtils.isOneOf((Object)metricRating, (Object[])new ETrafficLightColor[]{ETrafficLightColor.YELLOW, ETrafficLightColor.RED}));
        return info;
    }

    private Double getEvaluatedThresholdValue(MetricThresholdConfiguration configuration, String thresholdDisplayName, String thresholdGroupName, ENotificationThresholdType thresholdType) throws MetricThresholdConfigurationException {
        Optional<EvaluatedMetricThreshold> evaluatedThreshold = new MetricThresholdEvaluator(configuration).evaluateThreshold(thresholdDisplayName, thresholdGroupName);
        if (evaluatedThreshold.isEmpty()) {
            throw new MetricThresholdConfigurationException("Threshold is not present! Metric name: " + this.metricName + ", configuration: " + configuration.getName());
        }
        return switch (thresholdType) {
            case ENotificationThresholdType.YELLOW -> evaluatedThreshold.get().getThresholdYellow();
            case ENotificationThresholdType.RED -> evaluatedThreshold.get().getThresholdRed();
            default -> {
                CCSMAssert.fail((String)("The threshold type '" + String.valueOf((Object)thresholdType) + "' is none of the expected."));
                yield null;
            }
        };
    }
}

