/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import com.google.common.base.Preconditions;
import com.teamscale.index.repository.artifact_store.ArtifactStoreItemData;
import com.teamscale.index.repository.artifact_store.IArtifactStoreCommitResolver;
import com.teamscale.index.repository.artifact_store.revision_interpretation.ERevisionType;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.Pair;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class CommitFromItemCreationResolver
implements IArtifactStoreCommitResolver {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public Optional<Pair<String, CommitDescriptor>> resolveRevisionAndCommit(ArtifactStoreItemData item, @Nullable String branchName) {
        if (branchName == null) {
            return Optional.empty();
        }
        long timestamp = item.getCreationTimestamp();
        return Optional.of(Pair.createPair((Object)Long.toString(timestamp), (Object)new CommitDescriptor(branchName, timestamp)));
    }

    @Override
    public Optional<CommitDescriptor> resolveCommit(String revision, @Nullable String branchName) {
        Preconditions.checkNotNull((Object)branchName, (Object)"Branch name must not be null.");
        try {
            return Optional.of(new CommitDescriptor(branchName, Long.parseLong(revision)));
        }
        catch (NumberFormatException e) {
            LOGGER.error("Unable to interpret simple timestamp from value '{}'. Please check if timestamp interpretation is correctly configured.", (Object)revision);
            return Optional.empty();
        }
    }

    @Override
    public boolean mayRequireReschedule() {
        return false;
    }

    @Override
    public Optional<IArtifactStoreCommitResolver.ResolveRevisionResult> resolveRevision(ArtifactStoreItemData item) {
        return Optional.of(new IArtifactStoreCommitResolver.ResolveRevisionResult(Long.toString(item.getCreationTimestamp()), ERevisionType.TIMESTAMP));
    }

    @Override
    public void close() {
    }
}

