/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.artifactory;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.index.repository.artifact_store.ArtifactStoreRepositoryConnectorDescriptorBase;
import com.teamscale.index.repository.artifact_store.artifactory.ArtifactoryArchiveIndex;
import com.teamscale.index.repository.artifact_store.artifactory.ArtifactoryChangeRetriever;
import com.teamscale.index.repository.artifact_store.artifactory.ArtifactoryCommitResolutionCacheIndex;
import com.teamscale.index.repository.artifact_store.artifactory.ArtifactoryContentUpdater;
import com.teamscale.index.repository.artifact_store.artifactory.ArtifactoryRepositoryInfo;
import com.teamscale.index.repository.artifact_store.artifactory.SimpleArtifactoryClient;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.jaxen.util.SingletonList;

@ConnectorDescriptor
public class ArtifactoryRepositoryConnectorDescriptor
extends ArtifactStoreRepositoryConnectorDescriptorBase<ArtifactoryRepositoryInfo> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String PUBLIC_CONTEXT_PATH_OPTION = "Public Context Path";
    public static final String DEFAULT_ARTIFACTORY_PUBLIC_CONTEXT_PATH = "artifactory";
    public static final String REPOSITORY_OPTION = "Repository";
    public static final String NAME_SEARCH_PATTERN_OPTION = "Name Search Pattern";
    public static final String PATH_SEARCH_PATTERN_OPTION = "Path Search Pattern";
    public static final String ZIP_EXCLUDE_PATTERN_OPTION = "Zip Exclude Pattern";
    public static final String FULL_SCAN_TIME_INTERVAL_OPTION = "Full Scan Interval";
    @ConfigExposed(name="Repository", description="The name of the repository to read from.", required=true)
    private String repositoryName = "";
    @ConfigExposed(name="Name Search Pattern", description="The pattern on the simple name used for finding archive files. Supported wildcards are '*' and '?'. Separate multiple patterns with comma or newline.")
    private List<String> nameSearchPatterns = new ArrayList<String>(List.of("*.zip"));
    @ConfigExposed(name="Zip Exclude Pattern", description="Ant patterns used to exclude all archives whose full paths (path + name) match any of the given patterns. Paths will be matched case-insensitively.")
    private List<String> zipExcludePatterns = new ArrayList<String>();
    @ConfigExposed(name="Path Search Pattern", description="The pattern on the full path used for finding archive files. Supported wildcards are '*' and '?'. Separate multiple patterns with comma or newline.")
    private List<String> pathSearchPatterns = new SingletonList((Object)"**/uploads/**");
    @ConfigExposed(name="Public Context Path", description="The path which will be publicly used to access Artifactory. If Artifactory is accessible on the root of the server leave empty.")
    private String publicContextPath = "artifactory";
    @ConfigExposed(name="Full Scan Interval", description="The interval in which a full scan will be performed, in seconds. Depending on the Artifactory instance, this can take a long time. Might be necessary to detect deletions of older items. Can be set to -1 to disable periodic full scans. Please note that only full scans will remove any revisions which have been deleted in Artifactory from Teamscale.", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    private long fullScanIntervalInSeconds = 60L;

    public ArtifactoryRepositoryConnectorDescriptor() {
        super(ERepositoryConnector.ARTIFACTORY);
    }

    @Override
    protected void setCommonParameters(TriggerBuilder triggerBuilder, ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        super.setCommonParameters(triggerBuilder, triggerCreator);
        triggerBuilder.setTriggerParameter("public-context-path", this.publicContextPath);
        triggerBuilder.setTriggerParameter("name-search-pattern", ITriggerParameter.of(this.nameSearchPatterns));
        triggerBuilder.setTriggerParameter("path-search-pattern", ITriggerParameter.of(this.pathSearchPatterns));
        triggerBuilder.setTriggerParameter("zip-exclude-pattern", ITriggerParameter.of(this.zipExcludePatterns));
        triggerBuilder.setTriggerParameter("full-scan-interval", this.fullScanIntervalInSeconds);
    }

    @Override
    protected void renameArchiveIndex(TriggerBuilder triggerBuilder) {
        triggerBuilder.renameIndex("artifactory-archive-content", ArtifactoryArchiveIndex.createIndexName(this.repositoryIdentifier));
        triggerBuilder.renameIndex("artifactory-commit-resolution-cache", this.repositoryIdentifier + "-artifactory-commit-resolution-cache");
    }

    @Override
    protected void createArchiveIndex(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        indexCreator.createProjectIndex(ArtifactoryArchiveIndex.class, ArtifactoryArchiveIndex.createIndexName(this.repositoryIdentifier));
        indexCreator.createProjectIndex(ArtifactoryCommitResolutionCacheIndex.class, this.repositoryIdentifier + "-artifactory-commit-resolution-cache");
    }

    @Override
    protected void checkConnection() throws ConnectorValidationException {
        if (StringUtils.isEmpty((String)this.repositoryName)) {
            throw new ConnectorValidationException("Repository name not provided!");
        }
        try {
            SimpleArtifactoryClient client = this.getClient();
            if (!client.repositoryExists(this.repositoryName)) {
                throw new ConnectorValidationException("Repository '" + this.repositoryName + "' does not exist or is not readable for user '" + client.getUsername() + "'!");
            }
        }
        catch (ServiceCallException e) {
            throw new ConnectorValidationException("Could not connect to Artifactory: " + e.getMessage(), (Throwable)e);
        }
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    @Override
    protected Class<? extends ChangeRetrieverAnalysisStep> getChangeRetrieverBlockName() {
        return ArtifactoryChangeRetriever.class;
    }

    @Override
    protected Class<? extends ChangeProcessorAnalysisStep> getContentUpdaterBlockName() {
        return ArtifactoryContentUpdater.class;
    }

    @Override
    protected String getRepositoryOrBucketName() {
        return this.repositoryName;
    }

    @Override
    protected List<String> getExcludePatterns() {
        return this.zipExcludePatterns;
    }

    @Override
    public void storeConfigurationDataInternal(ProjectStorageSystem projectStorageSystem) throws StorageException, ConnectorValidationException {
        super.storeConfigurationDataInternal(projectStorageSystem);
        this.storeUrlToTriggerMapping(projectStorageSystem, this.getRepositoryUrlWithPublicContext());
    }

    @Override
    public void deleteConfigurationData(ProjectStorageSystem projectStorageSystem, String url) throws StorageException, ConnectorValidationException {
        super.deleteConfigurationData(projectStorageSystem, url);
        super.deleteConfigurationData(projectStorageSystem, this.getRepositoryUrlWithPublicContext());
    }

    private String getRepositoryUrlWithPublicContext() throws ConnectorValidationException {
        return ArtifactoryRepositoryConnectorDescriptor.concatenateNonEmptyWithSlash(this.resolveExternalCredentials().uri, this.publicContextPath, this.getRepositoryOrBucketName(), this.getPathSuffix());
    }

    @Override
    protected ArtifactoryRepositoryInfo getRepositoryInfo() {
        return new ArtifactoryRepositoryInfo();
    }

    protected SimpleArtifactoryClient getClient() throws ConnectorValidationException {
        ExternalCredentials credentials = this.resolveExternalCredentials();
        return new SimpleArtifactoryClient(credentials, this.publicContextPath, LOGGER);
    }
}

