/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.revision_interpretation;

import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.index.repository.artifact_store.ArtifactStoreItemData;
import com.teamscale.index.repository.artifact_store.IArtifactStoreCommitResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.collections.Pair;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class CompoundCommitResolver
implements IArtifactStoreCommitResolver {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<IArtifactStoreCommitResolver> resolvers;
    private final boolean allowExtractionFailures;

    CompoundCommitResolver(List<IArtifactStoreCommitResolver> resolvers, boolean allowExtractionFailures) {
        this.resolvers = resolvers;
        this.allowExtractionFailures = allowExtractionFailures;
    }

    @Override
    public Optional<Pair<String, CommitDescriptor>> resolveRevisionAndCommit(ArtifactStoreItemData item, @Nullable String branchName) throws RepositoryException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        Optional<Pair<String, CommitDescriptor>> resolvedRevisionAndTimestamp = this.resolvers.stream().map(resolver -> {
            try {
                Optional<Pair<String, CommitDescriptor>> resolved = resolver.resolveRevisionAndCommit(item, branchName);
                LOGGER.debug("Resolver '{}' extracted and resolved '{}' from item '{}' with branch name '{}'.", (Object)item, resolved, (Object)branchName, resolver);
                return resolved;
            }
            catch (RepositoryException e) {
                exceptions.add((Exception)((Object)e));
                return Optional.empty();
            }
        }).flatMap(Optional::stream).findFirst();
        if (resolvedRevisionAndTimestamp.isEmpty() && !exceptions.isEmpty()) {
            this.logOrThrowAggregatedException("'%s' encountered an error during timestamp interpretation of path: %s".formatted(this, item.getFullPath()), exceptions);
        }
        return resolvedRevisionAndTimestamp;
    }

    @Override
    public Optional<CommitDescriptor> resolveCommit(String revision, @Nullable String branchName) throws RepositoryException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        Optional<CommitDescriptor> commitDescriptor = this.resolvers.stream().map(resolver -> {
            try {
                return resolver.resolveCommit(revision, branchName);
            }
            catch (RepositoryException e) {
                exceptions.add((Exception)((Object)e));
                return Optional.empty();
            }
        }).flatMap(Optional::stream).findFirst();
        if (commitDescriptor.isEmpty() && !exceptions.isEmpty()) {
            this.logOrThrowAggregatedException("Failed to resolve timestamp for revision '%s' using '%s'.".formatted(revision, this), exceptions);
        }
        return commitDescriptor;
    }

    @Override
    public Optional<IArtifactStoreCommitResolver.ResolveRevisionResult> resolveRevision(ArtifactStoreItemData itemData) {
        return this.resolvers.stream().map(resolver -> resolver.resolveRevision(itemData)).flatMap(Optional::stream).findFirst();
    }

    @Override
    public boolean mayRequireReschedule() {
        return this.resolvers.stream().anyMatch(IArtifactStoreCommitResolver::mayRequireReschedule);
    }

    @Override
    public void close() throws RepositoryException {
        for (IArtifactStoreCommitResolver resolver : this.resolvers) {
            resolver.close();
        }
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }

    private void logOrThrowAggregatedException(String message, List<Exception> exceptions) throws RepositoryException {
        RepositoryException aggregatedException = new RepositoryException(message + "\nAll messages:\n" + exceptions.stream().map(Throwable::getMessage).collect(Collectors.joining("\n")));
        exceptions.forEach(aggregatedException::addSuppressed);
        if (exceptions.size() < this.resolvers.size()) {
            LOGGER.atInfo().withThrowable((Throwable)aggregatedException).log("Some resolver returned a valid empty result; assuming this revision is not relevant.");
            return;
        }
        if (this.allowExtractionFailures) {
            LOGGER.atWarn().withThrowable((Throwable)aggregatedException).log("Ignoring extraction failure due to configuration setting.");
            return;
        }
        throw aggregatedException;
    }
}

