/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.s3;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.trigger.OptionScheduledTriggerBase;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndex;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.runtime.impl.rollback.PostponedRollbackIndex;
import com.teamscale.core.utils.ProjectUtils;
import com.teamscale.index.external.input.external_storage.EExternalStorageBackendProtocol;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackendIndex;
import com.teamscale.index.external.input.external_storage.ExternalStorageLookup;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.artifact_store.ArchiveIndexBase;
import com.teamscale.index.repository.artifact_store.ArtifactStoreItemData;
import com.teamscale.index.repository.artifact_store.ArtifactStoreUtils;
import com.teamscale.index.repository.artifact_store.IArtifactStoreCommitResolver;
import com.teamscale.index.repository.artifact_store.ItemQueryResultData;
import com.teamscale.index.repository.artifact_store.external_storage.S3ExternalStorageConfigurator;
import com.teamscale.index.repository.artifact_store.s3.S3ArchiveIndex;
import com.teamscale.index.repository.artifact_store.s3.S3ArtifactStore;
import com.teamscale.index.repository.artifact_store.s3.S3RepositoryConnectorDescriptor;
import com.teamscale.index.repository.artifact_store.s3.S3RepositoryInfo;
import com.teamscale.index.repository.git.GitBranchPointerIndex;
import com.teamscale.index.repository.git.GitIndices;
import com.teamscale.index.repository.git.GitMainRepository;
import com.teamscale.index.repository.git.GitRepositoryConnection;
import com.teamscale.index.repository.git.GitRepositoryConnector;
import com.teamscale.index.repository.git.GitRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.GitRepositoryInfoIndex;
import com.teamscale.index.repository.git.autogc.PendingGarbageCollectionIndex;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitRepositoryConnector;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudRepositoryConnector;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerRepositoryConnector;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranchesIndex;
import com.teamscale.index.repository.git.gitea.GiteaRepositoryConnector;
import com.teamscale.index.repository.git.gitea.GiteaRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.github.GitHubRepositoryConnector;
import com.teamscale.index.repository.git.github.GitHubRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.gitlab.GitLabRepositoryConnector;
import com.teamscale.index.repository.git.gitlab.GitLabRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.scm_manager.ScmManagerRepositoryConnector;
import com.teamscale.index.repository.git.scm_manager.ScmManagerRepositoryConnectorDescriptor;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.eclipse.jgit.revwalk.RevCommit;

public class S3GarbageMonitoringTrigger
extends OptionScheduledTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() throws Exception {
        ProjectIndex projectIndex = (ProjectIndex)this.indexLayer.openGlobalIndex(ProjectIndex.class);
        for (ProjectInfo project : projectIndex.getAllProjectInfos()) {
            this.computeGarbageForProject(project);
        }
    }

    private void computeGarbageForProject(ProjectInfo project) throws RepositoryException, RescheduleRequestedException, StorageException, ProjectConfigurationException {
        ProjectConfiguration projectConfiguration = ProjectUtils.retrieveProjectConfig((ProjectInfo)project, (IndexLayer)this.indexLayer);
        this.collectMetricsForConnectors(project, projectConfiguration);
        this.collectMetricsForExternalStorageBackend(project, projectConfiguration);
    }

    private void collectMetricsForExternalStorageBackend(ProjectInfo project, ProjectConfiguration projectConfiguration) throws StorageException, RepositoryException, ProjectConfigurationException, RescheduleRequestedException {
        ExternalStorageBackendIndex externalStorageBackendIndex = (ExternalStorageBackendIndex)this.indexLayer.openGlobalIndex(ExternalStorageBackendIndex.class);
        Optional<ExternalStorageBackend> optStorageBackend = ExternalStorageLookup.getStorageBackend(projectConfiguration, externalStorageBackendIndex);
        if (optStorageBackend.isEmpty()) {
            return;
        }
        ExternalStorageBackend externalStorageBackend = optStorageBackend.get();
        if (externalStorageBackend.backendProtocol() != EExternalStorageBackendProtocol.S3) {
            return;
        }
        ConfigurationInitializationContext context = new ConfigurationInitializationContext(null, this.indexLayer, (IExternalCredentialsProvider)this.indexLayer.openGlobalIndex(ExternalCredentialsIndex.class), ConfigurationInitializationContext.EInitializationReason.OTHER);
        S3RepositoryInfo repositoryInfo = S3ExternalStorageConfigurator.getGeneratedRepositoryInfo(project.getInternalId(), (List<PublicProjectId>)project.getPublicIds(), projectConfiguration.getExternalStorageProjectMappingId(), context, externalStorageBackend);
        String credentialsName = externalStorageBackend.credentialsName();
        ExternalCredentials externalCredentials = ((ExternalCredentialsIndex)this.indexLayer.openGlobalIndex(ExternalCredentialsIndex.class)).getExternalCredentials(credentialsName);
        S3ArtifactStore client = (S3ArtifactStore)ArtifactStoreUtils.getClientForProtocol(externalStorageBackend, externalCredentials, this.indexLayer);
        this.collectMetricsForS3Connection(project, "external-analysis-data", repositoryInfo, client, projectConfiguration);
    }

    private void collectMetricsForConnectors(ProjectInfo project, ProjectConfiguration projectConfiguration) throws StorageException, ProjectConfigurationException, RepositoryException, RescheduleRequestedException {
        for (ConnectorConfiguration connector : projectConfiguration.getConnectors()) {
            ERepositoryConnector connectorType = ERepositoryConnector.findByReadableName((String)connector.getType());
            if (connectorType == null || connectorType != ERepositoryConnector.S3) continue;
            S3ArtifactStore client = this.getS3ClientForConnector(project, connector);
            S3RepositoryInfo repositoryInfo = ArtifactStoreUtils.createS3RepositoryInfo(connector, null);
            repositoryInfo.setProjectConfiguration(projectConfiguration);
            this.collectMetricsForS3Connection(project, connector.getIdentifier(), repositoryInfo, client, projectConfiguration);
        }
    }

    private void collectMetricsForS3Connection(ProjectInfo project, String connectorIdentifier, S3RepositoryInfo repositoryInfo, S3ArtifactStore client, ProjectConfiguration projectConfiguration) throws StorageException, ProjectConfigurationException, RepositoryException, RescheduleRequestedException {
        long garbageSize = this.computeGarbageSizeForS3Connector(project, connectorIdentifier, repositoryInfo, client, projectConfiguration);
        if (garbageSize != -1L) {
            ArchiveIndexBase archiveIndexBase = (ArchiveIndexBase)this.indexLayer.openProjectStorageSystem(project).openProjectIndex(S3ArchiveIndex.class, S3ArchiveIndex.createIndexName(connectorIdentifier), null);
            archiveIndexBase.storeGarbageSize(garbageSize);
        }
    }

    private S3ArtifactStore getS3ClientForConnector(ProjectInfo project, ConnectorConfiguration connector) throws StorageException, ProjectConfigurationException {
        ConfigurationInitializationContext context = new ConfigurationInitializationContext(null, this.indexLayer, (IExternalCredentialsProvider)this.indexLayer.openGlobalIndex(ExternalCredentialsIndex.class), ConfigurationInitializationContext.EInitializationReason.OTHER);
        ConnectorDescriptorBase loadedS3Connector = ConnectorUtils.loadConnector((ConnectorConfiguration)connector, (ConfigurationInitializationContext)context, (InternalProjectId)project.getInternalId());
        S3RepositoryConnectorDescriptor s3Connector = (S3RepositoryConnectorDescriptor)loadedS3Connector;
        return s3Connector.getClient();
    }

    private long computeGarbageSizeForS3Connector(ProjectInfo project, String connectorIdentifier, S3RepositoryInfo s3RepositoryInfo, S3ArtifactStore client, ProjectConfiguration projectConfiguration) throws StorageException, ProjectConfigurationException, RepositoryException, RescheduleRequestedException {
        Set<String> gitConnectorsToCheck = S3GarbageMonitoringTrigger.getGitConnectorsForRevisionResolution(projectConfiguration);
        ConfigurationInitializationContext context = new ConfigurationInitializationContext(null, this.indexLayer, (IExternalCredentialsProvider)this.indexLayer.openGlobalIndex(ExternalCredentialsIndex.class), ConfigurationInitializationContext.EInitializationReason.OTHER);
        Set<String> allGitRevisions = this.getAllGitRevisionsForConnectors(project, projectConfiguration, gitConnectorsToCheck, context);
        ItemQueryResultData items = client.findItems(s3RepositoryInfo, 0);
        return S3GarbageMonitoringTrigger.calculateSizeOfUploadsForNoLongerExistingCommits(s3RepositoryInfo, items, allGitRevisions, project, connectorIdentifier);
    }

    private static Set<String> getGitConnectorsForRevisionResolution(ProjectConfiguration projectConfiguration) {
        HashSet<String> gitConnectorsToCheck = new HashSet<String>();
        for (ConnectorConfiguration connector : projectConfiguration.getConnectors()) {
            ERepositoryConnector connectorType = ERepositoryConnector.findByReadableName((String)connector.getType());
            if (connectorType == null || !ERepositoryConnector.isGitBasedConnector((ERepositoryConnector)connectorType)) continue;
            gitConnectorsToCheck.add(connector.getIdentifier());
        }
        return gitConnectorsToCheck;
    }

    private static long calculateSizeOfUploadsForNoLongerExistingCommits(S3RepositoryInfo repositoryInfo, ItemQueryResultData items, Set<String> allGitRevision, ProjectInfo project, String connectorIdentifier) throws RepositoryException {
        try (IArtifactStoreCommitResolver commitResolver = repositoryInfo.createCommitResolver(connectorIdentifier);){
            HashMap<String, Long> sizeByRevision = new HashMap<String, Long>();
            for (ArtifactStoreItemData item : items) {
                Optional<IArtifactStoreCommitResolver.ResolveRevisionResult> extractRevisionResult = commitResolver.resolveRevision(item);
                if (extractRevisionResult.isEmpty() || !extractRevisionResult.get().revisionType().supportsGarbageMonitoring()) continue;
                long size = item.getContentLength();
                if (allGitRevision.contains(extractRevisionResult.get().revision())) continue;
                sizeByRevision.compute(extractRevisionResult.get().revision(), (key, oldSize) -> oldSize == null ? size : oldSize + size);
            }
            long garbageSize = sizeByRevision.values().stream().mapToLong(l -> l).sum();
            LOGGER.warn("Garbage size for project '{}': '{}' bytes ('{}' commit revisions)", (Object)project.getPrimaryPublicId(), (Object)garbageSize, (Object)sizeByRevision.size());
            long l2 = garbageSize;
            return l2;
        }
    }

    private @NonNull Set<String> getAllGitRevisionsForConnectors(ProjectInfo project, ProjectConfiguration projectConfiguration, Collection<String> gitConnectorIdentifiers, ConfigurationInitializationContext context) throws ProjectConfigurationException, StorageException, RepositoryException {
        HashSet<String> allGitRevisions = new HashSet<String>();
        for (String codeConnectorIdentifier : gitConnectorIdentifiers) {
            ConnectorConfiguration codeConnector = projectConfiguration.getConnectorByIdentifier(codeConnectorIdentifier);
            ConnectorDescriptorBase loadedConnector = ConnectorUtils.loadConnector((ConnectorConfiguration)codeConnector, (ConfigurationInitializationContext)context, (InternalProjectId)project.getInternalId());
            allGitRevisions.addAll(this.getAllGitRevisions((ProjectStorageSystem)this.indexLayer.openProjectStorageSystem(project), (GitRepositoryConnectorDescriptor)loadedConnector));
        }
        return allGitRevisions;
    }

    private GitIndices getGitIndices(GitRepositoryInfoIndex gitInfoIndex, String connectorIdentifier, ProjectStorageSystem projectStorageSystem) throws StorageException {
        return new GitIndices(gitInfoIndex, (ServerOptionIndex)this.indexLayer.openGlobalIndex(ServerOptionIndex.class), (AccessTokenIndex)this.indexLayer.openGlobalIndex(AccessTokenIndex.class), (PostponedRollbackIndex)projectStorageSystem.openProjectIndex(PostponedRollbackIndex.class, null), (RepositoryRevisionIndex)projectStorageSystem.openProjectIndex(RepositoryRevisionIndex.class, null), (PendingGarbageCollectionIndex)this.indexLayer.openGlobalIndex(PendingGarbageCollectionIndex.class), S3GarbageMonitoringTrigger.openCrossRepositoryMergeRequestSourceBranchesIndex(projectStorageSystem, connectorIdentifier));
    }

    private static CrossRepositoryMergeRequestSourceBranchesIndex openCrossRepositoryMergeRequestSourceBranchesIndex(ProjectStorageSystem projectStorageSystem, String connectorIdentifier) throws StorageException {
        return (CrossRepositoryMergeRequestSourceBranchesIndex)projectStorageSystem.openProjectIndex(CrossRepositoryMergeRequestSourceBranchesIndex.class, CrossRepositoryMergeRequestSourceBranchesIndex.createIndexName(connectorIdentifier), null);
    }

    private GitRepositoryConnector buildRepositoryConnector(ProjectStorageSystem projectStorageSystem, GitRepositoryInfoIndex gitInfoIndex, GitRepositoryConnectorDescriptor repositoryConnectorDescriptor) throws StorageException, ProjectConfigurationException {
        GitIndices gitIndices = this.getGitIndices(gitInfoIndex, repositoryConnectorDescriptor.getConnectorIdentifier(), projectStorageSystem);
        IBranchingLayer branchPointerIndexBranchingLayer = S3GarbageMonitoringTrigger.openBranchPointerIndexBranchingLayer(projectStorageSystem, repositoryConnectorDescriptor.getConnectorIdentifier());
        GitRepositoryConnectorDescriptor gitRepositoryConnectorDescriptor = repositoryConnectorDescriptor;
        Objects.requireNonNull(gitRepositoryConnectorDescriptor);
        GitRepositoryConnectorDescriptor gitRepositoryConnectorDescriptor2 = gitRepositoryConnectorDescriptor;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GitLabRepositoryConnectorDescriptor.class, GitHubRepositoryConnectorDescriptor.class, BitbucketServerRepositoryConnectorDescriptor.class, BitbucketCloudRepositoryConnectorDescriptor.class, ScmManagerRepositoryConnectorDescriptor.class, AzureDevOpsGitRepositoryConnectorDescriptor.class, GiteaRepositoryConnectorDescriptor.class}, (Object)((Object)gitRepositoryConnectorDescriptor2), n)) {
            case 0 -> {
                GitLabRepositoryConnectorDescriptor gitLabRepositoryConnectorDescriptor = (GitLabRepositoryConnectorDescriptor)gitRepositoryConnectorDescriptor2;
                yield new GitLabRepositoryConnector(gitLabRepositoryConnectorDescriptor, gitIndices, branchPointerIndexBranchingLayer);
            }
            case 1 -> {
                GitHubRepositoryConnectorDescriptor gitHubRepositoryConnectorDescriptor = (GitHubRepositoryConnectorDescriptor)gitRepositoryConnectorDescriptor2;
                yield new GitHubRepositoryConnector(gitHubRepositoryConnectorDescriptor, (GitHubInstallationIndex)this.indexLayer.openGlobalIndex(GitHubInstallationIndex.class), (ServerOptionIndex)this.indexLayer.openGlobalIndex(ServerOptionIndex.class), (AccessTokenIndex)this.indexLayer.openGlobalIndex(AccessTokenIndex.class), gitIndices, branchPointerIndexBranchingLayer, LOGGER);
            }
            case 2 -> {
                BitbucketServerRepositoryConnectorDescriptor bitbucketServerRepositoryConnectorDescriptor = (BitbucketServerRepositoryConnectorDescriptor)gitRepositoryConnectorDescriptor2;
                yield new BitbucketServerRepositoryConnector(bitbucketServerRepositoryConnectorDescriptor, gitIndices, branchPointerIndexBranchingLayer);
            }
            case 3 -> {
                BitbucketCloudRepositoryConnectorDescriptor bitbucketCloudRepositoryConnectorDescriptor = (BitbucketCloudRepositoryConnectorDescriptor)gitRepositoryConnectorDescriptor2;
                yield new BitbucketCloudRepositoryConnector(bitbucketCloudRepositoryConnectorDescriptor, gitIndices, branchPointerIndexBranchingLayer);
            }
            case 4 -> {
                ScmManagerRepositoryConnectorDescriptor scmManagerRepositoryConnectorDescriptor = (ScmManagerRepositoryConnectorDescriptor)gitRepositoryConnectorDescriptor2;
                yield new ScmManagerRepositoryConnector(scmManagerRepositoryConnectorDescriptor, gitIndices, branchPointerIndexBranchingLayer);
            }
            case 5 -> {
                AzureDevOpsGitRepositoryConnectorDescriptor azureDevOpsGitRepositoryConnectorDescriptor = (AzureDevOpsGitRepositoryConnectorDescriptor)gitRepositoryConnectorDescriptor2;
                yield new AzureDevOpsGitRepositoryConnector(azureDevOpsGitRepositoryConnectorDescriptor, gitIndices, branchPointerIndexBranchingLayer);
            }
            case 6 -> {
                GiteaRepositoryConnectorDescriptor giteaRepositoryConnectorDescriptor = (GiteaRepositoryConnectorDescriptor)gitRepositoryConnectorDescriptor2;
                yield new GiteaRepositoryConnector(giteaRepositoryConnectorDescriptor, gitIndices, branchPointerIndexBranchingLayer);
            }
            default -> new GitRepositoryConnector(repositoryConnectorDescriptor, gitIndices, branchPointerIndexBranchingLayer);
        };
    }

    private static IBranchingLayer openBranchPointerIndexBranchingLayer(ProjectStorageSystem projectStorageSystem, String connectorIdentifier) throws StorageException {
        return projectStorageSystem.openBranchingLayer(GitBranchPointerIndex.createIndexName(connectorIdentifier), GitBranchPointerIndex.class);
    }

    private Set<String> getAllGitRevisions(ProjectStorageSystem projectStorageSystem, GitRepositoryConnectorDescriptor gitConnectorDescriptor) throws StorageException, ProjectConfigurationException, RepositoryException {
        GitRepositoryInfoIndex gitInfoIndex = S3GarbageMonitoringTrigger.openGitInfoIndex(projectStorageSystem, gitConnectorDescriptor.getConnectorIdentifier());
        GitRepositoryConnector connector = this.buildRepositoryConnector(projectStorageSystem, gitInfoIndex, gitConnectorDescriptor);
        connector.externalCredentialsIndex = (ExternalCredentialsIndex)this.indexLayer.openGlobalIndex(ExternalCredentialsIndex.class);
        GitRepositoryConnection connection = this.getGitRepositoryConnection(connector);
        GitMainRepository repository = connection.getMainRepository();
        HashSet<String> allRevisions = new HashSet<String>();
        for (RevCommit commit : repository.getAllCommits()) {
            allRevisions.add(commit.getName());
        }
        return allRevisions;
    }

    private GitRepositoryConnection getGitRepositoryConnection(GitRepositoryConnector connector) throws RepositoryException {
        return connector.createConnection(IProfilingMonitor.EMPTY, ICancelable.neverCanceled(), this.getParallelTaskExecutor());
    }

    private static GitRepositoryInfoIndex openGitInfoIndex(ProjectStorageSystem projectStorageSystem, String connectorIdentifier) throws StorageException {
        return (GitRepositoryInfoIndex)projectStorageSystem.openProjectIndex(GitRepositoryInfoIndex.class, GitRepositoryInfoIndex.createIndexName(connectorIdentifier), null);
    }
}

