/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.common.voting_info;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.index.repository.git.common.VoteOutputDetailsCreator;
import com.teamscale.index.repository.git.common.voting_info.IVotingInfo;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

abstract class VotingInfoWithSeverityLevelsBase<T>
implements IVotingInfo {
    private final List<T> redVoteItems;
    private final List<T> yellowVoteItems;
    private final boolean isIgnoreYellowItemsForVoting;

    VotingInfoWithSeverityLevelsBase(List<T> redVoteItems, List<T> yellowVoteItems, boolean isIgnoreYellowItemsForVoting) {
        this.redVoteItems = redVoteItems;
        this.yellowVoteItems = yellowVoteItems;
        this.isIgnoreYellowItemsForVoting = isIgnoreYellowItemsForVoting;
    }

    @Override
    public boolean isPositiveVote() {
        if (!this.redVoteItems.isEmpty()) {
            return false;
        }
        return this.isIgnoreYellowItemsForVoting || this.yellowVoteItems.isEmpty();
    }

    @Override
    public String getTitle() {
        String description = this.isIgnoreYellowItemsForVoting ? this.createTitleWithDifferentSeverityLevels("") : this.createTitleWithCombinedSeverityLevels("");
        return StringUtils.capitalize((String)description);
    }

    @Override
    public String toReadableDescription() {
        String description = this.isIgnoreYellowItemsForVoting ? this.createTitleWithDifferentSeverityLevels(this.descriptionPrefix()) : this.createTitleWithCombinedSeverityLevels(this.descriptionPrefix());
        return description + ".";
    }

    private String createTitleWithDifferentSeverityLevels(String prefix) {
        int yellowItemsCount;
        int redItemsCount = this.redVoteItems.size();
        if (redItemsCount + (yellowItemsCount = this.yellowVoteItems.size()) == 0) {
            return this.noItemsText();
        }
        StringBuilder builder = new StringBuilder(prefix);
        if (redItemsCount == 0) {
            builder.append("no");
        } else {
            builder.append(redItemsCount);
        }
        builder.append(" ").append(StringUtils.pluralize((String)this.redItemName(), (int)redItemsCount));
        if (yellowItemsCount > 0) {
            builder.append(" and ").append(yellowItemsCount).append(" ").append(StringUtils.pluralize((String)this.yellowItemName(), (int)yellowItemsCount));
        }
        return builder.toString();
    }

    private String createTitleWithCombinedSeverityLevels(String prefix) {
        int itemsCount = this.redVoteItems.size() + this.yellowVoteItems.size();
        if (itemsCount == 0) {
            return this.noItemsText();
        }
        return prefix + itemsCount + " " + StringUtils.pluralize((String)this.itemName(), (int)itemsCount);
    }

    @Override
    public String createVoteOutputDetails(TeamscaleCommitLinkProvider linkProvider, int maxLength) {
        VoteOutputDetailsCreator<Object> voteOutputDetailsCreator = new VoteOutputDetailsCreator<Object>(this.itemName(), item -> this.createDetailsLine(item, linkProvider), maxLength);
        if (this.isIgnoreYellowItemsForVoting) {
            return voteOutputDetailsCreator.createWithSeparatedItems(this.redVoteItems, this.yellowVoteItems, this.redItemsSectionTitle(), this.yellowItemsSectionTitle());
        }
        List combinedItems = CollectionUtils.concatenateLists(this.redVoteItems, this.yellowVoteItems, (List[])new List[0]);
        return voteOutputDetailsCreator.createWithCombinedItems(combinedItems, VotingInfoWithSeverityLevelsBase.toTitle(this.itemName()));
    }

    private static String toTitle(String itemName) {
        return StringUtils.capitalize((String)(StringUtils.stripPrefix((String)itemName, (String)"new ") + "s"));
    }

    private String noItemsText() {
        return "No " + this.itemName() + "s";
    }

    protected abstract String createDetailsLine(T var1, TeamscaleCommitLinkProvider var2);

    protected abstract String itemName();

    protected abstract String redItemName();

    protected abstract String redItemsSectionTitle();

    protected abstract String yellowItemName();

    protected abstract String yellowItemsSectionTitle();

    protected abstract String descriptionPrefix();
}

