/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitlab;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.HttpPaginationUtils;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.repository.git.gitlab.IGitLabApi;
import com.teamscale.index.repository.git.gitlab.data.EAccessLevel;
import com.teamscale.index.repository.git.gitlab.data.GitLabBranch;
import com.teamscale.index.repository.git.gitlab.data.GitLabCommitStatus;
import com.teamscale.index.repository.git.gitlab.data.GitLabDiscussion;
import com.teamscale.index.repository.git.gitlab.data.GitLabHook;
import com.teamscale.index.repository.git.gitlab.data.GitLabMergeRequest;
import com.teamscale.index.repository.git.gitlab.data.GitLabNote;
import com.teamscale.index.repository.git.gitlab.data.GitLabProject;
import com.teamscale.index.repository.git.gitlab.data.GitlabProjectLanguages;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;

public class GitLabClient {
    private static final int PAGE_LIMIT = 100;
    private final String baseUrl;
    private final IGitLabApi gitlab;
    private final Logger logger;

    public GitLabClient(String baseUrl, String accessToken, Logger interactionLogger) {
        this.logger = interactionLogger;
        this.baseUrl = StringUtils.ensureEndsWith((String)baseUrl, (String)"/");
        this.gitlab = (IGitLabApi)Retrofit.builder((String)this.baseUrl).withBearerAuthentication(accessToken).withInteractionLogger(interactionLogger).create(IGitLabApi.class);
    }

    public GitLabProject getProject(String repositoryName) throws ServiceCallException {
        return this.gitlab.getProject(repositoryName);
    }

    public List<GitLabHook> listProjectHooks(String repositoryName) throws ServiceCallException {
        return Arrays.asList(this.gitlab.getProjectHooks(repositoryName));
    }

    public List<GitLabProject> listProjectsUserHasMaintainerAccessTo() throws ServiceCallException {
        return this.gitlab.getProjectsWithAccessLevel(EAccessLevel.MAINTAINER.getLevel());
    }

    public GitlabProjectLanguages getLanguagesForProject(String projectId) throws ServiceCallException {
        return this.gitlab.getLanguagesForProject(projectId);
    }

    public List<GitLabBranch> listBranches(String repositoryName) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> this.gitlab.getBranches(repositoryName, 100), this.gitlab::getNextBranches);
    }

    public void createProjectHook(String repositoryName, String targetUrl) throws ServiceCallException {
        GitLabHook hook = new GitLabHook(targetUrl, true, true, true, false);
        this.gitlab.postProjectHook(repositoryName, hook);
    }

    public void updateProjectHook(int hookId, String repositoryName, String targetUrl) throws ServiceCallException {
        GitLabHook hook = new GitLabHook(targetUrl, true, true, true, false);
        this.gitlab.updateProjectHook(repositoryName, hookId, hook);
    }

    public GitLabMergeRequest getMergeRequest(String repositoryName, long mergeRequestId) throws ServiceCallException {
        return this.gitlab.getMergeRequest(repositoryName, mergeRequestId);
    }

    public String getMergeRequestUrl(String repositoryName, long mergeRequestId) {
        return this.baseUrl + repositoryName + "/merge_requests/" + mergeRequestId;
    }

    public void updateMergeRequestDescription(String repositoryName, long mergeRequestId, String newDescription) throws ServiceCallException {
        this.logger.traceEntry();
        this.logger.debug("Attempting to update description of GitLab merge request in repo {} to say \"{}\"", (Object)repositoryName, (Object)newDescription);
        this.gitlab.updateMergeRequestDescription(repositoryName, mergeRequestId, newDescription);
        this.logger.traceExit();
    }

    public List<GitLabMergeRequest> listOpenMergeRequests(String repositoryName) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> this.gitlab.getOpenMergeRequests(repositoryName, 100), this.gitlab::getNextOpenMergeRequests);
    }

    public GitLabMergeRequest getMergeRequestWithChanges(String repositoryName, long mergeRequestId) throws ServiceCallException {
        return this.gitlab.getMergeRequestWithChanges(repositoryName, mergeRequestId);
    }

    public List<GitLabDiscussion> listOpenOrResolvedMergeRequestDiscussions(String repositoryName, long mergeRequestId) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> this.gitlab.getMergeRequestDiscussions(repositoryName, mergeRequestId, 100), this.gitlab::getNextMergeRequestDiscussions);
    }

    public GitLabDiscussion createMergeRequestDiscussion(String repositoryName, long mergeRequestId, GitLabNote note) throws ServiceCallException {
        return this.gitlab.createMergeRequestDiscussion(repositoryName, mergeRequestId, note);
    }

    public void resolveMergeRequestDiscussion(String repositoryName, long mergeRequestId, String discussionId, boolean resolved) throws ServiceCallException {
        this.gitlab.resolveMergeRequestDiscussion(repositoryName, mergeRequestId, discussionId, resolved);
    }

    public void updateMergeRequestDiscussion(String repositoryName, long mergeRequestId, String discussionId, long noteId, String newBody) throws ServiceCallException {
        this.gitlab.updateMergeRequestDiscussionNote(repositoryName, mergeRequestId, discussionId, noteId, newBody);
    }

    public void replyToMergeRequestDiscussion(String repositoryName, long mergeRequestId, String discussionId, String body) throws ServiceCallException {
        this.gitlab.addNoteToDiscussion(repositoryName, mergeRequestId, discussionId, body);
    }

    public void deleteMergeRequestNote(String repositoryName, long mergeRequestId, long noteId) throws ServiceCallException {
        this.gitlab.deleteMergeRequestNote(repositoryName, mergeRequestId, noteId);
    }

    public EAccessLevel getProjectAccessLevel(String repositoryName) throws ServiceCallException {
        return this.gitlab.getProjectUser(repositoryName, this.getCurrentUserId()).getAccessLevel();
    }

    private int getCurrentUserId() throws ServiceCallException {
        return this.gitlab.getUser().id();
    }

    public List<GitLabCommitStatus> getCommitStatuses(String repositoryName, String commitSha) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> this.gitlab.getCommitStatuses(repositoryName, commitSha, 100), this.gitlab::getNextCommitStatuses);
    }

    public String getVersion() throws ServiceCallException {
        return this.gitlab.getVersion().version();
    }
}

