/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitlab;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.index.merge_request.MergeRequestAnnotationTriggerBase;
import com.teamscale.index.merge_request.MergeRequestUpdateTriggerBase;
import com.teamscale.index.repository.git.common.VotingConnectorUtils;
import com.teamscale.index.repository.git.gitlab.GitLabClient;
import com.teamscale.index.repository.git.gitlab.GitLabMergeRequestAnnotationTrigger;
import com.teamscale.index.repository.git.gitlab.GitLabMergeRequestProvider;
import com.teamscale.index.repository.git.gitlab.data.GitLabCommitStatus;
import com.teamscale.index.repository.git.gitlab.data.GitLabMergeRequest;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

public class GitLabMergeRequestUpdateTrigger
extends MergeRequestUpdateTriggerBase<GitLabMergeRequestProvider, GitLabMergeRequest, GitLabCommitStatus> {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    protected GitLabMergeRequestProvider createMergeRequestProvider(GlobalStorageSystem globalStorageSystem, ProjectStorageSystem projectStorageSystem, String repositoryName) throws StorageException {
        ConnectorConfiguration connector = GitLabMergeRequestUpdateTrigger.extractGitLabConnectorConfiguration(projectStorageSystem, repositoryName, this.getJobExtraParameter());
        ExternalCredentials credentials = GitLabMergeRequestUpdateTrigger.extractCredentials(connector, globalStorageSystem);
        GitLabClient client = new GitLabClient(credentials.uri, credentials.password, LOGGER);
        return new GitLabMergeRequestProvider(repositoryName, client, VotingConnectorUtils.getBuildIncludeExcludePatterns(connector));
    }

    private static ConnectorConfiguration extractGitLabConnectorConfiguration(ProjectStorageSystem projectStorageSystem, String repositoryName, @Nullable String projectId) throws StorageException {
        MetaIndex metaIndex = (MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null);
        List connectors = ((ProjectConfiguration)metaIndex.getValue(ProjectConfiguration.class)).getConnectorsByName(ERepositoryConnector.GITLAB.getReadableName());
        Optional<ConnectorConfiguration> configuration = connectors.stream().filter(connectorConfiguration -> {
            String configuredRepoName = connectorConfiguration.getOptionValue("Repository name");
            return repositoryName.equalsIgnoreCase(configuredRepoName) || projectId != null && projectId.equalsIgnoreCase(configuredRepoName);
        }).findAny();
        if (configuration.isEmpty()) {
            throw new StorageException("Failed to extract " + ERepositoryConnector.GITLAB.getReadableName() + " connector for repository " + repositoryName + ". Tried to find '" + repositoryName + "' or '" + projectId + "', but only found " + connectors.stream().map(connectorConfiguration -> connectorConfiguration.getOptionValue("Repository name")).collect(Collectors.joining("', '", "'", "'")));
        }
        return configuration.get();
    }

    @Override
    protected MergeRequestAnnotationTriggerBase<GitLabMergeRequest, GitLabCommitStatus> createMergeRequestAnnotationTrigger() {
        return new GitLabMergeRequestAnnotationTrigger();
    }
}

