/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.svn;

import com.teamscale.core.concurrency.WrappedExecutorServiceProducer;
import com.teamscale.index.repository.svn.SVNUtils;
import java.io.Closeable;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.conqat.lib.commons.cache4j.ThreadLocalCache;
import org.conqat.lib.commons.cache4j.backend.ECachingStrategy;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.function.FunctionWithException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.io.SVNRepository;

class SvnRepositoryExecutor
implements Closeable {
    private static final int THREAD_COUNT = Integer.parseInt(System.getProperty("com.teamscale.svn.thread-count", "4"));
    private final ExecutorService executor;
    private final Set<SVNRepository> createdRepositories = new IdentityHashSet();
    private final ThreadLocalCache<SvnRepositoryInformation, SVNRepository, SVNException> repositoryCache = new ThreadLocalCache(SvnRepositoryExecutor.class.getName(), information -> information.createRepository(this.createdRepositories), ECachingStrategy.UNLIMITED.getBackend(0));

    public SvnRepositoryExecutor() {
        this.executor = THREAD_COUNT <= 1 ? WrappedExecutorServiceProducer.newSingleThreadPool() : WrappedExecutorServiceProducer.newFixedThreadPool((int)THREAD_COUNT);
    }

    public <T> Future<Pair<T, SVNException>> submit(FunctionWithException<SVNRepository, T, SVNException> task, SVNRepository repository) {
        SvnRepositoryInformation information = new SvnRepositoryInformation(repository);
        return this.executor.submit(() -> {
            try {
                SVNRepository localRepository = (SVNRepository)this.repositoryCache.obtain((Object)information);
                return new Pair(task.apply((Object)localRepository), null);
            }
            catch (SVNException e) {
                return new Pair(null, (Object)e);
            }
        });
    }

    @Override
    public void close() {
        this.executor.shutdown();
        for (SVNRepository repository : this.createdRepositories) {
            repository.closeSession();
        }
    }

    private static class SvnRepositoryInformation {
        private final String location;
        private final ISVNAuthenticationManager authenticationManager;

        public SvnRepositoryInformation(SVNRepository repository) {
            this.location = repository.getLocation().toDecodedString();
            this.authenticationManager = repository.getAuthenticationManager();
        }

        public SVNRepository createRepository(Collection<SVNRepository> repositoryRegistry) throws SVNException {
            SVNRepository repository = SVNUtils.createRepository(this.location, null, null);
            repository.setAuthenticationManager(this.authenticationManager);
            repositoryRegistry.add(repository);
            return repository;
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SvnRepositoryInformation)) {
                return false;
            }
            return this.location.equals(((SvnRepositoryInformation)obj).location);
        }
    }
}

