/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.connectors.rtc;

import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.ERequirementsManagementTool;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.rtc.RtcConnectorUtils;
import com.teamscale.index.requirements_tracing.connectors.RequirementsManagementToolConnectorDescriptorBase;
import com.teamscale.index.requirements_tracing.tools.rtc.model.ERtcWorkItemLinkRole;
import com.teamscale.index.requirements_tracing.triggers.rtc.RtcSpecItemSynchronizer;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;

@ConnectorDescriptor
public class RtcRequirementsManagementToolConnectorDescriptor
extends RequirementsManagementToolConnectorDescriptorBase {
    private static final String ITEM_TYPES_PARAMETER_NAME = "Item types";
    private static final String ITEM_TYPES_PARAMETER_DESCRIPTION = "The types of work items to retrieve. Leave empty for all item types. Specify type abbreviations used in the UI after the arrow symbol, e.g. Task -> T";
    @ConfigExposed(name="Item types", description="The types of work items to retrieve. Leave empty for all item types. Specify type abbreviations used in the UI after the arrow symbol, e.g. Task -> T", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    private PairList<String, String> itemTypes = PairList.from((Object)"Task", (Object)"T");
    @ConfigExposed(name="Projects", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="The projects (or products) in the RTC tracker that specification items are extracted from.")
    private List<String> projects = CollectionUtils.emptyList();
    @ConfigExposed(name="Field filter expression", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="A pattern to filter work items based on their fields. This is sent to the Reportable REST API and will be concatenated with a logical AND to any existing filters.")
    protected String additionalFieldFilter = null;
    @ConfigExposed(name="Custom Fields", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Custom fields to be included. This is a pair list of the field's name or id and a boolean indicating whether the field is user defined (true) or a standard field in RTC. For standard fields, the id must be specified; for user defined fields, the display name. Example: 'target -> false, Blocked -> true'")
    private PairList<String, Boolean> customFields = new PairList();
    @ConfigExposed(name="Included work item link roles", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Links between work items to be included.")
    private List<String> additionalWorkItemLinks = List.of(ERtcWorkItemLinkRole.PARENT.getReadableLinkRole());

    public RtcRequirementsManagementToolConnectorDescriptor() {
        super(ERequirementsManagementTool.RTC);
        this.autoExpose();
    }

    @Override
    protected Class<? extends IssueTrackerSynchronizerBase<?>> getIssueTrackerSynchronizerClass() {
        return RtcSpecItemSynchronizer.class;
    }

    @Override
    protected void configureAdditionalIssueTrackerParameters(TriggerBuilder issueTrackerTriggerBuilder) throws ProjectConfigurationException {
        super.configureAdditionalIssueTrackerParameters(issueTrackerTriggerBuilder);
        issueTrackerTriggerBuilder.setTriggerParameter("project", ITriggerParameter.of(this.projects));
        issueTrackerTriggerBuilder.setTriggerParameter("item-type", ITriggerParameter.of(this.itemTypes));
        issueTrackerTriggerBuilder.setTriggerParameter("field-filter", this.additionalFieldFilter);
        issueTrackerTriggerBuilder.setTriggerParameter("custom-field", ITriggerParameter.of(this.customFields));
        issueTrackerTriggerBuilder.setTriggerParameter("work-item-links", ITriggerParameter.of(this.additionalWorkItemLinks));
    }

    protected boolean shouldStripTrailingSlashFromUrl() {
        return true;
    }

    @Override
    public void validate() throws ConnectorValidationException {
        super.validate();
        this.validateLinkTypes();
    }

    private void validateLinkTypes() throws ConnectorValidationException {
        for (String link : this.additionalWorkItemLinks) {
            if (ERtcWorkItemLinkRole.getTypeForReadableLinkRole(link) != null) continue;
            throw new ConnectorValidationException(link + " is not a valid name for a link between work items in RTC.");
        }
    }

    protected void validateAccountDetails(String url, String username, String password) throws ConnectorValidationException {
        RtcConnectorUtils.validateAccountDetails(url, username, password);
    }
}

