/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper;

import com.polarion.alm.ws.client.planning.PlanningWebService;
import com.polarion.alm.ws.client.projects.ProjectWebService;
import com.polarion.alm.ws.client.security.SecurityWebService;
import com.polarion.alm.ws.client.session.SessionWebService;
import com.polarion.alm.ws.client.tracker.TrackerWebService;
import com.polarion.alm.ws.client.types.Property;
import com.polarion.alm.ws.client.types.planning.Plan;
import com.polarion.alm.ws.client.types.projects.Project;
import com.polarion.alm.ws.client.types.tracker.Change;
import com.polarion.alm.ws.client.types.tracker.CustomFieldType;
import com.polarion.alm.ws.client.types.tracker.EnumOption;
import com.polarion.alm.ws.client.types.tracker.Folder;
import com.polarion.alm.ws.client.types.tracker.Module;
import com.polarion.alm.ws.client.types.tracker.WorkItem;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.index.requirements_tracing.tools.polarion.client.exception.PolarionServerException;
import com.teamscale.index.requirements_tracing.tools.polarion.client.exception.PolarionSessionException;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.PolarionWebServiceFactory;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.EPolarionDefaultWorkItemField;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.PolarionWorkItemLinkRole;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.PolarionWorkItemType;
import com.teamscale.index.requirements_tracing.tools.util.WorkItemUtils;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.conqat.lib.commons.concurrent.FutureWithException;
import org.conqat.lib.commons.concurrent.MoreExecutors;
import org.conqat.lib.commons.function.SupplierWithException;

public class PolarionServiceClient
implements AutoCloseable {
    private static final AtomicInteger THREAD_INDEX = new AtomicInteger();
    private static final String[] MODULE_FIELDS_TO_FETCH = new String[]{"id", "moduleFolder", "title", "homePageContent"};
    private static final String[] PLAN_FIELDS_TO_FETCH = new String[]{"name"};
    private static final Pattern PLAN_URI_PATTERN = Pattern.compile("subterra:data-service:objects:/default/(?<projectId>.+)\\$\\{Plan}(?<planId>.+)");
    private static final String PAGINATED_SQL_QUERY_TEMPLATE = "SELECT wi.C_PK FROM POLARION.WORKITEM wi INNER JOIN LUCENE_QUERY('WorkItem', '%s', 'id') lucene   ON wi.C_PK = lucene.C_PK WHERE wi.C_ID > '%s' ORDER BY wi.C_ID ASC LIMIT %d ";
    private final int workItemPaginationSize = (Integer)TeamscaleSystemProperties.POLARION_WORKITEM_PAGINATION_SIZE.getValue();
    private final ExecutorService executorService;
    private final SessionWebService sessionService;
    private final ObjectPool<TrackerWebService> trackerServicePool;
    private final ObjectPool<ProjectWebService> projectServicePool;
    private final ObjectPool<SecurityWebService> securityServicePool;
    private final ObjectPool<PlanningWebService> planningServicePool;
    private final Credentials credentials;

    public PolarionServiceClient(String connectorId, Credentials credentials, int maximumParallelism) throws PolarionSessionException {
        this.credentials = credentials;
        this.executorService = PolarionServiceClient.buildExecutorService(connectorId, maximumParallelism);
        PolarionWebServiceFactory factory = new PolarionWebServiceFactory(credentials.url());
        this.sessionService = factory.getSessionService();
        this.trackerServicePool = PolarionServiceClient.buildWebServicePool(factory::getTrackerService);
        this.projectServicePool = PolarionServiceClient.buildWebServicePool(factory::getProjectService);
        this.securityServicePool = PolarionServiceClient.buildWebServicePool(factory::getSecurityService);
        this.planningServicePool = PolarionServiceClient.buildWebServicePool(factory::getPlanningService);
        this.login();
    }

    private static ExecutorService buildExecutorService(String connectorId, int maximumParallelism) {
        ThreadFactory threadFactory = r -> new Thread(r, connectorId + "-polarion-http-thread-" + THREAD_INDEX.getAndIncrement());
        return MoreExecutors.newCachedThreadPool((int)1, (int)maximumParallelism, (int)60, (TimeUnit)TimeUnit.SECONDS, (ThreadFactory)threadFactory);
    }

    private static <T> ObjectPool<T> buildWebServicePool(SupplierWithException<T, PolarionSessionException> webServiceFactory) {
        return new GenericObjectPool(new PolarionPooledWebServiceFactory<T>(webServiceFactory));
    }

    private void login() throws PolarionSessionException {
        try {
            this.sessionService.logIn(this.credentials.username, this.credentials.password);
        }
        catch (RemoteException e) {
            throw new PolarionSessionException("Login to Polarion server failed: " + e.getMessage(), e);
        }
    }

    private void endSession() throws PolarionSessionException {
        try {
            this.sessionService.endSession();
        }
        catch (RemoteException e) {
            throw new PolarionSessionException("Ending Polarion server session failed: " + e.getMessage(), e);
        }
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public FutureWithException<Set<Module>, PolarionServerException> getModules(String projectId, String documentLocation) {
        CompletableFuture resultFuture = new CompletableFuture();
        this.performWithService(this.trackerServicePool, trackerWebService -> {
            try {
                Set<String> spaces = PolarionServiceClient.getSpaces(projectId, documentLocation, trackerWebService);
                Set finalResult = Collections.synchronizedSet(new HashSet());
                Consumer<Module[]> onDelegateFinish = modules -> Optional.ofNullable(modules).map(Arrays::asList).ifPresent(finalResult::addAll);
                Supplier<Set> onFinish = () -> finalResult;
                AtomicInteger remainingCalls = new AtomicInteger(spaces.size());
                for (String subspace : spaces) {
                    this.performWithService(this.trackerServicePool, new CombiningTask<TrackerWebService, Module[], Set>(resultFuture, remainingCalls, PolarionServiceClient.createGetModulesTask(projectId, subspace), onDelegateFinish, onFinish));
                }
                return null;
            }
            catch (Exception e) {
                resultFuture.completeExceptionally(e);
                return null;
            }
        });
        return PolarionServiceClient.wrapFuture(resultFuture);
    }

    private static Set<String> getSpaces(String projectId, String documentLocation, TrackerWebService trackerWebService) throws PolarionServerException {
        try {
            Folder[] allFolders = trackerWebService.getFolders(projectId);
            Folder rootFolder = Arrays.stream(allFolders).filter(folder -> documentLocation.equals(folder.getName())).findFirst().orElseThrow(() -> PolarionServiceClient.spaceNotFoundException(documentLocation, allFolders));
            HashSet<String> result = new HashSet<String>();
            LinkedList<Folder> folderToQuery = new LinkedList<Folder>();
            folderToQuery.add(rootFolder);
            while (!folderToQuery.isEmpty()) {
                Folder parentFolder = (Folder)folderToQuery.poll();
                String parentFolderId = parentFolder.getName();
                result.add(parentFolderId);
                Folder[] childFolders = trackerWebService.getChildFolders(projectId, parentFolderId);
                if (childFolders == null) continue;
                folderToQuery.addAll(Arrays.asList(childFolders));
            }
            return result;
        }
        catch (RemoteException e) {
            throw new PolarionServerException("Failed to retrieve Polarion (sub)spaces", e);
        }
    }

    private static PolarionServerException spaceNotFoundException(String documentLocation, Folder[] allFolders) {
        String allSpaces = Arrays.stream(allFolders).map(folder -> folder.getName() + " (" + folder.getTitle() + ")").collect(Collectors.joining(", "));
        return new PolarionServerException("Could not find specification space with name \"%s\". Maybe the title was provided? Found spaces <name (title)>: %s".formatted(documentLocation, allSpaces));
    }

    private static AsyncTask<TrackerWebService, Module[]> createGetModulesTask(String projectId, String subspace) {
        return trackerWebService -> {
            try {
                return trackerWebService.getModulesWithFields(projectId, subspace, MODULE_FIELDS_TO_FETCH);
            }
            catch (RemoteException e) {
                throw new PolarionServerException("Retrieving module for space %s failed: %s".formatted(subspace, e.getMessage()), e);
            }
        };
    }

    public FutureWithException<Module, PolarionServerException> getModuleByUri(String moduleUri) {
        return PolarionServiceClient.wrapFuture(this.performWithService(this.trackerServicePool, trackerWebService -> {
            try {
                return trackerWebService.getModuleByUriWithFields(moduleUri, MODULE_FIELDS_TO_FETCH);
            }
            catch (RemoteException e) {
                throw new PolarionServerException("Retrieving module for URI '%s' from Polarion server failed: %s".formatted(moduleUri, e.getMessage()), e);
            }
        }));
    }

    public FutureWithException<Optional<Plan>, PolarionServerException> getPlanByUri(String planUri) {
        return PolarionServiceClient.wrapFuture(this.performWithService(this.planningServicePool, planningWebService -> PolarionServiceClient.fetchPlanByUri(planUri, planningWebService)));
    }

    private static Optional<Plan> fetchPlanByUri(String planUri, PlanningWebService planningWebService) throws PolarionServerException {
        String query = PolarionServiceClient.buildPlanQuery(planUri);
        try {
            Plan[] plans = planningWebService.searchPlansWithFields(query, null, -1, PLAN_FIELDS_TO_FETCH);
            if (plans == null) {
                return Optional.empty();
            }
            return Arrays.stream(plans).filter(plan -> planUri.equals(plan.getUri())).findFirst();
        }
        catch (RemoteException e) {
            throw new PolarionServerException("Retrieving plan for URI '%s' from Polarion server failed".formatted(planUri), e);
        }
    }

    private static String buildPlanQuery(String planUri) throws PolarionServerException {
        Matcher matcher = PLAN_URI_PATTERN.matcher(planUri);
        if (!matcher.matches()) {
            throw new PolarionServerException("Unable to extract project ID and plan ID from plan URI: %s".formatted(planUri));
        }
        String projectId = matcher.group("projectId");
        String planId = matcher.group("planId");
        return "project.id:\"%s\" AND id:\"%s\"".formatted(projectId, planId);
    }

    public FutureWithException<List<Change>, PolarionServerException> getWorkItemChangeHistory(String workItemUri, Set<String> ignoredFields) {
        return PolarionServiceClient.wrapFuture(this.performWithService(this.trackerServicePool, trackerWebService -> {
            try {
                Change[] changes = trackerWebService.generateHistory(workItemUri, ignoredFields.toArray(new String[0]), new String[0]);
                if (changes == null) {
                    return Collections.emptyList();
                }
                return Arrays.asList(changes);
            }
            catch (RemoteException e) {
                throw new PolarionServerException("Obtaining work item history for the item " + workItemUri + " failed: " + e.getMessage(), e);
            }
        }));
    }

    public FutureWithException<WorkItem, PolarionServerException> getWorkItemInRevision(String workItemUri, String revision, String[] fieldsToFill) {
        return PolarionServiceClient.wrapFuture(this.performWithService(this.trackerServicePool, trackerWebService -> {
            try {
                return trackerWebService.getWorkItemByUriInRevisionWithFields(workItemUri, revision, fieldsToFill);
            }
            catch (RemoteException e) {
                throw new PolarionServerException("Retrieving the work item " + workItemUri + " in revision " + revision + " failed: " + e.getMessage(), e);
            }
        }));
    }

    public FutureWithException<List<WorkItem>, PolarionServerException> queryWorkItems(String query, String[] fieldsToFill) {
        return PolarionServiceClient.wrapFuture(this.performWithService(this.trackerServicePool, trackerWebService -> {
            WorkItem[] workItems;
            boolean notYetAllItemsFetched;
            ArrayList<WorkItem> result = new ArrayList<WorkItem>();
            String lastItemId = "";
            do {
                String paginatedSqlQuery = String.format(PAGINATED_SQL_QUERY_TEMPLATE, query, lastItemId, this.workItemPaginationSize);
                try {
                    workItems = trackerWebService.queryWorkItemsBySQL(paginatedSqlQuery, fieldsToFill);
                }
                catch (RemoteException e) {
                    throw new PolarionServerException(String.format("Querying work items with the query \"%s\" failed: %s", paginatedSqlQuery, e.getMessage()), e);
                }
                if (workItems == null || workItems.length == 0) break;
                result.addAll(Arrays.asList(workItems));
                lastItemId = workItems[workItems.length - 1].getId();
            } while (notYetAllItemsFetched = workItems.length == this.workItemPaginationSize);
            return result;
        }));
    }

    public FutureWithException<Project, PolarionServerException> getProject(String projectId) {
        return PolarionServiceClient.wrapFuture(this.performWithService(this.projectServicePool, projectService -> {
            try {
                return projectService.getProject(projectId);
            }
            catch (RemoteException e) {
                throw new PolarionServerException("Retrieving the Polarion project " + projectId + " failed: " + e.getMessage(), e);
            }
        }));
    }

    public FutureWithException<Boolean, PolarionServerException> hasPermission(String projectId, String permissionId) {
        return PolarionServiceClient.wrapFuture(this.performWithService(this.securityServicePool, securityService -> {
            try {
                return securityService.hasPermission(this.credentials.username, permissionId, projectId);
            }
            catch (RemoteException e) {
                throw new PolarionServerException("Checking the permission " + permissionId + " for project " + projectId + " failed: " + e.getMessage(), e);
            }
        }));
    }

    public FutureWithException<List<PolarionWorkItemType>, PolarionServerException> getWorkItemTypes(String projectId) {
        return PolarionServiceClient.wrapFuture(this.performWithService(this.trackerServicePool, trackerWebService -> {
            ArrayList<PolarionWorkItemType> resolvedWorkItemTypes = new ArrayList<PolarionWorkItemType>();
            try {
                EnumOption[] workItemTypes;
                for (EnumOption workItemType : workItemTypes = trackerWebService.getAllEnumOptionsForId(projectId, "workitem-type")) {
                    String defaultAbbreviation = WorkItemUtils.generateWorkItemNameAbbreviation(workItemType.getName());
                    resolvedWorkItemTypes.add(new PolarionWorkItemType(workItemType.getId(), workItemType.getName(), defaultAbbreviation));
                }
            }
            catch (RemoteException e) {
                throw new PolarionServerException("Failed to retrieve work item type definitions for project '" + projectId + "': " + e.getMessage(), e);
            }
            return resolvedWorkItemTypes;
        }));
    }

    public FutureWithException<Map<String, String>, PolarionServerException> getWorkItemStatuses(String projectId) {
        return PolarionServiceClient.wrapFuture(this.performWithService(this.trackerServicePool, trackerWebService -> {
            try {
                HashMap statusIdToName = new HashMap();
                EnumOption[] workItemStatuses = trackerWebService.getAllEnumOptionsForId(projectId, EPolarionDefaultWorkItemField.STATUS.getPolarionFieldName());
                Arrays.stream(workItemStatuses).forEach(status -> statusIdToName.put(status.getId(), status.getName()));
                return statusIdToName;
            }
            catch (RemoteException e) {
                throw new PolarionServerException("Failed to retrieve work item statuses for project " + projectId + ": " + e.getMessage(), e);
            }
        }));
    }

    public FutureWithException<List<CustomFieldType>, PolarionServerException> getDefinedCustomFieldTypes(String projectId, String workItemTypeId) {
        return PolarionServiceClient.wrapFuture(this.performWithService(this.trackerServicePool, trackerWebService -> {
            try {
                CustomFieldType[] definedCustomFieldTypes = trackerWebService.getDefinedCustomFieldTypes(projectId, workItemTypeId);
                if (definedCustomFieldTypes == null) {
                    return Collections.emptyList();
                }
                return Arrays.asList(definedCustomFieldTypes);
            }
            catch (RemoteException e) {
                throw new PolarionServerException("Failed to retrieve custom fields for work items of type " + workItemTypeId + " in project " + projectId + ": " + e.getMessage(), e);
            }
        }));
    }

    public FutureWithException<List<PolarionWorkItemLinkRole>, PolarionServerException> getPolarionWorkItemLinkRoles(String projectId) {
        return PolarionServiceClient.wrapFuture(this.performWithService(this.trackerServicePool, trackerWebService -> {
            try {
                EnumOption[] linkRoles;
                String oppositeName = "oppositeName";
                ArrayList<PolarionWorkItemLinkRole> workItemLinkRoles = new ArrayList<PolarionWorkItemLinkRole>();
                for (EnumOption enumOption : linkRoles = trackerWebService.getAllEnumOptionsForId(projectId, "workitem-link-role")) {
                    List<Property> properties = Arrays.asList(enumOption.getProperties());
                    Property oppositeNameProperty = properties.stream().filter(property -> property.getKey().equals(oppositeName)).findFirst().orElse(new Property(oppositeName, ""));
                    workItemLinkRoles.add(new PolarionWorkItemLinkRole(enumOption.getId(), enumOption.getName(), oppositeNameProperty.getValue()));
                }
                return workItemLinkRoles;
            }
            catch (RemoteException e) {
                throw new PolarionServerException("Failed to retrieve work item link roles for project '" + projectId + "': " + e.getMessage(), e);
            }
        }));
    }

    @Override
    public void close() throws PolarionSessionException {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(365L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.projectServicePool.close();
        this.securityServicePool.close();
        this.trackerServicePool.close();
        this.endSession();
    }

    private static <T> FutureWithException<T, PolarionServerException> wrapFuture(Future<T> future) {
        return new FutureWithException(future, PolarionServerException.class);
    }

    private <T, S> Future<T> performWithService(ObjectPool<S> pool, AsyncTask<S, T> task) {
        return this.executorService.submit(() -> {
            Object webService = pool.borrowObject();
            try {
                Object _Output = task.performTask(webService);
                return _Output;
            }
            catch (Exception e) {
                pool.invalidateObject(webService);
                webService = null;
                throw e;
            }
            finally {
                if (webService != null) {
                    pool.returnObject(webService);
                }
            }
        });
    }

    public record Credentials(String url, String username, String password) {
        public Credentials(ExternalCredentials externalCredentials) {
            this(externalCredentials.uri, externalCredentials.username, externalCredentials.password);
        }
    }

    private static class PolarionPooledWebServiceFactory<T>
    extends BasePooledObjectFactory<T> {
        private final SupplierWithException<T, PolarionSessionException> supplier;

        private PolarionPooledWebServiceFactory(SupplierWithException<T, PolarionSessionException> supplier) {
            this.supplier = supplier;
        }

        public T create() throws Exception {
            return (T)this.supplier.get();
        }

        public PooledObject<T> wrap(T obj) {
            return new DefaultPooledObject(obj);
        }
    }

    private static interface AsyncTask<_Input, _Output> {
        public _Output performTask(_Input var1) throws Exception;
    }

    private static class CombiningTask<_Input, _ImmediateOutput, _Output>
    implements AsyncTask<_Input, Void> {
        private final CompletableFuture<_Output> future;
        private final AtomicInteger taskCount;
        private final AsyncTask<_Input, _ImmediateOutput> delegate;
        private final Consumer<_ImmediateOutput> onDelegateFinish;
        private final Supplier<_Output> onFinish;

        private CombiningTask(CompletableFuture<_Output> future, AtomicInteger taskCount, AsyncTask<_Input, _ImmediateOutput> delegate, Consumer<_ImmediateOutput> onDelegateFinish, Supplier<_Output> onFinish) {
            this.future = future;
            this.taskCount = taskCount;
            this.delegate = delegate;
            this.onDelegateFinish = onDelegateFinish;
            this.onFinish = onFinish;
        }

        @Override
        public Void performTask(_Input input) {
            if (this.future.isCancelled() || this.future.isCompletedExceptionally()) {
                return null;
            }
            try {
                _ImmediateOutput immediateOutput = this.delegate.performTask(input);
                this.onDelegateFinish.accept(immediateOutput);
                if (this.taskCount.decrementAndGet() == 0) {
                    this.future.complete(this.onFinish.get());
                }
            }
            catch (Exception e) {
                this.future.completeExceptionally(e);
            }
            return null;
        }
    }
}

