/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.index.resource.CodeScopesMappingIndex;
import com.teamscale.index.resource.ContainerIndex;
import com.teamscale.index.resource.ResourceServiceUtils;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.resource.metrics.architecture.MetricsToArchitectureMetricsMappingIndex;
import com.teamscale.index.resource.metrics.code_scopes.CodeScopesMetricsUtils;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class VirtualCodePathUtils {
    public static Set<UniformPath> resolveToCodePaths(UniformPath uniformPath, ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption) throws StorageException {
        return switch (uniformPath.getType()) {
            case UniformPath.EType.ARCHITECTURE -> VirtualCodePathUtils.getArchitectureCodePaths(uniformPath, projectStorageSystem, historyAccessOption);
            case UniformPath.EType.CODE_SCOPES -> VirtualCodePathUtils.getCodeScopeCodePaths(uniformPath, projectStorageSystem, historyAccessOption);
            case UniformPath.EType.CODE -> Set.of(uniformPath);
            default -> throw new IllegalArgumentException("Unexpected type of uniform path: %s".formatted(uniformPath));
        };
    }

    public static Predicate<UniformPath> includedInResolvedTree(@Nullable UniformPath uniformPath, ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption) throws StorageException {
        if (uniformPath == null) {
            return ignored -> true;
        }
        Set<UniformPath> codePaths = VirtualCodePathUtils.resolveToCodePaths(uniformPath, projectStorageSystem, historyAccessOption);
        return VirtualCodePathUtils.isIncludedInTree(codePaths);
    }

    public static Predicate<UniformPath> isIncludedInTree(Set<UniformPath> uniformPaths) {
        return path -> VirtualCodePathUtils.isIncludedInTree(uniformPaths, path);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isIncludedInTree(Set<UniformPath> uniformPaths, UniformPath path) {
        if (uniformPaths.contains(path)) return true;
        if (!uniformPaths.stream().anyMatch(arg_0 -> ((UniformPath)path).hasAncestor(arg_0))) return false;
        return true;
    }

    private static Set<UniformPath> getArchitectureCodePaths(UniformPath uniformPath, ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption) throws StorageException {
        if (!uniformPath.isArchitecturePath()) {
            throw new IllegalArgumentException("Uniform path '%s' is not an architecture path".formatted(uniformPath));
        }
        String stringPath = ResourceServiceUtils.getUniformPathPrefixContainerAware((ContainerIndex)projectStorageSystem.openProjectIndex(ContainerIndex.class, "dir", historyAccessOption), uniformPath.toStringAsMigrationFrontier());
        return UniformPathCompatibilityUtil.convertSet(ArchitectureMetricsUtils.getLeafPaths((MetricsToArchitectureMetricsMappingIndex)projectStorageSystem.openProjectIndex(MetricsToArchitectureMetricsMappingIndex.class, historyAccessOption), stringPath));
    }

    private static Set<UniformPath> getCodeScopeCodePaths(UniformPath uniformPath, ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption) throws StorageException {
        if (!uniformPath.isCodeScopesPath()) {
            throw new IllegalArgumentException("Uniform path '%s' is not a code-scope path".formatted(uniformPath));
        }
        if (uniformPath.isRoot()) {
            return Set.of(UniformPath.codeRoot());
        }
        return CodeScopesMetricsUtils.getAllSubPathsInSameCodeScope((CodeScopesMappingIndex)projectStorageSystem.openProjectIndex(CodeScopesMappingIndex.class, historyAccessOption), uniformPath);
    }

    public static IVirtualPathLookup getVirtualPathLookup(UniformPath basePath, ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption) throws StorageException {
        return switch (basePath.getType()) {
            case UniformPath.EType.ARCHITECTURE -> VirtualCodePathUtils.architecturePathLookup(basePath, projectStorageSystem, historyAccessOption);
            case UniformPath.EType.CODE_SCOPES -> VirtualCodePathUtils.codeScopePathLookup(basePath, projectStorageSystem, historyAccessOption);
            case UniformPath.EType.CODE -> Optional::of;
            default -> throw new IllegalArgumentException("Unexpected type of uniform path: %s".formatted(basePath));
        };
    }

    private static IVirtualPathLookup architecturePathLookup(UniformPath basePath, ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption) throws StorageException {
        CCSMAssert.isTrue((boolean)basePath.isArchitecturePath(), () -> String.format("Expected \"%s\" to be an architecture path", basePath));
        MetricsToArchitectureMetricsMappingIndex mappingIndex = (MetricsToArchitectureMetricsMappingIndex)projectStorageSystem.openProjectIndex(MetricsToArchitectureMetricsMappingIndex.class, historyAccessOption);
        Map<UniformPath, UniformPath> uniformPathToPathInTreemap = ArchitectureMetricsUtils.getRecursivePathMappings(mappingIndex, basePath);
        return p -> Optional.of(p).map(uniformPathToPathInTreemap::get);
    }

    private static IVirtualPathLookup codeScopePathLookup(UniformPath basePath, ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption) throws StorageException {
        CCSMAssert.isTrue((boolean)basePath.isCodeScopesPath(), () -> String.format("Expected \"%s\" to be a code-scope path", basePath));
        if (basePath.isRoot()) {
            CodeScopesMappingIndex mappingIndex = (CodeScopesMappingIndex)projectStorageSystem.openProjectIndex(CodeScopesMappingIndex.class, historyAccessOption);
            Map<UniformPath, CodeScopeName> mappings = mappingIndex.getAllMappings();
            return p -> Optional.of(p).map(mappings::get).map(arg_0 -> ((UniformPath)p).asCodeScopePath(arg_0));
        }
        CodeScopeName codeScope = (CodeScopeName)basePath.getCodeScope().orElseThrow(() -> new IllegalStateException("Non-root path '%s' doesn't have a code-scope?".formatted(basePath)));
        Predicate<UniformPath> includedInResolved = VirtualCodePathUtils.includedInResolvedTree(basePath, projectStorageSystem, historyAccessOption);
        return p -> Optional.of(p).filter(includedInResolved).map(path -> path.asCodeScopePath(codeScope));
    }

    private VirtualCodePathUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    public static interface IVirtualPathLookup {
        public Optional<UniformPath> lookupVirtualPath(UniformPath var1);
    }
}

