/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.metrics.code_scopes;

import com.teamscale.index.resource.CodeScopesMappingIndex;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class CodeScopesMetricsUtils {
    public static final String CODE_SCOPES_ROOT_PATH = UniformPath.EType.CODE_SCOPES.getPrefix();

    public static boolean isCodeScopesRootPath(String uniformPath) {
        return StringUtils.stripSuffix((String)uniformPath, (String)"/").equals(CODE_SCOPES_ROOT_PATH);
    }

    public static boolean isCodeScopeBasePath(String uniformPath) {
        return CodeScopesMetricsUtils.isCodeScopesPath(uniformPath) && UniformPathUtils.splitPath((String)uniformPath).length == 2;
    }

    public static boolean isCodeScopesPath(String uniformPath) {
        return uniformPath.startsWith(CODE_SCOPES_ROOT_PATH);
    }

    public static String removeCodeScopesPathPrefix(String uniformPath) {
        if (!CodeScopesMetricsUtils.isCodeScopesPath(uniformPath)) {
            return uniformPath;
        }
        if (CodeScopesMetricsUtils.isCodeScopesRootPath(uniformPath)) {
            return "";
        }
        return UniformPathUtils.removeFirstSegments((String)uniformPath, (int)2);
    }

    public static Set<UniformPath> getAllSubPathsInSameCodeScope(CodeScopesMappingIndex codeScopesMappingIndex, String uniformPath) throws StorageException {
        return CodeScopesMetricsUtils.getAllSubPathsInSameCodeScope(codeScopesMappingIndex, UniformPathCompatibilityUtil.convert((String)uniformPath));
    }

    public static Set<UniformPath> getAllSubPathsInSameCodeScope(CodeScopesMappingIndex codeScopesMappingIndex, UniformPath uniformPath) throws StorageException {
        if (!uniformPath.isCodeScopesPath()) {
            return Collections.emptySet();
        }
        if (uniformPath.isRoot()) {
            return codeScopesMappingIndex.getAllMappings().keySet();
        }
        UniformPath codePath = uniformPath.resolveToCodePath();
        return codeScopesMappingIndex.getPathsInCodeScope((CodeScopeName)uniformPath.getCodeScope().orElseThrow()).stream().filter(path -> codePath.hasDescendant(path) || codePath.equals(path)).collect(Collectors.toSet());
    }

    private CodeScopesMetricsUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

