/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.retrieval_strategy;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.TrendIndexBase;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class DynamicMetricRecalculatingMetricRetrievalStrategy
implements IMetricRetrievalStrategy {
    private final IMetricRetrievalStrategy delegate;

    public DynamicMetricRecalculatingMetricRetrievalStrategy(IMetricRetrievalStrategy delegate) {
        this.delegate = delegate;
    }

    @Override
    public MetricDirectorySchema getMetricDirectorySchema(HistoryAccessOption historyAccess) throws StorageException {
        return this.delegate.getMetricDirectorySchema(historyAccess);
    }

    @Override
    public MetricDirectorySchema getMetricDirectorySchema() throws StorageException {
        return this.delegate.getMetricDirectorySchema();
    }

    @Override
    public MetricDirectorySchemaEntry getMetricDirectorySchemaEntry(String metricName) throws StorageException {
        return this.delegate.getMetricDirectorySchemaEntry(metricName);
    }

    @Override
    public MetricDirectoryEntry getMetricDirectoryEntry(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        MetricDirectoryEntry entry = this.delegate.getMetricDirectoryEntry(uniformPath, historyAccessOption);
        if (entry == null) {
            return null;
        }
        MetricDirectorySchema schema = this.getMetricDirectorySchema(historyAccessOption);
        CCSMAssert.isTrue((schema.size() == entry.getValues().length ? 1 : 0) != 0, (String)"Schema and value must match.");
        DynamicMetricRecalculatingMetricRetrievalStrategy.recalculateDynamicMetrics(List.of(entry), schema);
        return entry;
    }

    @Override
    public List<MetricDirectoryEntry> getMetricDirectoryEntries(List<String> uniformPathPrefixes, HistoryAccessOption historyAccessOption) throws StorageException {
        List<MetricDirectoryEntry> entries = this.delegate.getMetricDirectoryEntries(uniformPathPrefixes, historyAccessOption);
        MetricDirectorySchema schema = this.getMetricDirectorySchema(historyAccessOption);
        entries.forEach(e -> CCSMAssert.isTrue((e.getValues().length == schema.size() ? 1 : 0) != 0, (String)"Schema and entry values must match."));
        DynamicMetricRecalculatingMetricRetrievalStrategy.recalculateDynamicMetrics(entries, schema);
        return entries;
    }

    private static void recalculateDynamicMetrics(Collection<MetricDirectoryEntry> entries, MetricDirectorySchema schema) {
        Consumer<Object[]> recalculateDynamicMetrics = DynamicMetricRecalculatingMetricRetrievalStrategy.getDynamicMetricCalculator(schema);
        entries.stream().flatMap(DynamicMetricRecalculatingMetricRetrievalStrategy::getMetricsStream).forEach(recalculateDynamicMetrics);
    }

    private static Stream<Object[]> getMetricsStream(MetricDirectoryEntry entry) {
        return Stream.concat(Stream.ofNullable(entry.getValues()), entry.getChildMetricsMap().values().stream());
    }

    @Override
    public List<TrendIndexBase.TrendEntry<Object[]>> extractMetricHistory(UniformPath uniformPath, CommitDescriptor start, CommitDescriptor end) throws StorageException {
        List<TrendIndexBase.TrendEntry<Object[]>> trendEntries = this.delegate.extractMetricHistory(uniformPath, start, end);
        if (!trendEntries.isEmpty()) {
            MetricDirectorySchema schema = this.getMetricDirectorySchema(HistoryAccessOption.readCommit((CommitDescriptor)end));
            Consumer<Object[]> dynamicMetricCalculator = DynamicMetricRecalculatingMetricRetrievalStrategy.getDynamicMetricCalculator(schema);
            for (TrendIndexBase.TrendEntry<Object[]> trendEntry : trendEntries) {
                dynamicMetricCalculator.accept((Object[])trendEntry.value());
            }
        }
        return trendEntries;
    }

    private static Consumer<Object[]> getDynamicMetricCalculator(MetricDirectorySchema schema) {
        ArrayList dynamicMetricComputations = new ArrayList();
        for (MetricDirectorySchemaEntry entry : schema.getAllEntries()) {
            entry.getDynamicMetricComputation().ifPresent(dynamicMetricComputations::add);
        }
        return metrics -> dynamicMetricComputations.forEach(computation -> computation.generateValue(metrics, schema));
    }
}

