/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.analysis.metric;

import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.index.simulink.analysis.SimulinkMetricAnalysis;
import com.teamscale.index.simulink.analysis.SimulinkMetricAnalysisBase;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowMachine;
import org.conqat.lib.simulink.util.StateflowUtils;

@SimulinkMetricAnalysis(name="State Count", description="Counts the number of Stateflow states in a model.", internalName="#states", metricProperties={EMetricProperty.SIZE_METRIC, EMetricProperty.QUALITY_NEUTRAL}, qualityIndicator="Structure")
public class StateCountMetric
extends SimulinkMetricAnalysisBase {
    @Override
    public Double calculateMetricValue(SimulinkModel model) {
        StateflowMachine machine = model.getStateflowMachine();
        if (machine == null) {
            return 0.0;
        }
        return StateflowUtils.countStates((StateflowMachine)machine);
    }
}

