/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import com.teamscale.index.testgap.MethodLastTestedIndex;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.RawMethodLastTestedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.engine.persistence.store.util.KeyValueCollectingCallback;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jetbrains.annotations.TestOnly;

public class RawMethodLastTestedStoreFeature {
    private final ConvenientStore store;

    public RawMethodLastTestedStoreFeature(IStore store) {
        this.store = new ConvenientStore(store);
    }

    public void removeByUniformPath(List<String> partitions, List<String> uniformPaths) throws StorageException {
        if (uniformPaths.isEmpty()) {
            return;
        }
        HashSet<String> deletedUniformPaths = new HashSet<String>(uniformPaths);
        ArrayList<byte[]> keyPrefixes = new ArrayList<byte[]>();
        StorageStringAbbreviator stringPool = this.store.getAbbreviator();
        for (String uniformPath : deletedUniformPaths) {
            for (String partition : partitions) {
                keyPrefixes.add(RawMethodLastTestedStoreFeature.createKeyPrefix(stringPool, partition, uniformPath));
            }
        }
        for (byte[] keyPrefix : keyPrefixes) {
            this.store.removeByPrefix(keyPrefix);
        }
    }

    private static byte[] createKeyPrefix(StorageStringAbbreviator stringPool, String partition, String uniformPath) throws StorageException {
        return ByteArrayUtils.concat((byte[][])new byte[][]{ByteArrayUtils.intToByteArray((int)stringPool.abbreviate(partition)), ByteArrayUtils.intToByteArray((int)stringPool.abbreviate(uniformPath))});
    }

    void setLastTestedTimestamps(PairList<MethodLastTestedIndex.AccessKey, RawMethodLastTestedValue> keysAndTimestamps) throws StorageException {
        StorageStringAbbreviator stringPool = this.store.getAbbreviator();
        Map<String, Integer> abbreviationMap = RawMethodLastTestedStoreFeature.buildStringAbbreviationMap(stringPool, (Collection<MethodLastTestedIndex.AccessKey>)keysAndTimestamps.getFirstList());
        this.store.put(keysAndTimestamps.mapWithException(key -> RawMethodLastTestedStoreFeature.makeStorageKey(key, abbreviationMap), commit -> commit.toByteArray(stringPool)));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void setLastMergedTimestamps(PairList<MethodLastTestedIndex.AccessKey, CommitDescriptor> keysAndTimestamps) throws StorageException {
        StorageStringAbbreviator stringPool = this.store.getAbbreviator();
        UnmodifiableList keys = keysAndTimestamps.getFirstList();
        Map<String, Integer> abbreviationMap = RawMethodLastTestedStoreFeature.buildStringAbbreviationMap(stringPool, (Collection<MethodLastTestedIndex.AccessKey>)keys);
        List rawKeys = CollectionUtils.map((Collection)keys, key -> RawMethodLastTestedStoreFeature.makeStorageKey(key, abbreviationMap));
        @Nullable List existingValues = this.store.get(rawKeys);
        UnmodifiableList mergeCommits = keysAndTimestamps.getSecondList();
        PairList mergedValues = new PairList();
        for (int i = 0; i < mergeCommits.size(); ++i) {
            CommitDescriptor mergeCommit = (CommitDescriptor)mergeCommits.get(i);
            mergedValues.add((Object)((byte[])rawKeys.get(i)), (Object)RawMethodLastTestedValue.appendMergeCommit((byte[])existingValues.get(i), mergeCommit, stringPool));
        }
        this.store.put(mergedValues);
    }

    @TestOnly
    @Nullable RawMethodLastTestedValue getRawLastTestCommitForTesting(String partition, UniformPath uniformPath, OffsetBasedRegion region) throws StorageException {
        return (RawMethodLastTestedValue)this.getTestInfosForMethodLocationsInPartitions(List.of(partition), List.of(new MethodLocation(uniformPath, region))).getSecond(0);
    }

    PairList<MethodLastTestedIndex.AccessKey, RawMethodLastTestedValue> getTestInfosForPartitionsAndExactPath(List<String> partitions, String uniformPath) throws StorageException {
        StorageStringAbbreviator stringPool = this.store.getAbbreviator();
        List keys = CollectionUtils.mapWithException(partitions, partition -> RawMethodLastTestedStoreFeature.createKeyPrefix(stringPool, partition, uniformPath));
        return this.getEntriesStartingWith(keys);
    }

    private PairList<MethodLastTestedIndex.AccessKey, RawMethodLastTestedValue> getEntriesStartingWith(List<byte[]> prefixes) throws StorageException {
        PairList entries = new PairList();
        this.store.scan(prefixes, (IKeyValueCallback)new KeyValueCollectingCallback(entries));
        return this.deserializeEntries((List<byte[]>)entries.getFirstList(), (List<byte[]>)entries.getSecondList());
    }

    PairList<MethodLastTestedIndex.AccessKey, RawMethodLastTestedValue> getTestInfosForPartitionsAndExactPaths(List<String> partitions, List<String> uniformPaths) throws StorageException {
        StorageStringAbbreviator stringPool = this.store.getAbbreviator();
        ArrayList<byte[]> keys = new ArrayList<byte[]>(partitions.size() * uniformPaths.size());
        for (String uniformPath : uniformPaths) {
            for (String partition : partitions) {
                keys.add(RawMethodLastTestedStoreFeature.createKeyPrefix(stringPool, partition, uniformPath));
            }
        }
        return this.getEntriesStartingWith(keys);
    }

    PairList<MethodLastTestedIndex.AccessKey, RawMethodLastTestedValue> getTestInfosForMethodLocationsInPartitions(Collection<String> partitions, Collection<MethodLocation> methodLocations) throws StorageException {
        StorageStringAbbreviator stringPool = this.store.getAbbreviator();
        Map<String, Integer> abbreviationMap = RawMethodLastTestedStoreFeature.buildStringAbbreviationMap(stringPool, partitions, methodLocations);
        ArrayList<byte[]> associatedKeys = new ArrayList<byte[]>();
        for (String partition : partitions) {
            for (MethodLocation location : methodLocations) {
                associatedKeys.add(RawMethodLastTestedStoreFeature.createKey(abbreviationMap, partition, location.getUniformPath(), location.getRegion()));
            }
        }
        return this.getAssociatedMethodTestInfosForKeys(associatedKeys);
    }

    private static Map<String, Integer> buildStringAbbreviationMap(StorageStringAbbreviator stringPool, Collection<String> partitions, Collection<MethodLocation> methodLocations) throws StorageException {
        return stringPool.buildAbbreviationMap((Set)CollectionUtils.unionSet(partitions, (Collection[])new Collection[]{CollectionUtils.map(methodLocations, methodLocation -> methodLocation.getUniformPath().toStringAsMigrationFrontier())}));
    }

    private static Map<String, Integer> buildStringAbbreviationMap(StorageStringAbbreviator stringPool, Collection<MethodLastTestedIndex.AccessKey> keys) throws StorageException {
        HashSet<String> strings = new HashSet<String>();
        for (MethodLastTestedIndex.AccessKey key : keys) {
            strings.add(key.partition);
            strings.add(key.uniformPath.toString());
        }
        return stringPool.buildAbbreviationMap(strings);
    }

    private static byte @NonNull [] createKey(Map<String, Integer> abbreviationMap, String partition, UniformPath uniformPath, OffsetBasedRegion region) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{ByteArrayUtils.intToByteArray((int)abbreviationMap.get(partition)), ByteArrayUtils.intToByteArray((int)abbreviationMap.get(uniformPath.toString())), ByteArrayUtils.intToByteArray((int)region.getStart()), ByteArrayUtils.intToByteArray((int)region.getEnd())});
    }

    PairList<MethodLastTestedIndex.AccessKey, RawMethodLastTestedValue> getTestInfosForMethodLocationsInPartitions(SetMap<String, MethodLocation> methodLocationsByPartition) throws StorageException {
        StorageStringAbbreviator stringPool = this.store.getAbbreviator();
        Map<String, Integer> abbreviationMap = RawMethodLastTestedStoreFeature.buildStringAbbreviationMap(stringPool, (Collection<String>)methodLocationsByPartition.getKeys(), methodLocationsByPartition.getValues());
        ArrayList<byte[]> associatedKeys = new ArrayList<byte[]>();
        for (Map.Entry entry : methodLocationsByPartition.entrySet()) {
            String partition = (String)entry.getKey();
            for (MethodLocation location : (Set)entry.getValue()) {
                associatedKeys.add(RawMethodLastTestedStoreFeature.createKey(abbreviationMap, partition, location.getUniformPath(), location.getRegion()));
            }
        }
        return this.getAssociatedMethodTestInfosForKeys(associatedKeys);
    }

    private PairList<MethodLastTestedIndex.AccessKey, RawMethodLastTestedValue> getAssociatedMethodTestInfosForKeys(List<byte[]> associatedMethodTestInfoKeys) throws StorageException {
        List values = this.store.get(associatedMethodTestInfoKeys);
        return this.deserializeEntries(associatedMethodTestInfoKeys, values);
    }

    private static byte[] makeStorageKey(MethodLastTestedIndex.AccessKey key, Map<String, Integer> abbreviationMap) {
        return RawMethodLastTestedStoreFeature.createKey(abbreviationMap, key.partition, key.uniformPath, key.region);
    }

    private static MethodLastTestedIndex.AccessKey fromStorageKey(Map<Integer, String> unabbreviationMap, byte[] key) {
        String partition = unabbreviationMap.get(ByteArrayUtils.getIntFromByteArray((byte[])key, (int)0));
        UniformPath uniformPath = UniformPath.parse((String)unabbreviationMap.get(ByteArrayUtils.getIntFromByteArray((byte[])key, (int)4)));
        OffsetBasedRegion region = new OffsetBasedRegion(ByteArrayUtils.getIntFromByteArray((byte[])key, (int)8), ByteArrayUtils.getIntFromByteArray((byte[])key, (int)12));
        return new MethodLastTestedIndex.AccessKey(partition, uniformPath, region);
    }

    private PairList<MethodLastTestedIndex.AccessKey, RawMethodLastTestedValue> deserializeEntries(List<byte[]> keys, List<byte[]> values) throws StorageException {
        StorageStringAbbreviator stringPool = this.store.getAbbreviator();
        HashSet<Integer> stringIds = new HashSet<Integer>();
        for (int i = 0; i < keys.size(); ++i) {
            RawMethodLastTestedValue.extractStringIds(values.get(i), stringIds);
            stringIds.add(ByteArrayUtils.getIntFromByteArray((byte[])keys.get(i), (int)0));
            stringIds.add(ByteArrayUtils.getIntFromByteArray((byte[])keys.get(i), (int)4));
        }
        Map unabbreviationMap = stringPool.buildUnabbreviationMap(stringIds);
        PairList result = new PairList();
        for (int i = 0; i < keys.size(); ++i) {
            RawMethodLastTestedValue value = null;
            if (values.get(i) != null) {
                value = RawMethodLastTestedValue.fromByteArray(values.get(i), unabbreviationMap);
            }
            result.add((Object)RawMethodLastTestedStoreFeature.fromStorageKey(unabbreviationMap, keys.get(i)), (Object)value);
        }
        return result;
    }
}

