/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.query;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testgap.TgaDataRetrieverIndexes;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.index.CrossAnnotator;
import com.teamscale.index.testgap.index.FileListDataRetriever;
import com.teamscale.index.testgap.index.ITgaDataRetriever;
import com.teamscale.index.testgap.query.CoverageSourceParameterBase;
import com.teamscale.index.testgap.query.TgaRequestBase;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class TgaFileListRequest
extends TgaRequestBase {
    private final List<UniformPath> uniformPaths;

    private TgaFileListRequest(List<UniformPath> uniformPaths, long baseline, CommitDescriptor endCommit, CoverageSourceParameterBase coverageSourceParameters, ETgaAssessmentType assessmentType, IProjectId projectId, IndexLayer indexLayer) {
        super(coverageSourceParameters, assessmentType, baseline, endCommit, projectId, indexLayer);
        this.uniformPaths = uniformPaths;
    }

    @Override
    protected ITgaDataRetriever createDataRetriever(TgaDataRetrieverIndexes dataRetrieverIndexes, CrossAnnotator crossAnnotator, CodeScopeAware<Boolean> tgaEnablementPerCodeScope) throws StorageException {
        return new FileListDataRetriever(this.uniformPaths, this.getPartitions(), dataRetrieverIndexes, crossAnnotator, null, null, this.testInfoFilter, tgaEnablementPerCodeScope);
    }

    public static TgaFileListRequest createRequest(List<UniformPath> uniformPaths, CommitDescriptor endCommit, CoverageSourceParameterBase coverageParameters, ETgaAssessmentType assessmentType, TimeIntervalBasedServiceQueryOptions timeIntervalParameters, IndexLayer indexLayer, IProjectId projectId, CommitResolvingStorageSystem projectStorageSystem) throws StorageException {
        CommitDescriptor baselineCommit = timeIntervalParameters.resolveBaselineCommit((IFactory<ProjectStorageSystem, StorageException>)((IFactory)() -> projectStorageSystem));
        return new TgaFileListRequest(uniformPaths, baselineCommit.getTimestamp(), endCommit, coverageParameters, assessmentType, projectId, indexLayer);
    }

    @Override
    protected String getTgaRequestPrefix() {
        return "Test gap data for different files";
    }
}

