/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests.extractor;

import com.teamscale.index.resource.path_lookup.IPathLookupIndex;
import com.teamscale.index.resource.path_lookup.PathLookupUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.jetbrains.annotations.VisibleForTesting;

@Index(name="test-path-lookup", options={EStorageOption.BRANCHED, EStorageOption.COMPRESSED, EStorageOption.ABBREVIATE_STRINGS})
public class TestPathLookupIndex
implements IPathLookupIndex {
    private final ValueIndex<List<String>> delegate;

    public TestPathLookupIndex(IStore store) {
        this.delegate = ValueIndex.forStringListWithAbbreviation((IStore)store);
    }

    public void addPaths(PairList<String, String> uniformPathsAndLookupStrings) throws StorageException {
        PairList pairs = new PairList();
        for (Pair uniformPathsAndLookupString : uniformPathsAndLookupStrings) {
            String reversedPath = PathLookupUtils.normalizeAndReversePathEnsureEnding((String)uniformPathsAndLookupString.getSecond());
            pairs.add((Object)reversedPath, (Object)PathLookupUtils.stripLeadingSlash((String)uniformPathsAndLookupString.getFirst()));
        }
        this.delegate.setOrMergeValues(PairList.fromMap((Map)pairs.groupedByFirst()), (oldEntries, newEntries) -> new ArrayList(CollectionUtils.unionSet((Collection)oldEntries, (Collection[])new Collection[]{newEntries})));
    }

    public void removePaths(PairList<String, String> uniformPathsAndLookupStrings) throws StorageException {
        List reversedLookupStrings = CollectionUtils.map((Collection)uniformPathsAndLookupStrings.getSecondList(), PathLookupUtils::normalizeAndReversePathEnsureEnding);
        List previousValues = this.delegate.getValues(reversedLookupStrings);
        CCSMAssert.isTrue((uniformPathsAndLookupStrings.size() == reversedLookupStrings.size() ? 1 : 0) != 0, (String)"List must have equal length");
        HashMap<String, List> entriesToUpdate = new HashMap<String, List>();
        ArrayList<String> entriesToDelete = new ArrayList<String>();
        for (int i = 0; i < uniformPathsAndLookupStrings.size(); ++i) {
            String reversedLookupString = (String)reversedLookupStrings.get(i);
            List prevTestPaths = (List)entriesToUpdate.get(reversedLookupString);
            if (prevTestPaths == null) {
                prevTestPaths = (List)previousValues.get(i);
            }
            if (prevTestPaths == null) continue;
            String testPathToRemove = (String)uniformPathsAndLookupStrings.getFirst(i);
            if (prevTestPaths.remove(testPathToRemove)) {
                entriesToUpdate.put(reversedLookupString, prevTestPaths);
            }
            if (!prevTestPaths.isEmpty()) continue;
            entriesToDelete.add(reversedLookupString);
        }
        this.delegate.setValues(PairList.fromMap(entriesToUpdate));
        this.delegate.removeValues(entriesToDelete);
    }

    @Override
    public PairList<String, String> getEntries() throws StorageException {
        PairList result = new PairList();
        this.delegate.getAllEntries().forEach((key, valueArray) -> valueArray.forEach(value -> result.add(key, value)));
        return result;
    }

    @VisibleForTesting
    public PairList<String, ? extends List<String>> getAllEntries() throws StorageException {
        return this.delegate.getAllEntries();
    }
}

