/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests.extractor.mathworks;

import com.teamscale.index.dependencies.TypeIndexCache;
import com.teamscale.index.testimpact.TestImplementation;
import com.teamscale.index.tests.extractor.ITestCaseExtractionStrategy;
import com.teamscale.index.tests.extractor.TestCaseExtractionUtils;
import com.teamscale.index.tests.extractor.TokenElementTransformContext;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.List;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class MathWorksClassBasedTestCaseExtractionStrategy
implements ITestCaseExtractionStrategy {
    @Override
    public PairList<String, TestImplementation> extractTestCases(TokenElementTransformContext context, TypeIndexCache typeIndex) {
        PairList testCases = new PairList();
        List<ShallowEntity> unitTestClasses = context.getShallowEntitiesWithPreprocessorTokens().stream().filter(MathWorksClassBasedTestCaseExtractionStrategy::isChildClass).toList();
        for (ShallowEntity unitTestClass : unitTestClasses) {
            List<ShallowEntity> testMethodsBlocks = unitTestClass.getChildren().stream().filter(MathWorksClassBasedTestCaseExtractionStrategy::isTestMethodsBlock).toList();
            for (ShallowEntity methodsBlock : testMethodsBlocks) {
                List<ShallowEntity> testFunctions = methodsBlock.getChildren().stream().filter(MathWorksClassBasedTestCaseExtractionStrategy::isTestFunction).toList();
                for (ShallowEntity functionEntity : testFunctions) {
                    testCases.add(MathWorksClassBasedTestCaseExtractionStrategy.extractNameAndTestImplementation(unitTestClass.getName(), context, functionEntity));
                }
            }
        }
        return testCases;
    }

    private static boolean isChildClass(ShallowEntity entity) {
        if (!entity.getSubtype().equals("class")) {
            return false;
        }
        List parentClassTokens = LanguageFeatureParser.MATLAB.extractParentClassTokens(entity);
        return !parentClassTokens.isEmpty();
    }

    private static boolean isTestMethodsBlock(ShallowEntity entity) {
        if (!entity.getSubtype().equals("methods")) {
            return false;
        }
        return LanguageFeatureParser.MATLAB.containsInputParameter(entity, "Test");
    }

    private static boolean isTestFunction(ShallowEntity entity) {
        if (entity.getType() != EShallowEntityType.METHOD) {
            return false;
        }
        return LanguageFeatureParser.MATLAB.containsInputParameter(entity, "testCase");
    }

    static Pair<String, TestImplementation> extractNameAndTestImplementation(String firstTestNameSegment, TokenElementTransformContext context, ShallowEntity functionEntity) {
        UniformPath testPath = TestCaseExtractionUtils.convertToTestImplementationUniformPath(context.getUniformPath(), firstTestNameSegment, functionEntity.getName());
        String testName = firstTestNameSegment + UniformPathUtils.SEPARATOR + functionEntity.getName();
        return TestCaseExtractionUtils.buildTestUniformPathWithTestImplementation(testName, context, testPath, functionEntity);
    }
}

