/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.thresholds;

import com.teamscale.core.analysis.configuration.index.MetricThresholdConfigurationIndex;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.project.ProjectOptionIndex;
import com.teamscale.core.option.project.ProjectOptionRegistry;
import com.teamscale.index.metrics.threshold.MetricThresholdConfigurationDefaults;
import com.teamscale.index.metrics.threshold.MetricThresholdEvaluator;
import com.teamscale.index.thresholds.ProjectThresholdConfigurationOption;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ProjectThresholdConfigurationUtils {
    public static MetricThresholdEvaluator getThresholdEvaluator(String thresholdConfigurationName, IStorageInfo serviceInfo, MetricSchemaRetrieverFactory metricSchemaRetrieverFactory) throws StorageException {
        MetricThresholdConfiguration thresholdConfiguration = ProjectThresholdConfigurationUtils.getThresholdConfiguration(thresholdConfigurationName, serviceInfo, metricSchemaRetrieverFactory);
        return new MetricThresholdEvaluator(thresholdConfiguration);
    }

    public static MetricThresholdConfiguration getThresholdConfiguration(String thresholdConfigurationName, IStorageInfo storageInfo, MetricSchemaRetrieverFactory schemaRetrieverFactory) throws StorageException {
        return ProjectThresholdConfigurationUtils.getThresholdConfiguration(thresholdConfigurationName, storageInfo, schemaRetrieverFactory, true);
    }

    public static MetricThresholdConfiguration getThresholdConfiguration(String thresholdConfigurationName, IStorageInfo storageInfo, MetricSchemaRetrieverFactory schemaRetrieverFactory, boolean includeBaseConfigurations) throws StorageException {
        if (MetricThresholdConfigurationDefaults.isProjectDefaultConfiguration(thresholdConfigurationName)) {
            return ProjectThresholdConfigurationUtils.getProjectDefaultThresholdConfiguration(storageInfo, schemaRetrieverFactory, includeBaseConfigurations);
        }
        return ProjectThresholdConfigurationUtils.loadNonProjectDefaultThresholdConfiguration(thresholdConfigurationName, storageInfo, schemaRetrieverFactory, includeBaseConfigurations);
    }

    private static MetricThresholdConfiguration getProjectDefaultThresholdConfiguration(IStorageInfo storageInfo, MetricSchemaRetrieverFactory schemaRetrieverFactory, boolean includeBaseConfigurations) throws StorageException {
        ProjectOptionIndex projectOptionIndex = (ProjectOptionIndex)storageInfo.getProjectStorageSystem().openProjectIndex(ProjectOptionIndex.class, null);
        ProjectThresholdConfigurationOption option = (ProjectThresholdConfigurationOption)ProjectOptionRegistry.getInstance().getOption("<p>", "threshold.configuration", null, ProjectThresholdConfigurationOption.class, (OptionIndexBase)projectOptionIndex);
        CCSMAssert.isNotNull((Object)option, (String)"Option with name'threshold.configuration' does not exist");
        return ProjectThresholdConfigurationUtils.loadNonProjectDefaultThresholdConfiguration(option.thresholdConfigurationName, storageInfo, schemaRetrieverFactory, includeBaseConfigurations);
    }

    private static @NonNull MetricThresholdConfiguration loadNonProjectDefaultThresholdConfiguration(String thresholdConfigurationName, IStorageInfo storageInfo, MetricSchemaRetrieverFactory schemaRetrieverFactory, boolean includeBaseConfigurations) throws StorageException {
        CCSMAssert.isFalse((boolean)MetricThresholdConfigurationDefaults.isProjectDefaultConfiguration(thresholdConfigurationName), (String)"Project Default is not allowed here");
        if (MetricThresholdConfigurationDefaults.isBuiltInThresholdConfiguration(thresholdConfigurationName)) {
            MetricDirectorySchema schema = schemaRetrieverFactory.createForType(UniformPath.EType.CODE).getPublicMetricSchema();
            return MetricThresholdConfigurationDefaults.createTeamscaleDefaultConfiguration(schema, thresholdConfigurationName);
        }
        MetricThresholdConfiguration thresholdConfiguration = ProjectThresholdConfigurationUtils.loadNonBuiltInThresholdConfiguration(storageInfo.getGlobalStorageSystem(), thresholdConfigurationName, includeBaseConfigurations);
        if (thresholdConfiguration == null) {
            throw new StorageException("Threshold configuration with name " + thresholdConfigurationName + " not found");
        }
        return thresholdConfiguration;
    }

    private static @Nullable MetricThresholdConfiguration loadNonBuiltInThresholdConfiguration(GlobalStorageSystem globalStorageSystem, String thresholdConfigurationName, boolean loadBaseConfigurations) throws StorageException {
        MetricThresholdConfigurationIndex metricConfigurationIndex = (MetricThresholdConfigurationIndex)globalStorageSystem.openGlobalIndex(MetricThresholdConfigurationIndex.class);
        if (loadBaseConfigurations) {
            return metricConfigurationIndex.getConfigurationAndLoadBaseConfiguration(thresholdConfigurationName);
        }
        return metricConfigurationIndex.getConfigurationWithoutLoadingBaseConfiguration(thresholdConfigurationName);
    }

    private ProjectThresholdConfigurationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

