/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.index.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.index.model.EAssessmentSpecification;
import com.teamscale.core.analysis.configuration.index.model.EMetricSchemaSource;
import com.teamscale.core.analysis.configuration.index.model.EThresholdEvaluationOption;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.NamedConfigurableObjectBase;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@IndexValueClass(containedInBackup=true)
public abstract class MetricThresholdBase
extends NamedConfigurableObjectBase {
    private static final long serialVersionUID = 1L;
    private static final String PATH_SEPARATOR = "/";
    @JsonProperty(value="customName")
    private @Nullable String customName;
    @JsonProperty(value="thresholdYellow")
    private @Nullable Double thresholdYellow;
    @JsonProperty(value="thresholdRed")
    private @Nullable Double thresholdRed;
    @JsonProperty(value="subPath")
    private @Nullable String subPath;
    @JsonProperty(value="metricSchemaSource")
    private EMetricSchemaSource metricSchemaSource = EMetricSchemaSource.CODE_METRICS;
    @JsonProperty(value="assessmentSpecification")
    private EAssessmentSpecification assessmentSpecification = EAssessmentSpecification.DEFAULT;
    @JsonProperty(value="evaluationOptions")
    private final Set<EThresholdEvaluationOption> evaluationOptions = EnumSet.noneOf(EThresholdEvaluationOption.class);

    protected MetricThresholdBase(String metricName) {
        super(metricName);
    }

    protected MetricThresholdBase(String metricName, @Nullable String customName, @Nullable String subPath, EMetricSchemaSource metricSchemaSource, EAssessmentSpecification assessmentSpecification, EnumSet<EThresholdEvaluationOption> evaluationOptions, @Nullable Double thresholdYellow, @Nullable Double thresholdRed) {
        super(metricName);
        this.customName = customName;
        this.subPath = subPath;
        this.metricSchemaSource = metricSchemaSource;
        this.assessmentSpecification = assessmentSpecification;
        this.evaluationOptions.addAll(evaluationOptions);
        this.thresholdYellow = thresholdYellow;
        this.thresholdRed = thresholdRed;
    }

    protected MetricThresholdBase(MetricThresholdBase threshold, @Nullable Double thresholdYellow, @Nullable Double thresholdRed) {
        this(threshold.getMetricName());
        this.customName = threshold.getCustomName();
        this.subPath = threshold.getSubPath();
        this.metricSchemaSource = threshold.getMetricSchemaSource();
        this.assessmentSpecification = threshold.getAssessmentSpecification();
        this.evaluationOptions.addAll(threshold.getEvaluationOptions());
        this.thresholdYellow = thresholdYellow;
        this.thresholdRed = thresholdRed;
    }

    public void setThresholdYellow(@Nullable Double thresholdYellow) {
        this.thresholdYellow = thresholdYellow;
    }

    public void setThresholdRed(@Nullable Double thresholdRed) {
        this.thresholdRed = thresholdRed;
    }

    public @Nullable String getSubPath() {
        return this.subPath;
    }

    public @Nullable UniformPath getSubPathUniformPath() {
        if (this.getSubPath() == null) {
            return null;
        }
        return UniformPathCompatibilityUtil.convert((String)this.subPath);
    }

    public void setSubPath(@Nullable String subPath) {
        this.subPath = subPath;
    }

    @Override
    @Deprecated
    public String getName() {
        return super.getName();
    }

    public String getMetricName() {
        return super.getName();
    }

    public @Nullable String getCustomName() {
        return this.customName;
    }

    public void setCustomName(@Nullable String customName) {
        this.customName = customName;
    }

    public String getDisplayName() {
        if (!StringUtils.isEmpty((String)this.getCustomName())) {
            return this.getCustomName();
        }
        return this.getMetricName();
    }

    public @Nullable Double getThresholdYellow() {
        return this.thresholdYellow;
    }

    public @Nullable Double getThresholdRed() {
        return this.thresholdRed;
    }

    public boolean isYellowThresholdSet() {
        return this.thresholdYellow != null;
    }

    public boolean isRedThresholdSet() {
        return this.thresholdRed != null;
    }

    public boolean isAnyThresholdSet() {
        return this.isYellowThresholdSet() || this.isRedThresholdSet();
    }

    public void setMetricSchemaSource(EMetricSchemaSource metricSchemaSource) {
        this.metricSchemaSource = metricSchemaSource;
    }

    public EMetricSchemaSource getMetricSchemaSource() {
        return this.metricSchemaSource;
    }

    public EAssessmentSpecification getAssessmentSpecification() {
        return this.assessmentSpecification;
    }

    public void setAssessmentSpecification(EAssessmentSpecification assessmentSpecification) {
        this.assessmentSpecification = assessmentSpecification;
    }

    public Set<EThresholdEvaluationOption> getEvaluationOptions() {
        if (this.evaluationOptions.contains(null)) {
            return EnumSet.noneOf(EThresholdEvaluationOption.class);
        }
        return this.evaluationOptions;
    }

    public void setEvaluationOption(EThresholdEvaluationOption evaluationOption) {
        this.evaluationOptions.add(evaluationOption);
    }

    public void setEvaluationOptions(Collection<EThresholdEvaluationOption> evaluationOptions) {
        this.evaluationOptions.addAll(evaluationOptions);
    }

    public void validate() throws MetricThresholdConfigurationException {
        if (this.assessmentSpecification == null) {
            throw new MetricThresholdConfigurationException("Assessment specification is not set");
        }
        if (!this.metricSchemaSource.isSubPathValid(this.subPath)) {
            throw new MetricThresholdConfigurationException("Invalid sub path for threshold with metric from source " + String.valueOf((Object)this.metricSchemaSource) + ". Sub path is: " + this.subPath);
        }
    }

    public void adjustValues() {
        this.ensureCorrectSubPath();
    }

    private void ensureCorrectSubPath() {
        if (!StringUtils.isEmpty((String)this.subPath)) {
            this.subPath = this.subPath.replace("\\", PATH_SEPARATOR);
        }
    }

    @Override
    public String toString() {
        return "MetricThresholdBase [displayName=" + this.getDisplayName() + ", metricName=" + this.getMetricName() + ", customName=" + this.customName + "]";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricThresholdBase that = (MetricThresholdBase)o;
        return Objects.equals(this.customName, that.customName) && Objects.equals(this.thresholdYellow, that.thresholdYellow) && Objects.equals(this.thresholdRed, that.thresholdRed) && Objects.equals(this.subPath, that.subPath) && this.metricSchemaSource == that.metricSchemaSource && this.assessmentSpecification == that.assessmentSpecification && Objects.equals(this.evaluationOptions, that.evaluationOptions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.customName, this.thresholdYellow, this.thresholdRed, this.subPath, this.metricSchemaSource, this.assessmentSpecification, this.evaluationOptions});
    }
}

