/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.index.model;

import com.teamscale.core.analysis.configuration.index.model.MetricThreshold;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.ListMap;

final class MetricThresholdHintBasedOrderer {
    private final List<MetricThreshold> inputThresholds;
    private List<MetricThreshold> orderedThresholds;
    private Set<MetricThreshold> processedThresholds;
    private ListMap<String, MetricThreshold> thresholdsByPrecedingDisplayName = new ListMap();

    private MetricThresholdHintBasedOrderer(List<MetricThreshold> metricThresholdList) {
        this.inputThresholds = metricThresholdList;
    }

    public static List<MetricThreshold> order(List<MetricThreshold> thresholdsToOrder) {
        MetricThresholdHintBasedOrderer orderer = new MetricThresholdHintBasedOrderer(thresholdsToOrder);
        orderer.order();
        return orderer.getOrderedThresholds();
    }

    private List<MetricThreshold> getOrderedThresholds() {
        return this.orderedThresholds;
    }

    private void order() {
        this.orderedThresholds = new ArrayList<MetricThreshold>();
        this.processedThresholds = new IdentityHashSet();
        this.fillThresholdsByPrecedingDisplayName();
        this.addThresholdsByPrecedingDisplayNameToResult("##FIRST##");
        for (MetricThreshold threshold : this.inputThresholds) {
            if (this.processedThresholds.contains(threshold)) continue;
            this.orderedThresholds.add(threshold);
            this.processedThresholds.add(threshold);
            this.addThresholdsByPrecedingDisplayNameToResult(threshold.getDisplayName());
        }
    }

    private void addThresholdsByPrecedingDisplayNameToResult(String precedingDisplayName) {
        if (!this.thresholdsByPrecedingDisplayName.containsCollection((Object)precedingDisplayName)) {
            return;
        }
        List thresholds = (List)this.thresholdsByPrecedingDisplayName.getCollection((Object)precedingDisplayName);
        this.orderedThresholds.addAll(thresholds);
        this.processedThresholds.addAll(thresholds);
    }

    private void fillThresholdsByPrecedingDisplayName() {
        for (MetricThreshold threshold : this.inputThresholds) {
            if (threshold.getPrecedingThresholdDisplayName() == null) continue;
            this.thresholdsByPrecedingDisplayName.add((Object)threshold.getPrecedingThresholdDisplayName(), (Object)threshold);
        }
    }
}

