/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.function.Supplier;
import org.conqat.engine.index.shared.CodeScopeName;

public class CodeScopeAwareObjectBuilder<T> {
    private final LinkedHashMap<CodeScopeName, T> contents = new LinkedHashMap();
    private final T defaultValue;

    public CodeScopeAwareObjectBuilder(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public CodeScopeAware<T> build() {
        return new CodeScopeAware<T>(this.contents, this.defaultValue);
    }

    public CodeScopeAwareObjectBuilder<T> setContents(CodeScopeName codeScopeName, T valueInCodeScope) {
        this.contents.put(codeScopeName, valueInCodeScope);
        return this;
    }

    public Optional<T> getContents(CodeScopeName codeScopeName) {
        return Optional.ofNullable(this.contents.get(codeScopeName));
    }

    public boolean contains(CodeScopeName codeScopeName) {
        return this.contents.containsKey(codeScopeName);
    }

    public T computeIfAbsent(CodeScopeName codeScopeName, Supplier<T> computeIfAbsent) {
        if (this.contents.containsKey(codeScopeName)) {
            return this.contents.get(codeScopeName);
        }
        T newValue = computeIfAbsent.get();
        this.contents.put(codeScopeName, newValue);
        return newValue;
    }
}

