/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.apple;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.authenticate.apple.AppleIdmsAppIdentification;
import com.teamscale.core.authenticate.apple.EAppleEnvironment;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.PasswordOption;
import java.lang.runtime.SwitchBootstraps;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;

@ExportToTypeScript
@Option(id="apple.idms.application.identification", name="Apple IdMS", type=EOptionType.SERVER, visibilityFeatureToggle=EFeatureToggle.ENABLE_APPLE_SPECIFIC_FEATURES, category=EOptionCategory.APPLE, orderingHint=100)
@IndexValueClass(containedInBackup=true)
public class AppleIdmsAppIdentificationOption
implements IOption {
    public static final String OPTION_ID = "apple.idms.application.identification";
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="prodApplicationAdminPassword")
    @PasswordOption
    @OptionFieldDescription(name="Production Password", description="The application admin password set during the registration.")
    public String prodApplicationAdminPassword;
    @JsonProperty(value="uatApplicationAdminPassword")
    @PasswordOption
    @OptionFieldDescription(name="UAT Password", description="The application admin password set during the registration.")
    public String uatApplicationAdminPassword;
    @JsonProperty(value="prodApplicationId")
    @OptionFieldDescription(name="Production App ID", description="The application ID obtained during the registration.")
    private String prodApplicationId;
    @JsonProperty(value="uatApplicationId")
    @OptionFieldDescription(name="UAT App ID", description="The application ID obtained during the registration.")
    private String uatApplicationId;

    public AppleIdmsAppIdentificationOption() {
    }

    @VisibleForTesting
    public AppleIdmsAppIdentificationOption(String uatApplicationId, String uatApplicationAdminPassword) {
        this.prodApplicationId = uatApplicationId;
        this.prodApplicationAdminPassword = uatApplicationAdminPassword;
    }

    private static @Nullable String validateApplicationId(String id, String readableName) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        try {
            long appId = Long.parseLong(id);
            if (appId == 0L) {
                return readableName + " may not be 0";
            }
        }
        catch (NumberFormatException e) {
            return readableName + " must be a valid number";
        }
        return null;
    }

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        String errorMessage = AppleIdmsAppIdentificationOption.validateApplicationId(this.prodApplicationId, "Prod Application ID");
        if (errorMessage != null) {
            return errorMessage;
        }
        return AppleIdmsAppIdentificationOption.validateApplicationId(this.uatApplicationId, "UAT Application ID");
    }

    public AppleIdmsAppIdentification getValuesForEnvironment(EAppleEnvironment environment) throws StorageException {
        String applicationIdString;
        EAppleEnvironment eAppleEnvironment = environment;
        int n = 0;
        String applicationAdminPassword = switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"PROD", "UAT"}, (EAppleEnvironment)eAppleEnvironment, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                applicationIdString = this.prodApplicationId;
                yield this.prodApplicationAdminPassword;
            }
            case 1 -> {
                applicationIdString = this.uatApplicationId;
                yield this.uatApplicationAdminPassword;
            }
            case -1 -> throw new IllegalStateException("Environment must not be null");
        };
        long applicationId = 0L;
        if (applicationIdString != null && !applicationIdString.isEmpty()) {
            applicationId = Long.parseLong(applicationIdString);
        }
        if (applicationId == 0L || StringUtils.isEmpty((String)applicationAdminPassword)) {
            throw new StorageException("Apple IdMS application identification is invalid. The server option is not set for " + String.valueOf((Object)environment) + " environments");
        }
        return new AppleIdmsAppIdentification(applicationId, applicationAdminPassword);
    }
}

