/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.base;

import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.AuthenticationToolStrategyBase;
import com.teamscale.core.authenticate.base.IAutoCompletionStrategy;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.base.ServerDescriptionBase;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;

public abstract class AutoCompletionStrategyBase<ServerDescription extends ServerDescriptionBase>
extends AuthenticationToolStrategyBase<ServerDescription>
implements IAutoCompletionStrategy {
    private static final Logger LOGGER = LogManager.getLogger();

    protected AutoCompletionStrategyBase(NamedServer<ServerDescription> server) {
        super(server);
    }

    @Override
    public List<String> getAutoCompletionsAndHandleErrors(String toComplete, int limit) throws AuthenticationToolException {
        if (limit <= 0) {
            throw new AuthenticationToolException("Invalid auto-completion limit provided: " + limit);
        }
        try {
            return CollectionUtils.sort(this.getAutoCompletions(toComplete, limit));
        }
        catch (AuthenticationToolException e) {
            LOGGER.info("Failed to run autocompletion for " + toComplete + ": " + e.getMessage(), (Throwable)((Object)e));
            return Collections.emptyList();
        }
    }

    protected abstract List<String> getAutoCompletions(String var1, int var2) throws AuthenticationToolException;
}

