/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github.index;

import com.google.common.collect.ImmutableList;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.github.GitHubAppUtils;
import com.teamscale.core.authenticate.github.GitHubApplicationDescription;
import com.teamscale.core.authenticate.github.client.GitHubAppClient;
import com.teamscale.core.authenticate.github.dto.Installation;
import com.teamscale.core.authenticate.github.dto.InstallationRepository;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndex;
import com.teamscale.core.authenticate.github.index.LongKey;
import com.teamscale.core.authenticate.github.index.OrgOrUserInstallationsKey;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class GitHubInstallationIndexSynchronizer {
    public static void performFullInstallationIndexSynchronisation(ServerOptionIndex optionIndex, GitHubInstallationIndex installationIndex, AccessTokenIndex tokenIndex, Logger logger) throws StorageException {
        List<GitHubApplicationDescription> applicationDescriptions = GitHubAppUtils.loadAllConfiguredApplications(optionIndex);
        GitHubInstallationIndexSynchronizer.synchronizeConfiguredApplications(installationIndex, applicationDescriptions, tokenIndex, logger);
        GitHubInstallationIndexSynchronizer.removeDeletedApplications(installationIndex, applicationDescriptions, logger);
    }

    private static void synchronizeConfiguredApplications(GitHubInstallationIndex installationIndex, List<GitHubApplicationDescription> applicationDescriptions, AccessTokenIndex tokenIndex, Logger logger) {
        int failedSynchronisations = 0;
        for (GitHubApplicationDescription description : applicationDescriptions) {
            try {
                GitHubInstallationIndexSynchronizer.performSynchronisationWithAppSpecificClient(installationIndex, new GitHubAppClient(description, tokenIndex, logger), logger);
            }
            catch (ServiceCallException | StorageException e) {
                ++failedSynchronisations;
                logger.atError().withThrowable(e).log("Synchronisation of GitHub installation index failed for installed GitHub app {}({}, {}). Continuing with next app.", (Object)description.urlName, (Object)description.appId, (Object)description.serverUrl);
            }
        }
        if (failedSynchronisations == applicationDescriptions.size()) {
            logger.error("Synchronisation of GitHub installation index failed for all installed GitHub apps.");
        }
    }

    private static void removeDeletedApplications(GitHubInstallationIndex installationIndex, List<GitHubApplicationDescription> applicationDescriptions, Logger logger) throws StorageException {
        List storedAppIds = installationIndex.getAllInstalledApps().extractFirstList();
        List configuredAppIds = CollectionUtils.map(applicationDescriptions, applicationDescription -> applicationDescription.appId);
        Set appIdsToRemove = CollectionUtils.subtract((Collection)storedAppIds, (Collection)configuredAppIds);
        logger.debug("Removing the GitHub apps with the following IDs from the installation index: {}", (Object)String.join((CharSequence)", ", appIdsToRemove));
        for (String appId : appIdsToRemove) {
            installationIndex.removeApp(appId);
        }
    }

    public static void performSynchronisationWithAppSpecificClient(GitHubInstallationIndex installationIndex, GitHubAppClient client, Logger logger) throws StorageException, ServiceCallException {
        List<Installation> availableInstallations = client.getAllInstallations();
        for (Installation installation : availableInstallations) {
            try {
                ImmutableList<InstallationRepository> availableRepositories = client.getInstallationRepositories(installation.getId()).getRepositories();
                List repositoryNames = CollectionUtils.map(availableRepositories, InstallationRepository::getFullName);
                OrgOrUserInstallationsKey orgOrUserInstallationsKey = new OrgOrUserInstallationsKey(client.getApplicationDescriptionServerUrl(), installation.getAccountName());
                installationIndex.addInstallation(orgOrUserInstallationsKey, new LongKey(installation.getId()), installation.getAppId(), repositoryNames);
            }
            catch (ServiceCallException e) {
                logger.error("Failed to fetch repositories for installation " + installation.getId() + " for app " + installation.getAppId() + " during GitHub installation index synchronization.", (Throwable)e);
            }
        }
        Set<Long> storedInstallations = installationIndex.getAllInstallationsForApp(client.getApplicationId());
        Set installationsToRemove = CollectionUtils.subtract(storedInstallations, (Collection)CollectionUtils.map(availableInstallations, Installation::getId));
        for (Long installationId : installationsToRemove) {
            String org = installationIndex.getOrganisationForInstallation(installationId);
            if (org == null) continue;
            installationIndex.removeInstallation(new OrgOrUserInstallationsKey(client.getApplicationDescriptionServerUrl(), org), installationId);
        }
    }
}

