/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.index;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.UUID;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="commit-descriptors", options={EStorageOption.COMMIT_ISOLATED}, valueClasses={ParentedCommitDescriptor.class})
public class CommitDescriptorIndex
extends IndexBase
implements IRollbackableIndex,
IProjectIndex {
    public static final String NAME = "commit-descriptors";

    public CommitDescriptorIndex(IStore store) {
        super(store);
    }

    public static CommitDescriptorIndex open(IndexLayer indexLayer, IProjectId projectId) throws StorageException {
        if (SchedulingConstants.isMaintenance(projectId)) {
            return new CommitDescriptorIndex((IStore)new InMemoryStore());
        }
        return indexLayer.openNonHistorizedProjectIndex(CommitDescriptorIndex.class, projectId);
    }

    public void insertCommit(ParentedCommitDescriptor commit) throws StorageException {
        for (CommitDescriptor parent : commit.getParentCommits()) {
            CCSMAssert.isFalse((boolean)parent.equals((Object)commit), (String)"May not be parent of itself!");
            CCSMAssert.isNotNull((Object)this.getCommit(parent), (String)("Encountered non-existing parent " + String.valueOf(parent) + " of commit " + String.valueOf(commit)));
        }
        commit = ParentedCommitDescriptor.cleanCopyOf((ParentedCommitDescriptor)commit);
        this.store.put(commit.toBranchTimestampKey(), StorageUtils.serialize((Serializable)commit));
    }

    public @Nullable ParentedCommitDescriptor getCommit(CommitDescriptor commit) throws StorageException {
        return (ParentedCommitDescriptor)StorageUtils.deserialize((byte[])this.store.get(commit.toBranchTimestampKey()));
    }

    public List<ParentedCommitDescriptor> getCommits(List<CommitDescriptor> commits) throws StorageException {
        return this.getCommitsForKeys(CollectionUtils.map(commits, CommitDescriptor::toBranchTimestampKey));
    }

    private List<ParentedCommitDescriptor> getCommitsForKeys(List<byte[]> keys) throws StorageException {
        return CollectionUtils.mapWithException((Collection)this.store.get(keys), StorageUtils::deserialize);
    }

    public List<ParentedCommitDescriptor> getAllCommits() throws StorageException {
        return this.getCommitsForKeys(StorageUtils.listKeys((IStore)this.store));
    }

    public List<ParentedCommitDescriptor> getCommitsForBranch(final @NonNull String branchName) throws StorageException {
        final ArrayList<ParentedCommitDescriptor> commits = new ArrayList<ParentedCommitDescriptor>();
        ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(this){

            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                if (CommitDescriptorIndex.keyLengthMatchesBranchNameLengthExactly(key, branchName)) {
                    commits.add((ParentedCommitDescriptor)StorageUtils.deserialize((byte[])value));
                }
            }
        };
        this.store.scan(StringUtils.stringToBytes((String)branchName), (IKeyValueCallback)callback);
        callback.throwCaughtException();
        Collections.sort(commits);
        return commits;
    }

    public CommitHistoryScanner getCommitHistoryCollector(CommitDescriptor lastCommitToConsider) {
        return new CommitHistoryScanner(lastCommitToConsider);
    }

    public List<ParentedCommitDescriptor> getCommitHistory(CommitDescriptor lastCommitToConsider, long lowerTimestampBoundary) throws StorageException {
        CommitHistoryScanner commitHistoryScanner = this.getCommitHistoryCollector(lastCommitToConsider);
        ArrayList result = new ArrayList();
        long timeRange = lastCommitToConsider.getTimestamp() - lowerTimestampBoundary;
        commitHistoryScanner.scanTimeRange(timeRange, result::add);
        return CollectionUtils.sort(result);
    }

    public Optional<ParentedCommitDescriptor> getLatestCommitForBranch(String branchName) throws StorageException {
        return Optional.ofNullable((ParentedCommitDescriptor)CollectionUtils.getLast(this.getCommitsForBranch(branchName)));
    }

    public List<ParentedCommitDescriptor> getCommitHistoryWithFirstParentCommits(CommitDescriptor child, long lowerTimestampBoundary) throws StorageException {
        CommitDescriptor parentCommit;
        ArrayList<ParentedCommitDescriptor> parents = new ArrayList<ParentedCommitDescriptor>();
        ParentedCommitDescriptor current = this.getCommit(child);
        if (current != null) {
            parents.add(current);
        }
        HashMap<CommitDescriptor, byte[]> commitCache = new HashMap<CommitDescriptor, byte[]>();
        while (current != null && (parentCommit = current.getFirstParentCommit()) != null) {
            if (!commitCache.containsKey(parentCommit)) {
                this.loadAllCommitsOnBranchIntoCache(parentCommit, lowerTimestampBoundary, commitCache);
            }
            if (!commitCache.containsKey(parentCommit) || (current = (ParentedCommitDescriptor)StorageUtils.deserialize((byte[])commitCache.get(parentCommit))).getTimestamp() <= lowerTimestampBoundary) break;
            parents.add(current);
        }
        return parents;
    }

    private void loadAllCommitsOnBranchIntoCache(CommitDescriptor child, long lowerTimestampBoundary, HashMap<CommitDescriptor, byte[]> cache) throws StorageException {
        String branchName = child.getBranchName();
        this.store.scan(new CommitDescriptor(branchName, lowerTimestampBoundary).toBranchTimestampKey(), child.cloneWithIncrementedTimestamp().toBranchTimestampKey(), (key, value) -> {
            if (CommitDescriptorIndex.keyLengthMatchesBranchNameLengthExactly(key, branchName)) {
                HashMap hashMap = cache;
                synchronized (hashMap) {
                    cache.put(CommitDescriptor.fromBranchTimestampKey((byte[])key), value);
                }
            }
        });
    }

    public Optional<CommitDescriptor> getFirstActualCommitBeforeOrAt(CommitDescriptor commit, long lowerTimestampBoundary) throws StorageException {
        ArrayList keys = new ArrayList();
        long upperTimestampBoundary = commit.getTimestamp();
        if (upperTimestampBoundary < Long.MAX_VALUE) {
            ++upperTimestampBoundary;
        }
        String branchName = commit.getBranchName();
        this.store.scanKeys(new CommitDescriptor(branchName, lowerTimestampBoundary).toBranchTimestampKey(), new CommitDescriptor(branchName, upperTimestampBoundary).toBranchTimestampKey(), (key, value) -> {
            if (CommitDescriptorIndex.keyLengthMatchesBranchNameLengthExactly(key, branchName)) {
                List list = keys;
                synchronized (list) {
                    keys.add(CommitDescriptor.fromBranchTimestampKey((byte[])key));
                }
            }
        });
        if (keys.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((CommitDescriptor)Collections.max(keys));
    }

    static boolean keyLengthMatchesBranchNameLengthExactly(byte[] key, String branchName) {
        byte[] branchTimestampKeyFromBranchName = new CommitDescriptor(branchName, 1L).toBranchTimestampKey();
        return key.length == branchTimestampKeyFromBranchName.length;
    }

    public List<CommitDescriptor> getAllCommitsOnBranchBetweenInclusive(CommitDescriptor startCommit, CommitDescriptor endCommit) throws StorageException {
        CCSMAssert.isTrue((startCommit.getTimestamp() <= endCommit.getTimestamp() ? 1 : 0) != 0, (String)"Start commit must be before end commit");
        CCSMAssert.isTrue((boolean)startCommit.getBranchName().equals(endCommit.getBranchName()), (String)("Can only get commit range for one specific branch, however two different branches were given: " + startCommit.getBranchName() + ", " + endCommit.getBranchName()));
        if (endCommit.getTimestamp() < Long.MAX_VALUE) {
            endCommit = endCommit.cloneWithIncrementedTimestamp();
        }
        String branchName = startCommit.getBranchName();
        ArrayList<CommitDescriptor> commitDescriptors = new ArrayList<CommitDescriptor>();
        this.store.scanKeys(startCommit.toBranchTimestampKey(), endCommit.toBranchTimestampKey(), (key, value) -> {
            if (CommitDescriptorIndex.keyLengthMatchesBranchNameLengthExactly(key, branchName)) {
                List list = commitDescriptors;
                synchronized (list) {
                    commitDescriptors.add(CommitDescriptor.fromBranchTimestampKey((byte[])key));
                }
            }
        });
        return commitDescriptors;
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        if (timestampByBranch.isEmpty()) {
            return;
        }
        String branchName = Objects.requireNonNull((String)CollectionUtils.getAny(timestampByBranch.keySet()));
        if (timestampByBranch.size() == 1 && PreCommitUtils.isPrecommitBranch(branchName)) {
            this.rollbackPrecommitBranch(branchName);
            return;
        }
        HashSet<ParentedCommitDescriptor> deleted = new HashSet<ParentedCommitDescriptor>();
        HashSet requiredParents = new HashSet();
        for (ParentedCommitDescriptor commit : this.getAllCommits()) {
            Long cutOffTimestamp = timestampByBranch.get(commit.getBranchName());
            if (cutOffTimestamp != null && commit.getTimestamp() > cutOffTimestamp) {
                deleted.add(commit);
                continue;
            }
            requiredParents.addAll(commit.getParentCommits());
        }
        if (!CollectionUtils.intersectionSet(deleted, (Collection[])new Collection[]{requiredParents}).isEmpty()) {
            throw new StorageException("Did not perform rollback as this would lead to missing parent commits.");
        }
        List deleteKeys = CollectionUtils.map(deleted, CommitDescriptor::toBranchTimestampKey);
        this.store.remove(deleteKeys);
    }

    private void rollbackPrecommitBranch(String branchName) throws StorageException {
        ArrayList toDelete = new ArrayList();
        byte[] prefix = Objects.requireNonNull(StringUtils.stringToBytes((String)branchName));
        int expectedLength = prefix.length + 8;
        this.store.scanKeys(prefix, (key, value) -> {
            if (key.length == expectedLength) {
                List list = toDelete;
                synchronized (list) {
                    toDelete.add(key);
                }
            }
        });
        if (!toDelete.isEmpty()) {
            this.store.remove(toDelete);
        }
    }

    public class CommitHistoryScanner {
        private final PriorityQueue<CommitDescriptor> unresolvedCommits = new PriorityQueue((commit1, commit2) -> -commit1.compareTo(commit2));
        private final HashSet<CommitDescriptor> encounteredCommits = new HashSet();
        private final HashMap<CommitDescriptor, byte[]> commitCache = new HashMap();
        private final CommitDescriptor latestCommitToConsider;
        private long lowerTimestampBoundary;
        private boolean foundFirstCommit = false;

        private CommitHistoryScanner(CommitDescriptor latestCommitToConsider) {
            this.latestCommitToConsider = latestCommitToConsider;
            this.lowerTimestampBoundary = latestCommitToConsider.getTimestamp();
        }

        public void scanTimeRange(long timeRange, Consumer<ParentedCommitDescriptor> commitDescriptorConsumer) throws StorageException {
            CCSMAssert.isTrue((timeRange >= 0L ? 1 : 0) != 0, (String)"Can't scan negative time range.");
            this.scanStartTimestamp(Math.max(0L, this.lowerTimestampBoundary - timeRange), commitDescriptorConsumer);
        }

        public void scanStartTimestamp(long lowerTimestampBoundary, Consumer<ParentedCommitDescriptor> commitDescriptorConsumer) throws StorageException {
            CCSMAssert.isTrue((this.lowerTimestampBoundary >= lowerTimestampBoundary ? 1 : 0) != 0, (String)"Can't scan into the future");
            this.lowerTimestampBoundary = lowerTimestampBoundary;
            this.loadFirstCommitIfNeeded();
            CommitDescriptor unresolvedCommit = this.unresolvedCommits.peek();
            while (unresolvedCommit != null && unresolvedCommit.getTimestamp() > this.lowerTimestampBoundary) {
                ParentedCommitDescriptor resolvedCommit = this.getParentedCommit(unresolvedCommit);
                CCSMAssert.isNotNull((Object)resolvedCommit, (String)"Inconsistent commit cache or commit index encountered while collecting commit history.");
                commitDescriptorConsumer.accept(resolvedCommit);
                HashSet newCommits = CollectionUtils.differenceSet((Collection)resolvedCommit.getParentCommits(), (Collection[])new Collection[]{this.encounteredCommits});
                this.unresolvedCommits.addAll(newCommits);
                this.encounteredCommits.addAll(newCommits);
                this.unresolvedCommits.poll();
                unresolvedCommit = this.unresolvedCommits.peek();
            }
        }

        private void loadFirstCommitIfNeeded() throws StorageException {
            if (this.foundFirstCommit) {
                return;
            }
            Optional<CommitDescriptor> firstCommitInHistory = CommitDescriptorIndex.this.getFirstActualCommitBeforeOrAt(this.latestCommitToConsider, this.lowerTimestampBoundary);
            this.foundFirstCommit = firstCommitInHistory.isPresent();
            firstCommitInHistory.ifPresent(this.unresolvedCommits::add);
            firstCommitInHistory.ifPresent(this.encounteredCommits::add);
        }

        public long getLowerTimestampBoundary() {
            return this.lowerTimestampBoundary;
        }

        private ParentedCommitDescriptor getParentedCommit(CommitDescriptor commitWithoutParents) throws StorageException {
            if (!this.commitCache.containsKey(commitWithoutParents)) {
                CommitDescriptorIndex.this.loadAllCommitsOnBranchIntoCache(commitWithoutParents, this.lowerTimestampBoundary, this.commitCache);
            }
            return (ParentedCommitDescriptor)StorageUtils.deserialize((byte[])this.commitCache.get(commitWithoutParents));
        }
    }
}

