/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.core.metrics.values.MetricValueBase;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class CounterSetMetricValue
extends MetricValueBase<CounterSet<String>> {
    private static final long serialVersionUID = 1L;

    @JsonCreator
    public CounterSetMetricValue(@JsonProperty(value="schemaEntry") MetricDirectorySchemaEntry schemaEntry, @JsonProperty(value="value") CounterSet<String> value) {
        super(schemaEntry, value);
    }

    @Override
    public EMetricValueType getValueType() {
        return EMetricValueType.COUNTER_SET;
    }

    @Override
    protected double getPresentValueAsDouble(ETrafficLightColor color) {
        throw new UnsupportedOperationException("Counter set metrics cannot be aggregated to a single double value.");
    }

    @Override
    protected @Nullable MetricValueBase<CounterSet<String>> computeDelta(MetricValueBase<CounterSet<String>> baseValue) {
        return new CounterSetMetricValue(this.getSchemaEntry(), (CounterSet<String>)CounterSet.fromMap((Map)CollectionUtils.merge((Map)((CounterSet)this.getOrDefault()).toMap(), (Map)baseValue.getOrDefault().toMap(), CounterSetMetricValue::computeSingleEntryDelta)));
    }

    private static int computeSingleEntryDelta(@Nullable Integer head, @Nullable Integer base) {
        return Objects.requireNonNullElse(head, 0) - Objects.requireNonNullElse(base, 0);
    }
}

