/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.migrators.DashboardMigratorBase;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion115Dashboards
extends DashboardMigratorBase {
    private static final String OLD_FIELD_NAME = "Spec Item findings only";
    private static final String NEW_FIELD_NAME = "Findings Type";

    @Override
    public String migrateDescriptorJSON(String descriptorJSON) throws MigrationException {
        return new DashboardMigratorBase.SafeJsonWidgetMigrator(MigrateVersion115Dashboards::migratePathsParameter).migrate(descriptorJSON);
    }

    private static ObjectNode migratePathsParameter(ObjectNode widget) {
        if (!widget.has(OLD_FIELD_NAME)) {
            return widget;
        }
        boolean oldSpecItemFindingsOnlyValue = widget.get(OLD_FIELD_NAME).booleanValue();
        String newFindingsTypeValue = "Code Findings";
        if (oldSpecItemFindingsOnlyValue) {
            newFindingsTypeValue = "Spec Item Findings";
        }
        widget.set(NEW_FIELD_NAME, (JsonNode)JsonNodeFactory.instance.textNode(newFindingsTypeValue));
        widget.remove(OLD_FIELD_NAME);
        return widget;
    }

    @Override
    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V115;
    }
}

