/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.permissions;

import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.permissions.PermissionLookup;
import com.teamscale.core.permissions.PermissionUtils;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EBasicRole;
import jakarta.ws.rs.ForbiddenException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

class BasicPermissions {
    private final Map<EBasicPermissionScope, Set<EBasicPermission>> globalBasicPermissionsByScope = new HashMap<EBasicPermissionScope, Set<EBasicPermission>>();
    private final Map<EBasicPermissionScope, Map<String, Set<EBasicPermission>>> basicPermissionsByScopeAndInstance = new HashMap<EBasicPermissionScope, Map<String, Set<EBasicPermission>>>();

    BasicPermissions() {
    }

    void addGlobalBasicPermission(EBasicPermissionScope permissionScope, EBasicRole role) {
        this.addGlobalBasicPermissions(permissionScope, role.getPermissions());
    }

    void addGlobalBasicPermissions(EBasicPermissionScope permissionScope, Set<EBasicPermission> permissions) {
        this.globalBasicPermissionsByScope.computeIfAbsent(permissionScope, key -> new HashSet()).addAll(permissions);
    }

    void addBasicPermission(EBasicPermissionScope permissionScope, String instanceId, EBasicRole role) {
        PermissionUtils.getNestedSetSafe(this.basicPermissionsByScopeAndInstance, permissionScope, instanceId).addAll(role.getPermissions());
    }

    void addBasicPermission(EBasicPermissionScope permissionScope, String instanceId, EBasicPermission permission) {
        PermissionUtils.getNestedSetSafe(this.basicPermissionsByScopeAndInstance, permissionScope, instanceId).add(permission);
    }

    boolean hasAnyBasicPermission(EBasicPermissionScope permissionScope, EBasicPermission permission) {
        return this.getGlobalBasicPermissions(permissionScope).contains(permission) || this.basicPermissionsByScopeAndInstance.getOrDefault((Object)permissionScope, (Map<String, Set<EBasicPermission>>)CollectionUtils.emptyMap()).values().stream().anyMatch(permissions -> permissions.contains(permission));
    }

    boolean currentUserHasViewPermissionOnUsersOtherThanHimself() {
        if (this.getGlobalBasicPermissions(EBasicPermissionScope.USERS).contains(EBasicPermission.VIEW)) {
            return true;
        }
        Map<String, Set<EBasicPermission>> permissionsOnUsers = this.basicPermissionsByScopeAndInstance.getOrDefault((Object)EBasicPermissionScope.USERS, (Map<String, Set<EBasicPermission>>)CollectionUtils.emptyMap());
        HashSet<String> users = new HashSet<String>(permissionsOnUsers.keySet());
        return users.stream().anyMatch(user -> ((Set)permissionsOnUsers.get(user)).contains(EBasicPermission.VIEW));
    }

    private static String getPermissionMissingMessage(EBasicPermissionScope permissionScope, EBasicPermission basicPermission) {
        return "The current user doesn't have the permission '" + basicPermission.readableName + "' on " + permissionScope.readableName;
    }

    public void checkBasicPermission(EBasicPermissionScope permissionScope, String instanceId, EBasicPermission basicPermission) throws ForbiddenException {
        if (!this.hasBasicPermission(permissionScope, instanceId, basicPermission)) {
            String message = BasicPermissions.getPermissionMissingMessage(permissionScope, basicPermission) + ": " + instanceId;
            AuditLogs.failedBasicPermissionCheck(basicPermission, message);
            throw new ForbiddenException(message);
        }
    }

    void checkBasicPermissionForAll(EBasicPermissionScope permissionScope, Collection<String> instanceIds, EBasicPermission basicPermission) {
        PermissionLookup<EBasicPermission> permissionLookup = this.getBasicPermissionLookup(permissionScope);
        HashSet<String> unpermittedInstanceIds = new HashSet<String>();
        for (String group : instanceIds) {
            if (permissionLookup.hasPermission(group, EBasicPermission.EDIT)) continue;
            unpermittedInstanceIds.add(group);
        }
        if (!unpermittedInstanceIds.isEmpty()) {
            String message = BasicPermissions.getPermissionMissingMessage(permissionScope, basicPermission) + "s: " + String.valueOf(unpermittedInstanceIds);
            AuditLogs.failedBasicPermissionCheck(basicPermission, message);
            throw new ForbiddenException(message);
        }
    }

    Set<EBasicPermission> getGlobalBasicPermissions(EBasicPermissionScope permissionScope) {
        return Optional.ofNullable(this.globalBasicPermissionsByScope.get((Object)permissionScope)).orElse((Set<EBasicPermission>)CollectionUtils.emptySet());
    }

    PermissionLookup<EBasicPermission> getBasicPermissionLookup(EBasicPermissionScope permissionScope) {
        return new PermissionLookup<EBasicPermission>(this.getGlobalBasicPermissions(permissionScope), this.basicPermissionsByScopeAndInstance.getOrDefault((Object)permissionScope, (Map<String, Set<EBasicPermission>>)CollectionUtils.emptyMap()));
    }

    boolean hasBasicPermission(EBasicPermissionScope permissionScope, String instanceId, EBasicPermission permission) {
        return this.getBasicPermissions(permissionScope, instanceId).contains(permission);
    }

    private Set<EBasicPermission> getBasicPermissions(EBasicPermissionScope permissionsScope, String instanceId) {
        HashSet<EBasicPermission> result = new HashSet<EBasicPermission>();
        result.addAll(this.getGlobalBasicPermissions(permissionsScope));
        result.addAll((Collection)Optional.ofNullable(this.basicPermissionsByScopeAndInstance.getOrDefault((Object)permissionsScope, (Map<String, Set<EBasicPermission>>)CollectionUtils.emptyMap()).get(instanceId)).orElse((Set<EBasicPermission>)CollectionUtils.emptySet()));
        return result;
    }
}

