/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis.step;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.IDeltaTranslatingIndex;
import com.teamscale.core.analysis.IIndexDelta;
import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepFieldAccessorBase;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class AnalysisStepDeltaSource
extends AnalysisStepFieldAccessorBase {
    private final String indexName;
    private final Class<? extends IStorageIndex> indexClass;

    AnalysisStepDeltaSource(Field field, List<Field> fieldStack, DeltaSource deltaSource) throws TriggerCompilationException {
        super(field, fieldStack);
        AnalysisStepDeltaSource.checkType(field, deltaSource.value());
        this.indexName = StringUtils.isEmpty((String)deltaSource.indexName()) ? AnalysisStepDeltaSource.resolveIndexNameFromIndexClass(deltaSource.value(), field) : deltaSource.indexName();
        this.indexClass = deltaSource.value();
    }

    @VisibleForTesting
    static void checkType(Field field, Class<? extends IStorageIndex> indexType) throws TriggerCompilationException {
        Type expectedType = IDeltaTranslatingIndex.getDeltaType(indexType);
        if (!TypeUtils.isAssignable((Type)expectedType, (Type)field.getGenericType())) {
            throw new TriggerCompilationException("Field " + String.valueOf(field) + " is annotated with " + DeltaSource.class.getSimpleName() + " and thus should be assignable to " + String.valueOf(expectedType));
        }
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Class<? extends IStorageIndex> getIndexClass() {
        return this.indexClass;
    }

    @Override
    protected String getToStringPrefix() {
        return "delta source: " + this.getIndexName();
    }

    public void setDelta(AnalysisStepBase instance, IIndexDelta delta) {
        this.set(instance, delta);
    }
}

