/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.application.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeWithMe.ClientId;
import org.jetbrains.kotlin.com.intellij.diagnostic.EventWatcher;
import org.jetbrains.kotlin.com.intellij.openapi.application.AccessToken;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityState;
import org.jetbrains.kotlin.com.intellij.openapi.application.impl.LaterInvocator;
import org.jetbrains.kotlin.com.intellij.openapi.application.impl.ModalityStateEx;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.util.ActionCallback;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;

final class FlushQueue {
    private static final Logger LOG = Logger.getInstance(LaterInvocator.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private final Object LOCK;
    private final List<RunnableInfo> mySkippedItems;
    private final ArrayDeque<RunnableInfo> myQueue;
    @NotNull
    private final Consumer<? super Runnable> myRunnableExecutor;
    private volatile boolean myMayHaveItems;
    private RunnableInfo myLastInfo;

    FlushQueue(@NotNull Consumer<? super Runnable> executor) {
        if (executor == null) {
            FlushQueue.$$$reportNull$$$0(0);
        }
        this.LOCK = new Object();
        this.mySkippedItems = new ArrayList<RunnableInfo>();
        this.myQueue = new ArrayDeque();
        this.myRunnableExecutor = executor;
    }

    public void scheduleFlush() {
        this.myRunnableExecutor.accept(new FlushNow());
    }

    public void flushNow() {
        LaterInvocator.FLUSHER_SCHEDULED.set(false);
        this.myMayHaveItems = false;
        long startTime = System.currentTimeMillis();
        while (this.runNextEvent()) {
            if (System.currentTimeMillis() - startTime <= 5L) continue;
            this.myMayHaveItems = true;
            break;
        }
        LaterInvocator.requestFlush();
    }

    boolean mayHaveItems() {
        return this.myMayHaveItems;
    }

    private static void doRun(@Async.Execute @NotNull RunnableInfo info) {
        if (info == null) {
            FlushQueue.$$$reportNull$$$0(3);
        }
        try (AccessToken ignored = ClientId.withClientId(info.clientId);){
            info.runnable.run();
        }
    }

    public String toString() {
        return "LaterInvocator.FlushQueue" + (this.myLastInfo == null ? "" : " lastInfo=" + this.myLastInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    RunnableInfo getNextEvent(boolean remove) {
        Object object = this.LOCK;
        synchronized (object) {
            ModalityStateEx currentModality = LaterInvocator.getCurrentModalityState();
            while (!this.myQueue.isEmpty()) {
                RunnableInfo info = this.myQueue.getFirst();
                if (info.expired.value(null)) {
                    this.myQueue.removeFirst();
                    info.markDone();
                    continue;
                }
                if (!((ModalityState)currentModality).dominates(info.modalityState)) {
                    if (remove) {
                        this.myQueue.removeFirst();
                    }
                    return info;
                }
                this.mySkippedItems.add(this.myQueue.removeFirst());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runNextEvent() {
        RunnableInfo lastInfo;
        long startedAt = System.currentTimeMillis();
        this.myLastInfo = lastInfo = this.getNextEvent(true);
        if (lastInfo != null) {
            EventWatcher watcher = EventWatcher.getInstanceOrNull();
            Runnable runnable = lastInfo.runnable;
            if (watcher != null) {
                watcher.runnableStarted(runnable, startedAt);
            }
            try {
                FlushQueue.doRun(lastInfo);
                lastInfo.markDone();
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable t) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    ExceptionUtil.rethrow(t);
                }
                LOG.error(t);
            }
            finally {
                if (!DEBUG) {
                    this.myLastInfo = null;
                }
                if (watcher != null) {
                    watcher.runnableFinished(runnable, System.currentTimeMillis());
                }
            }
        }
        return lastInfo != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reincludeSkippedItems() {
        Object object = this.LOCK;
        synchronized (object) {
            for (int i = this.mySkippedItems.size() - 1; i >= 0; --i) {
                RunnableInfo item = this.mySkippedItems.get(i);
                this.myQueue.addFirst(item);
                this.myMayHaveItems = true;
            }
            this.mySkippedItems.clear();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnableInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/application/impl/FlushQueue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/application/impl/FlushQueue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class RunnableInfo {
        @NotNull
        private final Runnable runnable;
        @NotNull
        private final ModalityState modalityState;
        @NotNull
        private final Condition<?> expired;
        @Nullable
        private final ActionCallback callback;
        @Nullable
        private final ClientId clientId;

        void markDone() {
            if (this.callback != null) {
                this.callback.setDone();
            }
        }

        @NonNls
        public String toString() {
            return "[runnable: " + this.runnable + "; state=" + this.modalityState + (this.expired.value(null) ? "; expired" : "") + "] ";
        }
    }

    final class FlushNow
    implements Runnable {
        FlushNow() {
        }

        @Override
        public void run() {
            FlushQueue.this.flushNow();
        }
    }
}

