/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.ClearTextProtocolCheckKt;
import org.sonarsource.kotlin.checks.OkHttpArgumentFinder;

@Rule(key="S5332")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J,\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\r2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lorg/sonarsource/kotlin/checks/ClearTextProtocolCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/Set;", "analyzeOkHttpCall", "", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "callExpr", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "checkAndroidMixedContentArgument", "ctx", "argument", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitBinaryExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitFunctionCall", "callExpression", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "matchedFun", "sonar-kotlin-checks"})
public final class ClearTextProtocolCheck
extends CallAbstractCheck {
    @NotNull
    private final Set<FunMatcherImpl> functionsToVisit = SetsKt.plus(SetsKt.plus(ClearTextProtocolCheckKt.access$getUNSAFE_CALLS_GENERAL$p().keySet(), ClearTextProtocolCheckKt.access$getUNSAFE_CALLS_OK_HTTP$p()), (Iterable)CollectionsKt.listOf(ClearTextProtocolCheckKt.access$getANDROID_SET_MIXED_CONTENT_MODE$p()));

    @NotNull
    public Set<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull ResolvedCall<?> resolvedCall2, @NotNull FunMatcherImpl matchedFun, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(matchedFun, "matchedFun");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        String string2 = (String)ClearTextProtocolCheckKt.access$getUNSAFE_CALLS_GENERAL$p().get(matchedFun);
        if (string2 != null) {
            String msg2 = string2;
            boolean bl = false;
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)callExpression, msg2, null, null, 12, null);
            return;
        }
        if (ClearTextProtocolCheckKt.access$getUNSAFE_CALLS_OK_HTTP$p().contains(matchedFun)) {
            this.analyzeOkHttpCall(kotlinFileContext, callExpression);
        } else if (Intrinsics.areEqual(matchedFun, ClearTextProtocolCheckKt.access$getANDROID_SET_MIXED_CONTENT_MODE$p())) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = CallUtilKt.getResolvedCall(callExpression, kotlinFileContext.getBindingContext());
            this.checkAndroidMixedContentArgument(kotlinFileContext, KtPsiUtil.deparenthesize(resolvedCall3 != null ? CallUtilKt.getFirstArgumentExpression(resolvedCall3) : null));
        }
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2, @NotNull KotlinFileContext ctx) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        KtExpression ktExpression = KtPsiUtil.deparenthesize(expression2.getLeft());
        if (ktExpression == null) {
            return;
        }
        KtExpression left = ktExpression;
        if (Intrinsics.areEqual(expression2.getOperationToken(), KtTokens.EQ) && ApiExtensionsKt.setterMatches(left, ctx.getBindingContext(), "mixedContentMode", ClearTextProtocolCheckKt.access$getANDROID_SET_MIXED_CONTENT_MODE$p())) {
            this.checkAndroidMixedContentArgument(ctx, KtPsiUtil.deparenthesize(expression2.getRight()));
        }
    }

    private final void checkAndroidMixedContentArgument(KotlinFileContext ctx, KtExpression argument) {
        if (argument != null) {
            Integer n = ApiExtensionsKt.predictRuntimeIntValue(argument, ctx.getBindingContext());
            if (n != null && n == 0) {
                AbstractCheck.reportIssue$default((AbstractCheck)this, ctx, (PsiElement)argument, "Using a relaxed mixed content policy is security-sensitive.", null, null, 12, null);
            }
        }
    }

    private final void analyzeOkHttpCall(KotlinFileContext kotlinFileContext, KtCallExpression callExpr) {
        new OkHttpArgumentFinder(kotlinFileContext.getBindingContext(), (Function1<? super KtSimpleNameExpression, Unit>)new Function1<KtSimpleNameExpression, Unit>(this, kotlinFileContext){
            final /* synthetic */ ClearTextProtocolCheck this$0;
            final /* synthetic */ KotlinFileContext $kotlinFileContext;
            {
                this.this$0 = $receiver;
                this.$kotlinFileContext = $kotlinFileContext;
                super(1);
            }

            public final void invoke(@NotNull KtSimpleNameExpression arg) {
                Intrinsics.checkNotNullParameter(arg, "arg");
                AbstractCheck.reportIssue$default((AbstractCheck)this.this$0, this.$kotlinFileContext, (PsiElement)arg, ClearTextProtocolCheckKt.access$msg("HTTP", "HTTPS"), null, null, 12, null);
            }
        }).visitTree(callExpr);
    }
}

