/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.checks.CognitiveComplexity;

@Rule(key="S3776")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/sonarsource/kotlin/checks/FunctionCognitiveComplexityCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "()V", "threshold", "", "getThreshold", "()I", "setThreshold", "(I)V", "secondaryLocation", "Lorg/sonarsource/kotlin/api/reporting/SecondaryLocation;", "increment", "Lorg/sonarsource/kotlin/checks/CognitiveComplexity$Increment;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Companion", "sonar-kotlin-checks"})
public final class FunctionCognitiveComplexityCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="threshold", description="The maximum authorized complexity.", defaultValue="15")
    private int threshold = 15;
    private static final int DEFAULT_THRESHOLD = 15;

    public final int getThreshold() {
        return this.threshold;
    }

    public final void setThreshold(int n) {
        this.threshold = n;
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(context, "context");
        PsiElement psiElement = function2.getNameIdentifier();
        if (psiElement == null) {
            return;
        }
        PsiElement nameIdentifier = psiElement;
        CognitiveComplexity complexity = new CognitiveComplexity(function2);
        int value2 = complexity.value();
        if (value2 > this.threshold) {
            String string2 = "Refactor this method to reduce its Cognitive Complexity from " + value2 + " to the " + this.threshold + " allowed.";
            List<SecondaryLocation> list2 = complexity.increments().stream().map(arg_0 -> FunctionCognitiveComplexityCheck.visitNamedFunction$lambda$0(new Function1<CognitiveComplexity.Increment, SecondaryLocation>(this, context){
                final /* synthetic */ FunctionCognitiveComplexityCheck this$0;
                final /* synthetic */ KotlinFileContext $context;
                {
                    this.this$0 = $receiver;
                    this.$context = $context;
                    super(1);
                }

                public final SecondaryLocation invoke(@NotNull CognitiveComplexity.Increment increment) {
                    Intrinsics.checkNotNullParameter(increment, "increment");
                    return FunctionCognitiveComplexityCheck.access$secondaryLocation(this.this$0, increment, this.$context);
                }
            }, arg_0)).collect(Collectors.toList());
            Intrinsics.checkNotNullExpressionValue(list2, "collect(...)");
            this.reportIssue(context, nameIdentifier, string2, list2, (Double)((double)value2 - (double)this.threshold));
        }
    }

    private final SecondaryLocation secondaryLocation(CognitiveComplexity.Increment increment, KotlinFileContext context) {
        int nestingLevel = increment.getNestingLevel();
        String message2 = "+" + (nestingLevel + 1);
        if (nestingLevel > 0) {
            message2 = message2 + " (incl " + nestingLevel + " for nesting)";
        }
        TextRange textRange2 = KotlinTextRanges.INSTANCE.textRange(context, increment.getToken());
        return new SecondaryLocation(textRange2, message2);
    }

    private static final SecondaryLocation visitNamedFunction$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (SecondaryLocation)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ SecondaryLocation access$secondaryLocation(FunctionCognitiveComplexityCheck $this, CognitiveComplexity.Increment increment, KotlinFileContext context) {
        return $this.secondaryLocation(increment, context);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/sonarsource/kotlin/checks/FunctionCognitiveComplexityCheck$Companion;", "", "()V", "DEFAULT_THRESHOLD", "", "sonar-kotlin-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

