/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.Date;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ReplicationBacklogLDAPConnectionPoolHealthCheck
extends LDAPConnectionPoolHealthCheck
implements Serializable {
    private static final long DEFAULT_MAX_RESPONSE_TIME_MILLIS = 5000L;
    @NotNull
    private static final String BASE_DN_ATTRIBUTE_NAME = "base-dn";
    @NotNull
    private static final String BACKLOG_COUNT_ATTRIBUTE_NAME = "replication-backlog";
    @NotNull
    private static final String OLDEST_BACKLOG_CHANGE_TIME_ATTRIBUTE_NAME = "age-of-oldest-backlog-change";
    @NotNull
    private static final String REPLICA_MONITOR_ENTRY_OBJECT_CLASS_NAME = "ds-replica-monitor-entry";
    private static final long serialVersionUID = -2201740505566813382L;
    private final boolean invokeAfterAuthentication;
    private final boolean invokeForBackgroundChecks;
    private final boolean invokeOnCheckout;
    private final boolean invokeOnCreate;
    private final boolean invokeOnException;
    private final boolean invokeOnRelease;
    @Nullable
    private final Long maxAllowedBacklogAgeMillis;
    @Nullable
    private final Long maxAllowedBacklogCount;
    private final long maxResponseTimeMillis;
    @NotNull
    private final SearchRequest searchRequest;
    @NotNull
    private final String baseDN;

    public ReplicationBacklogLDAPConnectionPoolHealthCheck(boolean invokeOnCreate, boolean invokeAfterAuthentication, boolean invokeOnCheckout, boolean invokeOnRelease, boolean invokeForBackgroundChecks, boolean invokeOnException, long maxResponseTimeMillis, @NotNull String baseDN, @Nullable Long maxAllowedBacklogCount, @Nullable Long maxAllowedBacklogAgeMillis) {
        Validator.ensureNotNullWithMessage(baseDN, "ReplicationBacklogLDAPConnectionPoolHealthCheck.baseDN must not be null.");
        if (maxAllowedBacklogCount == null) {
            if (maxAllowedBacklogAgeMillis == null) {
                Validator.violation("At least one of maxAllowedBacklogCount or maxAllowedBacklogAgeMillis must be non-null for the ReplicationBacklogLDAPConnectionPoolHealthCheck");
            }
        } else {
            Validator.ensureTrue(maxAllowedBacklogCount > 0L, "If specified, ReplicationBacklogLDAPConnectionPoolHealthCheck.maxAllowedBacklogCount must be greater than zero.");
        }
        if (maxAllowedBacklogAgeMillis != null) {
            Validator.ensureTrue(maxAllowedBacklogAgeMillis > 0L, "If specified, ReplicationBacklogLDAPConnectionPoolHealthCheck.maxAllowedBacklogAgeMillis must be greater than zero.");
        }
        this.invokeOnCreate = invokeOnCreate;
        this.invokeAfterAuthentication = invokeAfterAuthentication;
        this.invokeOnCheckout = invokeOnCheckout;
        this.invokeOnRelease = invokeOnRelease;
        this.invokeForBackgroundChecks = invokeForBackgroundChecks;
        this.invokeOnException = invokeOnException;
        this.baseDN = baseDN;
        this.maxAllowedBacklogCount = maxAllowedBacklogCount;
        this.maxAllowedBacklogAgeMillis = maxAllowedBacklogAgeMillis;
        this.maxResponseTimeMillis = maxResponseTimeMillis > 0L ? maxResponseTimeMillis : 5000L;
        int timeLimitSeconds = (int)(this.maxResponseTimeMillis / 1000L);
        if (this.maxResponseTimeMillis % 1000L != 0L) {
            ++timeLimitSeconds;
        }
        Filter filter = Filter.createANDFilter(Filter.createEqualityFilter("objectClass", REPLICA_MONITOR_ENTRY_OBJECT_CLASS_NAME), Filter.createEqualityFilter(BASE_DN_ATTRIBUTE_NAME, baseDN));
        this.searchRequest = new SearchRequest("cn=monitor", SearchScope.SUB, DereferencePolicy.NEVER, 1, timeLimitSeconds, false, filter, BACKLOG_COUNT_ATTRIBUTE_NAME, OLDEST_BACKLOG_CHANGE_TIME_ATTRIBUTE_NAME);
        this.searchRequest.setResponseTimeoutMillis(this.maxResponseTimeMillis);
    }

    @Override
    public void ensureNewConnectionValid(@NotNull LDAPConnection connection) throws LDAPException {
        if (this.invokeOnCreate) {
            this.checkReplicationBacklog(connection);
        }
    }

    @Override
    public void ensureConnectionValidAfterAuthentication(@NotNull LDAPConnection connection, @NotNull BindResult bindResult) throws LDAPException {
        if (this.invokeAfterAuthentication && bindResult.getResultCode() == ResultCode.SUCCESS) {
            this.checkReplicationBacklog(connection);
        }
    }

    @Override
    public void ensureConnectionValidForCheckout(@NotNull LDAPConnection connection) throws LDAPException {
        if (this.invokeOnCheckout) {
            this.checkReplicationBacklog(connection);
        }
    }

    @Override
    public void ensureConnectionValidForRelease(@NotNull LDAPConnection connection) throws LDAPException {
        if (this.invokeOnRelease) {
            this.checkReplicationBacklog(connection);
        }
    }

    @Override
    public void ensureConnectionValidForContinuedUse(@NotNull LDAPConnection connection) throws LDAPException {
        if (this.invokeForBackgroundChecks) {
            this.checkReplicationBacklog(connection);
        }
    }

    @Override
    public void ensureConnectionValidAfterException(@NotNull LDAPConnection connection, @NotNull LDAPException exception) throws LDAPException {
        if (this.invokeOnException && !ResultCode.isConnectionUsable(exception.getResultCode())) {
            this.checkReplicationBacklog(connection);
        }
    }

    public boolean invokeOnCreate() {
        return this.invokeOnCreate;
    }

    public boolean invokeAfterAuthentication() {
        return this.invokeAfterAuthentication;
    }

    public boolean invokeOnCheckout() {
        return this.invokeOnCheckout;
    }

    public boolean invokeOnRelease() {
        return this.invokeOnRelease;
    }

    public boolean invokeForBackgroundChecks() {
        return this.invokeForBackgroundChecks;
    }

    public boolean invokeOnException() {
        return this.invokeOnException;
    }

    public long getMaxResponseTimeMillis() {
        return this.maxResponseTimeMillis;
    }

    @NotNull
    public String getBaseDN() {
        return this.baseDN;
    }

    @Nullable
    public Long getMaxAllowedBacklogCount() {
        return this.maxAllowedBacklogCount;
    }

    @Nullable
    public Long getMaxAllowedBacklogAgeMillis() {
        return this.maxAllowedBacklogAgeMillis;
    }

    private void checkReplicationBacklog(@NotNull LDAPConnection conn) throws LDAPException {
        long oldestChangeAgeMillis;
        Date oldestChangeDate;
        Long currentBacklogCount;
        SearchResultEntry monitorEntry;
        try {
            monitorEntry = conn.searchForEntry(this.searchRequest.duplicate());
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            String message = UnboundIDDSMessages.ERR_REPLICATION_BACKLOG_HEALTH_CHECK_ERROR_GETTING_MONITOR_ENTRY.get(this.baseDN, conn.getHostPort(), StaticUtils.getExceptionMessage(e));
            conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, message, e);
            throw new LDAPException(e.getResultCode(), message, e);
        }
        if (monitorEntry == null) {
            return;
        }
        if (this.maxAllowedBacklogCount != null && (currentBacklogCount = monitorEntry.getAttributeValueAsLong(BACKLOG_COUNT_ATTRIBUTE_NAME)) != null && currentBacklogCount > this.maxAllowedBacklogCount) {
            String message = UnboundIDDSMessages.ERR_REPLICATION_BACKLOG_HEALTH_CHECK_COUNT_EXCEEDED.get(currentBacklogCount, this.baseDN, conn.getHostPort(), this.maxAllowedBacklogCount);
            conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, message, null);
            throw new LDAPException(ResultCode.UNAVAILABLE, message);
        }
        if (this.maxAllowedBacklogAgeMillis != null && (oldestChangeDate = monitorEntry.getAttributeValueAsDate(OLDEST_BACKLOG_CHANGE_TIME_ATTRIBUTE_NAME)) != null && (oldestChangeAgeMillis = System.currentTimeMillis() - oldestChangeDate.getTime()) > this.maxAllowedBacklogAgeMillis) {
            String message = UnboundIDDSMessages.ERR_REPLICATION_BACKLOG_HEALTH_CHECK_AGE_EXCEEDED.get(this.baseDN, conn.getHostPort(), StaticUtils.millisToHumanReadableDuration(oldestChangeAgeMillis), StaticUtils.millisToHumanReadableDuration(this.maxAllowedBacklogAgeMillis));
            conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, message, null);
            throw new LDAPException(ResultCode.UNAVAILABLE, message);
        }
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ReplicationBacklogLDAPConnectionPoolHealthCheck(");
        buffer.append("invokeOnCreate=");
        buffer.append(this.invokeOnCreate);
        buffer.append(", invokeAfterAuthentication=");
        buffer.append(this.invokeAfterAuthentication);
        buffer.append(", invokeOnCheckout=");
        buffer.append(this.invokeOnCheckout);
        buffer.append(", invokeOnRelease=");
        buffer.append(this.invokeOnRelease);
        buffer.append(", invokeForBackgroundChecks=");
        buffer.append(this.invokeForBackgroundChecks);
        buffer.append(", invokeOnException=");
        buffer.append(this.invokeOnException);
        buffer.append(", maxResponseTimeMillis=");
        buffer.append(this.maxResponseTimeMillis);
        buffer.append(", baseDN='");
        buffer.append(this.baseDN);
        buffer.append('\'');
        if (this.maxAllowedBacklogCount != null) {
            buffer.append(", maxAllowedBacklogCount=");
            buffer.append(this.maxAllowedBacklogCount);
        }
        if (this.maxAllowedBacklogAgeMillis != null) {
            buffer.append(", maxAllowedBacklogAgeMillis=");
            buffer.append(this.maxAllowedBacklogAgeMillis);
        }
        buffer.append(')');
    }
}

