/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.ui.base;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.service.project.ProjectsState;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.collections.CollectionUtils;

public class PerspectiveContextProjectInfos {
    private static final String PROJECTS_PROPERTY = "projects";
    private static final String PROJECTS_INFO_PROPERTY = "projectsInfo";
    private static final String INITIAL_PROJECTS_PROPERTY = "initialProjects";
    private static final String RECENT_PROJECTS_PROPERTY = "recentProjects";
    @JsonProperty(value="projects")
    public final List<PublicProjectId> projects;
    @JsonProperty(value="projectsInfo")
    public final List<ProjectInfo> projectInfos;
    @JsonProperty(value="initialProjects")
    public final List<PublicProjectId> initialProjects;
    @JsonProperty(value="recentProjects")
    public final List<ProjectInfo> recentProjects;

    public PerspectiveContextProjectInfos(List<ProjectInfo> projectInfos, ProjectsState projectsState, List<ProjectInfo> recentProjects) {
        this.projectInfos = CollectionUtils.map(projectInfos, PerspectiveContextProjectInfos::createProjectInfoWithoutDescription);
        this.recentProjects = CollectionUtils.map(recentProjects, PerspectiveContextProjectInfos::createProjectInfoWithoutDescription);
        this.projectInfos.sort(Comparator.comparing(projectInfo -> projectInfo.getName().toLowerCase()));
        this.projects = CollectionUtils.sort((Collection)projectsState.getProjects());
        this.initialProjects = projectsState.getInitialProjects();
    }

    @JsonCreator
    public PerspectiveContextProjectInfos(@JsonProperty(value="projects") List<PublicProjectId> projects, @JsonProperty(value="projectsInfo") List<ProjectInfo> projectInfos, @JsonProperty(value="initialProjects") List<PublicProjectId> initialProjects, @JsonProperty(value="recentProjects") List<ProjectInfo> recentProjects) {
        this.projects = projects;
        this.projectInfos = projectInfos;
        this.initialProjects = initialProjects;
        this.recentProjects = recentProjects;
    }

    private static ProjectInfo createProjectInfoWithoutDescription(ProjectInfo projectInfo) {
        if (projectInfo.getDescription() == null) {
            return projectInfo;
        }
        return new ProjectInfo(projectInfo.getInternalId(), projectInfo.getExternalStorageProjectMappingId(), projectInfo.getName(), (List)projectInfo.getPublicIds(), (InternalProjectId)projectInfo.getParentProjectId().orElse(null), null, projectInfo.getCreationTimestamp(), projectInfo.getPreselectedUIBranch());
    }
}

