/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.ui.commons;

import com.teamscale.commons.annotation.ClassIndexUtils;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.index.model.EThresholdEvaluationOption;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.Option;
import com.teamscale.core.user.UserIndex;
import com.teamscale.jsbuild.export.TsClassGeneratorBase;
import com.teamscale.jsbuild.export.TypeScriptImportStatement;
import com.teamscale.service.metrics.treemap.builder.ChangeTreeMapBuilder;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.color.ColorUtils;
import org.conqat.lib.commons.string.StringUtils;

public class CommonsClassesGenerator
extends TsClassGeneratorBase {
    private static final String JS_REGEX_CONSTANT_TEMPLATE = "export const %1$s = /%2$s/%3$s;\n";
    private static final String GENERATED_HEADER = "/**\n * This file has been generated. Do not edit! \n */\n\n";

    public CommonsClassesGenerator(File typedefsFolder) {
        super(typedefsFolder);
    }

    public void generateFiles() throws IOException {
        this.exposeStringConstants();
        this.exposeRegexConstants();
        this.exposeOptionsConstants(EOptionType.USER);
        this.exposeOptionsConstants(EOptionType.SERVER);
        this.exposeOptionsConstants(EOptionType.PROJECT);
    }

    private void exposeRegexConstants() throws IOException {
        String regexConstantsCodeBuilder = CommonsClassesGenerator.formatRegexConstant("PROJECT_ID_REGEX", PublicProjectId.PROJECT_ID_REGEX, false) + CommonsClassesGenerator.formatRegexConstant("PROJECT_ID_FORBIDDEN_CHARACTERS_REGEX", PublicProjectId.PROJECT_ID_FORBIDDEN_CHARACTERS_REGEX, true) + CommonsClassesGenerator.formatRegexConstant("USERNAME_FORBIDDEN_CHARACTERS_REGEX", UserIndex.USERNAME_FORBIDDEN_CHARACTERS_REGEX, true) + CommonsClassesGenerator.formatRegexConstant("RELATIVE_DATE_PATTERN", ConnectorUtils.RELATIVE_DATE_PATTERN, false);
        this.addGeneratedJavaScript("Regex", regexConstantsCodeBuilder);
    }

    private void exposeStringConstants() throws IOException {
        String constantsCodeBuilder = GENERATED_HEADER + CommonsClassesGenerator.formatStringConstant("ASSESSMENT_METRIC_RED_IF_ANY_THRESHOLD_VIOLATED", EThresholdEvaluationOption.ASSESSMENT_METRIC_RED_IF_ANY_THRESHOLD_VIOLATED.name()) + CommonsClassesGenerator.formatStringConstant("ADMINISTRATOR_GROUP_NAME", "Administrators") + CommonsClassesGenerator.formatStringConstant("INTERNAL_SNIPPET_ANALYSIS_FILE_PREFIX", "snippet-analysis-file") + CommonsClassesGenerator.formatStringConstant("ARCHITECTURE_FILES", "-architecture-files-") + CommonsClassesGenerator.formatStringConstant("DELETED_COLOR", ColorUtils.toHtmlString((Color)ChangeTreeMapBuilder.DELETED_COLOR));
        this.addGeneratedJavaScript("Constants", constantsCodeBuilder);
    }

    private void exposeOptionsConstants(EOptionType type) throws IOException {
        String className;
        String optionTypeTitleCase = StringUtils.toFirstUpper((String)type.name());
        List<Class<?>> options = CommonsClassesGenerator.getOptions(type);
        StringBuilder code = new StringBuilder();
        code.append("\n/** All known " + type.name().toLowerCase() + " options. */\nexport type " + optionTypeTitleCase + "Options = {\n");
        ArrayList<TypeScriptImportStatement> imports = new ArrayList<TypeScriptImportStatement>();
        StringBuilder multiOptionFields = new StringBuilder();
        for (Class<?> option : options) {
            className = option.getSimpleName();
            Option optionAnnotation = option.getAnnotation(Option.class);
            imports.add(new TypeScriptImportStatement("typedefs/" + className, className, true));
            if (optionAnnotation.multiOption()) {
                multiOptionFields.append("\t[key: `" + optionAnnotation.id() + "/${string}`]: " + className + ";\n");
                continue;
            }
            code.append("\t'" + optionAnnotation.id() + "': " + className + ";\n");
        }
        imports.forEach(importedModule -> code.insert(0, importedModule.toCode()));
        code.insert(0, GENERATED_HEADER);
        if (!multiOptionFields.isEmpty()) {
            code.append((CharSequence)multiOptionFields);
        }
        code.append("};\n\n");
        code.append("/** All known " + type.name().toLowerCase() + " option names. */\n");
        code.append("export enum E" + optionTypeTitleCase + "Options {\n");
        for (Class<?> userOption : options) {
            className = userOption.getSimpleName();
            Option option = userOption.getAnnotation(Option.class);
            String fieldName = StringUtils.camelCaseToUnderscored((String)StringUtils.stripSuffix((String)className, (String)"Option"));
            code.append("\t" + fieldName + " = '" + option.id() + "'");
            code.append(",\n");
        }
        code.deleteCharAt(code.length() - 2);
        code.append("}\n");
        this.addGeneratedJavaScript(optionTypeTitleCase + "Options", code.toString());
    }

    private static @NonNull List<Class<?>> getOptions(EOptionType type) {
        List optionClasses = ClassIndexUtils.getAnnotated(Option.class);
        return optionClasses.stream().filter(clazz -> clazz.getAnnotation(Option.class).type() == type).sorted(Comparator.comparing(Class::getSimpleName)).toList();
    }

    private static String formatStringConstant(String constantClassName, String value) {
        return "export const " + constantClassName + " = '" + value + "';\n";
    }

    private static String formatRegexConstant(String constantClassName, Pattern pattern, boolean globalMatch) {
        return String.format(JS_REGEX_CONSTANT_TEMPLATE, constantClassName, pattern.pattern(), CommonsClassesGenerator.determineJSRegexFlags(pattern, globalMatch));
    }

    private static String determineJSRegexFlags(Pattern pattern, boolean globalMatch) {
        StringBuilder flagBuilder = new StringBuilder();
        int flags = pattern.flags();
        if ((flags & 2) == 2) {
            flagBuilder.append('i');
        }
        if ((flags & 8) == 8) {
            flagBuilder.append('m');
        }
        if (globalMatch) {
            flagBuilder.append('g');
        }
        return flagBuilder.toString();
    }
}

