/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.engines;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.ResolutionOptions;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.GetEngine;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.events.NonFatalErrorEvent;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.MergeToolNotConfiguredException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.PreMergeFailedException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes.FileAttributeValues;
import com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes.FileAttributesCollection;
import com.microsoft.tfs.core.clients.versioncontrol.internal.fileattributes.StringPairFileAttribute;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ConflictType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.VersionedFileSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.ChangesetVersionSpec;
import com.microsoft.tfs.core.externaltools.ExternalTool;
import com.microsoft.tfs.core.externaltools.ExternalToolset;
import com.microsoft.tfs.core.externaltools.validators.ExternalToolException;
import com.microsoft.tfs.core.util.CodePageMapping;
import com.microsoft.tfs.core.util.FileEncoding;
import com.microsoft.tfs.core.util.diffmerge.ThreeWayMerge;
import com.microsoft.tfs.jni.helpers.FileCopyHelper;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.process.ProcessFinishedHandler;
import com.microsoft.tfs.util.process.ProcessRunner;
import com.microsoft.tfs.util.temp.TempStorageService;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MergeEngine {
    private static final Log log = LogFactory.getLog(MergeEngine.class);
    private final Workspace workspace;
    private final VersionControlClient client;
    private final ExternalToolset mergeToolset;

    public MergeEngine(Workspace workspace, VersionControlClient client) {
        this(workspace, client, null);
    }

    public MergeEngine(Workspace workspace, VersionControlClient client, ExternalToolset mergeToolset) {
        Check.notNull(workspace, "workspace");
        Check.notNull(client, "client");
        this.workspace = workspace;
        this.client = client;
        this.mergeToolset = mergeToolset;
    }

    public ProcessRunner beginExternalMerge(Conflict conflict, ThreeWayMerge threeWayMerge, ProcessFinishedHandler finishedHandler, OutputStream capturedStandardOutput, OutputStream capturedStandardError) throws MergeToolNotConfiguredException, PreMergeFailedException, IOException, ExternalToolException {
        ExternalTool tool;
        Check.notNull(conflict, "conflict");
        Check.notNull(threeWayMerge, "threeWayMerge");
        String fileName = conflict.getResolutionOptions().getNewPath() != null ? ServerPath.getFileName(conflict.getResolutionOptions().getNewPath()) : conflict.getTargetLocalItem();
        ExternalTool externalTool = tool = this.mergeToolset != null ? this.mergeToolset.findTool(fileName) : null;
        if (tool == null) {
            throw new MergeToolNotConfiguredException(MessageFormat.format(Messages.getString("MergeEngine.CouldNotFindExternalMergeToolForFileFormat"), threeWayMerge.getYourFileName()));
        }
        if (!this.preMerge(conflict, threeWayMerge, false)) {
            throw new PreMergeFailedException();
        }
        return threeWayMerge.beginExternalMerge(conflict, tool, finishedHandler, capturedStandardOutput, capturedStandardError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean endExternalMerge(ProcessRunner runner, Conflict conflict, ThreeWayMerge threeWayMerge) {
        Check.notNull(runner, "runner");
        Check.notNull(conflict, "conflict");
        Check.notNull(threeWayMerge, "threeWayMerge");
        try {
            boolean ret = threeWayMerge.endExternalMerge(runner);
            conflict.setMergedFileName(threeWayMerge.getMergedFileName());
            boolean bl = ret;
            return bl;
        }
        finally {
            if (threeWayMerge.getBaseFileName() != null) {
                TempStorageService.getInstance().cleanUpItem(new File(threeWayMerge.getBaseFileName()));
            }
            if (threeWayMerge.getTheirFileName() != null) {
                TempStorageService.getInstance().cleanUpItem(new File(threeWayMerge.getTheirFileName()));
            }
        }
    }

    public String beginCustomMerge(Conflict conflict, ThreeWayMerge threeWayMerge) throws PreMergeFailedException, IOException {
        Check.notNull(conflict, "conflict");
        Check.notNull(threeWayMerge, "threeWayMerge");
        if (!this.preMerge(conflict, threeWayMerge, false)) {
            throw new PreMergeFailedException();
        }
        Check.notNull(threeWayMerge.getYourFileName(), "threeWayMerge.getYourFileName()");
        String tempFilename = TempStorageService.getInstance().createTempFile(new File(LocalPath.getDirectory(threeWayMerge.getYourFileName())), LocalPath.getFileExtension(threeWayMerge.getYourFileName())).getAbsolutePath();
        FileEncoding yourEncoding = threeWayMerge.getModifiedFileEncoding();
        FileEncoding mergedEncoding = threeWayMerge.getIntermediateMergeEncoding() != null ? threeWayMerge.getIntermediateMergeEncoding() : threeWayMerge.getMergedFileEncoding();
        Charset yourCharset = CodePageMapping.getCharset(yourEncoding.getCodePage(), false);
        Charset mergedCharset = CodePageMapping.getCharset(mergedEncoding.getCodePage(), false);
        try {
            FileCopyHelper.copyText(threeWayMerge.getYourFileName(), yourCharset, tempFilename, mergedCharset);
        }
        catch (MalformedInputException e) {
            log.info((Object)("The file " + threeWayMerge.getYourFileName() + " could not be read with the encoding " + yourCharset.displayName()), (Throwable)e);
            throw new VersionControlException(MessageFormat.format(FileEncoding.ENCODING_ERROR_MESSAGE_FORMAT, Messages.getString("MergeEngine.ModifiedFile"), LocalPath.getFileName(threeWayMerge.getYourFileName()), yourCharset.displayName()), e);
        }
        catch (UnmappableCharacterException e) {
            log.info((Object)("The file " + threeWayMerge.getYourFileName() + " could not be read with the encoding " + yourCharset.displayName()), (Throwable)e);
            throw new VersionControlException(MessageFormat.format(FileEncoding.ENCODING_ERROR_MESSAGE_FORMAT, Messages.getString("MergeEngine.ModifiedFile"), LocalPath.getFileName(threeWayMerge.getYourFileName()), yourCharset.displayName()), e);
        }
        return tempFilename;
    }

    public void endCustomMerge(String mergeFilename, Conflict conflict, ThreeWayMerge threeWayMerge, boolean success) {
        Check.notNull(mergeFilename, "mergeFilename");
        Check.notNull(conflict, "conflict");
        Check.notNull(threeWayMerge, "threeWayMerge");
        if (success) {
            conflict.setMergedFileName(mergeFilename);
        } else {
            TempStorageService.getInstance().cleanUpItem(new File(mergeFilename));
        }
        if (threeWayMerge.getBaseFileName() != null) {
            TempStorageService.getInstance().cleanUpItem(new File(threeWayMerge.getBaseFileName()));
        }
        if (threeWayMerge.getTheirFileName() != null) {
            TempStorageService.getInstance().cleanUpItem(new File(threeWayMerge.getTheirFileName()));
        }
    }

    public void countContentConflicts(Conflict conflict) {
        boolean isNamespace;
        Check.notNull(conflict, "conflict");
        boolean isMerge = conflict.getType() == ConflictType.MERGE;
        boolean isGetOrCheckin = conflict.getType() == ConflictType.GET || conflict.getType() == ConflictType.CHECKIN;
        boolean bl = isNamespace = isGetOrCheckin && conflict.isNamespaceConflict();
        if (conflict.getYourItemType() != ItemType.FOLDER && !isNamespace && (conflict.getYourChangeType().contains(ChangeType.EDIT) || isMerge && conflict.isForced() && conflict.getBaseChangeType().contains(ChangeType.EDIT) || isMerge && conflict.getTheirLastMergedVersion() < conflict.getBaseVersion())) {
            if (conflict.getTheirVersion() == 0 || !isMerge && conflict.getYourVersion() == conflict.getTheirVersion() || conflict.getBaseChangeType().contains(ChangeType.DELETE)) {
                log.debug((Object)MessageFormat.format("Skipped content conflict analysis for {0}", conflict.getSourceLocalItem()));
            } else if (conflict.getMergedFileName() == null || conflict.getMergedFileName() == "") {
                try {
                    File f;
                    boolean mergeProblem;
                    boolean bl2 = mergeProblem = !this.mergeContent(conflict, true, null, null, null);
                    if ((mergeProblem || conflict.getContentMergeSummary() != null && !conflict.getResolutionOptions().isAcceptMergeWithConflicts() && conflict.getContentMergeSummary().getTotalConflictingLines() != 0) && conflict.getMergedFileName() != null && (f = new File(conflict.getMergedFileName())).exists()) {
                        f.delete();
                    }
                }
                catch (Exception e) {
                    this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this.workspace, (Throwable)e));
                }
            }
        }
    }

    public boolean mergeContent(Conflict conflict, boolean onlyCountConflicts, ProcessFinishedHandler finishedHandler, OutputStream capturedStandardOutput, OutputStream capturedStandardError) {
        Check.notNull(conflict, "conflict");
        if (!conflict.getResolutionOptions().useInternalEngine()) {
            return this.externalMergeContent(conflict, finishedHandler, capturedStandardOutput, capturedStandardError);
        }
        return this.internalMergeContent(conflict, onlyCountConflicts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalMergeContent(Conflict conflict, boolean onlyCountConflicts) {
        StringPairFileAttribute attribute2;
        GetEngine getEngine;
        FileAttributesCollection attributes;
        Check.notNull(conflict, "conflict");
        String desiredNewlineSequence = null;
        if (conflict.getTargetLocalItem() != null && conflict.getTargetLocalItem().length() > 0 && (attributes = (getEngine = new GetEngine(this.client)).getAttributesForFile(conflict.getTargetLocalItem(), conflict.getServerPath(), true)) != null && (attribute2 = attributes.getStringPairFileAttribute("client-eol")) != null && attribute2.getValue() != null) {
            desiredNewlineSequence = FileAttributeValues.getEndOfLineStringForAttributeValue(attribute2);
            if (desiredNewlineSequence == null) {
                log.error((Object)MessageFormat.format("Unsupported client end-of-line style ''{0}'' for ''{1}'' during automatic merge.  The automatically detected end-of-line style will be used instead.", attribute2.getValue(), conflict.getTargetLocalItem()));
            } else if (desiredNewlineSequence.equals("")) {
                desiredNewlineSequence = null;
            }
        }
        ThreeWayMerge twm = new ThreeWayMerge(desiredNewlineSequence);
        try {
            boolean ret = false;
            if (this.preMerge(conflict, twm, onlyCountConflicts)) {
                ret = twm.doInternalMerge(conflict, onlyCountConflicts);
                if (!onlyCountConflicts) {
                    conflict.setMergedFileName(twm.getMergedFileName());
                }
            }
            boolean bl = ret;
            return bl;
        }
        catch (Exception e) {
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this.workspace, (Throwable)e));
            boolean bl = false;
            return bl;
        }
        finally {
            if (twm.getBaseFileName() != null) {
                TempStorageService.getInstance().cleanUpItem(new File(twm.getBaseFileName()));
            }
            if (twm.getTheirFileName() != null) {
                TempStorageService.getInstance().cleanUpItem(new File(twm.getTheirFileName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean externalMergeContent(Conflict conflict, ProcessFinishedHandler finishedHandler, OutputStream capturedStandardOutput, OutputStream capturedStandardError) {
        Check.notNull(conflict, "conflict");
        ThreeWayMerge twm = new ThreeWayMerge();
        try {
            ExternalTool tool;
            String fileName = conflict.getResolutionOptions().getNewPath() != null ? ServerPath.getFileName(conflict.getResolutionOptions().getNewPath()) : conflict.getTargetLocalItem();
            ExternalTool externalTool = tool = this.mergeToolset != null ? this.mergeToolset.findTool(fileName) : null;
            if (tool == null) {
                log.warn((Object)MessageFormat.format("Could not find an external merge tool for the file {0}", conflict.getTargetLocalItem()));
                boolean bl = false;
                return bl;
            }
            if (this.preMerge(conflict, twm, false)) {
                ProcessRunner runner = twm.beginExternalMerge(conflict, tool, finishedHandler, capturedStandardOutput, capturedStandardError);
                boolean ret = twm.endExternalMerge(runner);
                conflict.setMergedFileName(twm.getMergedFileName());
                boolean bl = ret;
                return bl;
            }
        }
        catch (Exception e) {
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this.workspace, (Throwable)e));
            boolean bl = false;
            return bl;
        }
        finally {
            if (twm.getBaseFileName() != null) {
                TempStorageService.getInstance().cleanUpItem(new File(twm.getBaseFileName()));
            }
            if (twm.getTheirFileName() != null) {
                TempStorageService.getInstance().cleanUpItem(new File(twm.getTheirFileName()));
            }
        }
        return false;
    }

    private boolean preMerge(Conflict conflict, ThreeWayMerge twm, boolean onlyCountConflicts) {
        boolean useEmptyBase;
        Check.notNull(conflict, "conflict");
        Check.notNull(twm, "twm");
        FileEncoding baseFileEncoding = conflict.getBaseEncoding();
        FileEncoding theirFileEncoding = conflict.getTheirEncoding();
        FileEncoding yourFileEncoding = conflict.getYourEncoding();
        Check.notNull(baseFileEncoding, "baseFileEncoding");
        Check.notNull(theirFileEncoding, "theirFileEncoding");
        Check.notNull(yourFileEncoding, "yourFileEncoding");
        boolean encodingsDiffer = baseFileEncoding.getCodePage() > 0 && (!baseFileEncoding.equals(theirFileEncoding) || !baseFileEncoding.equals(yourFileEncoding));
        boolean anyBinary = baseFileEncoding.equals(FileEncoding.BINARY) || theirFileEncoding.equals(FileEncoding.BINARY) || yourFileEncoding.equals(FileEncoding.BINARY);
        boolean isBaselessMerge = conflict.isBaseless();
        boolean bl = useEmptyBase = !conflict.isShelvesetConflict() && isBaselessMerge && (conflict.getYourVersion() == conflict.getBaseVersion() && conflict.getYourItemID() == conflict.getBaseItemID() || conflict.getTheirVersion() == conflict.getBaseVersion() && conflict.getTheirItemID() == conflict.getBaseItemID());
        if (anyBinary && conflict.getResolutionOptions().getEncodingStrategy() != ResolutionOptions.EncodingStrategy.OVERRIDE_EXPLICIT) {
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this.workspace, (Throwable)new Exception(Messages.getString("MergeEngine.AtLeastOneInputtoMergeEngineIsBinary"))));
            return false;
        }
        if (conflict.getResolutionOptions().getEncodingStrategy() == ResolutionOptions.EncodingStrategy.OVERRIDE_EXPLICIT) {
            FileEncoding override = conflict.getResolutionOptions().getExplicitEncoding();
            Check.notNull(override, "override");
            twm.setMergedFileEncoding(override);
            twm.setBaseFileEncoding(override);
            twm.setModifiedFileEncoding(override);
            twm.setOriginalFileEncoding(override);
        } else {
            if (conflict.getResolutionOptions().getEncodingStrategy() == ResolutionOptions.EncodingStrategy.CONVERT_EXPLICIT) {
                FileEncoding convert = conflict.getResolutionOptions().getExplicitEncoding();
                Check.notNull(convert, "convert");
                twm.setIntermediateMergeEncoding(convert);
                twm.setMergedFileEncoding(yourFileEncoding);
            } else {
                if (encodingsDiffer && !onlyCountConflicts) {
                    this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this.workspace, (Throwable)new Exception(Messages.getString("MergeEngine.FilesHaveDifferentEncodingsAndConversionNotSpecified"))));
                    return false;
                }
                twm.setMergedFileEncoding(yourFileEncoding);
            }
            twm.setBaseFileEncoding(isBaselessMerge ? yourFileEncoding : baseFileEncoding);
            twm.setModifiedFileEncoding(yourFileEncoding);
            twm.setOriginalFileEncoding(theirFileEncoding);
        }
        if (conflict.getSourceLocalItem() == null || !new File(conflict.getSourceLocalItem()).exists()) {
            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this.workspace, (Throwable)new Exception(MessageFormat.format(Messages.getString("MergeEngine.MergeCannotCompleteBecauseExistingFileNotAvailableFormat"), conflict.getSourceLocalItem() == null ? "" : conflict.getSourceLocalItem()))));
            return false;
        }
        twm.setYourFileName(conflict.getSourceLocalItem());
        try {
            twm.setBaseFileName(this.getTempFilePath(ServerPath.getFileName(isBaselessMerge ? conflict.getYourServerItem() : conflict.getBaseServerItem())));
            if (useEmptyBase) {
                new File(twm.getBaseFileName()).createNewFile();
            } else if (isBaselessMerge) {
                conflict.downloadYourFile(this.client, twm.getBaseFileName());
            } else {
                conflict.downloadBaseFile(this.client, twm.getBaseFileName());
            }
            twm.setTheirFileName(this.getTempFilePath(ServerPath.getFileName(conflict.getTheirServerItem())));
            conflict.downloadTheirFile(this.client, twm.getTheirFileName());
        }
        catch (IOException e) {
            throw new VersionControlException(e);
        }
        this.createLabels(conflict, twm, isBaselessMerge);
        return true;
    }

    private void createLabels(Conflict conflict, ThreeWayMerge twm, boolean isBaselessMerge) {
        Check.notNull(conflict, "conflict");
        Check.notNull(twm, "twm");
        if (conflict.isShelvesetConflict()) {
            twm.setTheirFileLabel(MessageFormat.format(Messages.getString("MergeEngine.LabelTheirShelvesetFormat"), conflict.getTheirServerItem(), conflict.getTheirShelvesetDisplayName(this.workspace)));
            twm.setBaseFileLabel(MessageFormat.format(Messages.getString("MergeEngine.LabelOriginalFormat"), VersionedFileSpec.formatForPath(conflict.getBaseServerItem(), new ChangesetVersionSpec(conflict.getYourVersion()))));
            twm.setYourFileLabel(MessageFormat.format(Messages.getString("MergeEngine.LabelYoursFormat"), conflict.getYourServerItem()));
        } else if (conflict.getType() == ConflictType.MERGE) {
            twm.setTheirFileLabel(MessageFormat.format(Messages.getString("MergeEngine.LabelTheirsMergeFormat"), VersionedFileSpec.formatForPath(conflict.getTheirServerItem(), new ChangesetVersionSpec(conflict.getTheirVersion()))));
            twm.setBaseFileLabel(MessageFormat.format(Messages.getString("MergeEngine.LabelOriginalFormat"), VersionedFileSpec.formatForPath(isBaselessMerge ? conflict.getYourServerItem() : conflict.getBaseServerItem(), new ChangesetVersionSpec(isBaselessMerge ? conflict.getYourVersion() : conflict.getBaseVersion()))));
            twm.setYourFileLabel(MessageFormat.format(Messages.getString("MergeEngine.LabelYoursMergeFormat"), VersionedFileSpec.formatForPath(conflict.getYourServerItemSource(), new ChangesetVersionSpec(conflict.getYourVersion()))));
        } else {
            twm.setTheirFileLabel(MessageFormat.format(Messages.getString("MergeEngine.LabelTheirsFormat"), VersionedFileSpec.formatForPath(conflict.getTheirServerItem(), new ChangesetVersionSpec(conflict.getTheirVersion()))));
            twm.setBaseFileLabel(MessageFormat.format(Messages.getString("MergeEngine.LabelOriginalFormat"), VersionedFileSpec.formatForPath(conflict.getBaseServerItem(), new ChangesetVersionSpec(conflict.getYourVersion()))));
            twm.setYourFileLabel(MessageFormat.format(Messages.getString("MergeEngine.LabelYoursFormat"), conflict.getYourServerItem()));
        }
        twm.setMergedFileLabel(Messages.getString("MergeEngine.LabelMergeTarget"));
    }

    public String getTempFilePath(String fileName) {
        Check.notNullOrEmpty(fileName, "fileName");
        try {
            return new File(TempStorageService.getInstance().createTempDirectory(), fileName).getAbsolutePath();
        }
        catch (IOException e) {
            log.error((Object)MessageFormat.format("error creating merge temp file {0}", fileName), (Throwable)e);
            throw new VersionControlException(e);
        }
    }
}

