/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.Wildcard;
import java.util.concurrent.atomic.AtomicBoolean;

class IgnoreEntry {
    public final String originalExclusion;
    public final String path;
    public final String pattern;
    public final boolean isExcluded;
    public final boolean isRecursive;
    public final boolean isFolderOnly;
    public final boolean isEndsWith;
    public final boolean isStartsWith;
    public final boolean isComplex;

    public IgnoreEntry(String fullPath, boolean isExcluded, boolean isRecursive, boolean isFolderOnly) {
        this.originalExclusion = fullPath;
        String path = LocalPath.getParent(fullPath);
        String pattern = LocalPath.getFileName(fullPath);
        this.path = path;
        AtomicBoolean isEndsWith = new AtomicBoolean();
        AtomicBoolean isStartsWith = new AtomicBoolean();
        AtomicBoolean isComplex = new AtomicBoolean();
        this.pattern = this.acceptPattern(pattern, isEndsWith, isStartsWith, isComplex);
        this.isEndsWith = isEndsWith.get();
        this.isStartsWith = isStartsWith.get();
        this.isComplex = isComplex.get();
        this.isExcluded = isExcluded;
        this.isRecursive = isRecursive;
        this.isFolderOnly = isFolderOnly;
    }

    public IgnoreEntry(String pattern) {
        this.originalExclusion = pattern;
        this.path = null;
        AtomicBoolean isEndsWith = new AtomicBoolean();
        AtomicBoolean isStartsWith = new AtomicBoolean();
        AtomicBoolean isComplex = new AtomicBoolean();
        this.pattern = this.acceptPattern(pattern, isEndsWith, isStartsWith, isComplex);
        this.isEndsWith = isEndsWith.get();
        this.isStartsWith = isStartsWith.get();
        this.isComplex = isComplex.get();
        this.isExcluded = true;
        this.isRecursive = true;
        this.isFolderOnly = false;
    }

    private String acceptPattern(String pattern, AtomicBoolean isEndsWith, AtomicBoolean isStartsWith, AtomicBoolean isComplex) {
        isEndsWith.set(false);
        isStartsWith.set(false);
        isComplex.set(false);
        if (Wildcard.isWildcard(pattern)) {
            if (pattern.length() >= 2 && pattern.charAt(0) == '*' && !Wildcard.isWildcard(pattern.substring(1, pattern.length()))) {
                pattern = pattern.substring(1);
                isEndsWith.set(true);
            } else if (pattern.length() >= 2 && pattern.charAt(pattern.length() - 1) == '*' && !Wildcard.isWildcard(pattern.substring(0, pattern.length() - 1))) {
                pattern = pattern.substring(0, pattern.length() - 1);
                isStartsWith.set(true);
            } else {
                isComplex.set(true);
            }
        }
        return pattern;
    }
}

