/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.util.Check;

public class PathTranslation {
    private final String originalPath;
    private final String translatedPath;
    private final boolean isCloaked;
    private final RecursionType recursionType;

    public PathTranslation(String originalPath, String translatedPath, boolean isCloaked, RecursionType recursionType) {
        Check.notNullOrEmpty(originalPath, "originalPath");
        Check.notNull(recursionType, "recursionType");
        if (!isCloaked) {
            Check.notNullOrEmpty(translatedPath, "translatedPath");
        } else {
            Check.notEmpty(translatedPath, "translatedPath");
        }
        this.originalPath = originalPath;
        this.translatedPath = translatedPath;
        this.isCloaked = isCloaked;
        this.recursionType = recursionType;
    }

    public String getOriginalPath() {
        return this.originalPath;
    }

    public String getTranslatedPath() {
        return this.translatedPath;
    }

    public boolean isCloaked() {
        return this.isCloaked;
    }

    public RecursionType getRecursionType() {
        return this.recursionType;
    }
}

